/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.IInvocationResult;
import com.android.compatibility.common.util.IModuleResult;
import com.android.compatibility.common.util.ModuleResult;
import com.android.compatibility.common.util.RetryChecksumStatus;
import com.android.compatibility.common.util.TestStatus;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InvocationResult
implements IInvocationResult {
    private Collection<RunHistory> mRunHistories = new ArrayList<RunHistory>();
    private long mTimestamp;
    private Map<String, IModuleResult> mModuleResults = new LinkedHashMap<String, IModuleResult>();
    private Map<String, String> mInvocationInfo = new HashMap<String, String>();
    private Set<String> mSerials = new HashSet<String>();
    private String mBuildFingerprint;
    private String mTestPlan;
    private String mCommandLineArgs;
    private RetryChecksumStatus mRetryChecksumStatus = RetryChecksumStatus.NotRetry;
    private File mRetryDirectory = null;

    public Collection<RunHistory> getRunHistories() {
        return this.mRunHistories;
    }

    @Override
    public List<IModuleResult> getModules() {
        ArrayList<IModuleResult> modules = new ArrayList<IModuleResult>(this.mModuleResults.values());
        Collections.sort(modules);
        return modules;
    }

    @Override
    public int countResults(TestStatus result) {
        int total = 0;
        for (IModuleResult m : this.mModuleResults.values()) {
            total += m.countResults(result);
        }
        return total;
    }

    @Override
    public int getNotExecuted() {
        int numTests = 0;
        for (IModuleResult module : this.mModuleResults.values()) {
            numTests += module.getNotExecuted();
        }
        return numTests;
    }

    @Override
    public IModuleResult getOrCreateModule(String id) {
        IModuleResult moduleResult = this.mModuleResults.get(id);
        if (moduleResult == null) {
            moduleResult = new ModuleResult(id);
            this.mModuleResults.put(id, moduleResult);
        }
        return moduleResult;
    }

    @Override
    public void mergeModuleResult(IModuleResult moduleResult) {
        IModuleResult existingModuleResult = this.getOrCreateModule(moduleResult.getId());
        existingModuleResult.mergeFrom(moduleResult);
    }

    @Override
    public void addInvocationInfo(String key, String value) {
        this.mInvocationInfo.put(key, value);
    }

    @Override
    public Map<String, String> getInvocationInfo() {
        return this.mInvocationInfo;
    }

    @Override
    public void setStartTime(long time) {
        this.mTimestamp = time;
    }

    @Override
    public long getStartTime() {
        return this.mTimestamp;
    }

    @Override
    public void setTestPlan(String plan) {
        this.mTestPlan = plan;
    }

    @Override
    public String getTestPlan() {
        return this.mTestPlan;
    }

    @Override
    public void addDeviceSerial(String serial) {
        this.mSerials.add(serial);
    }

    @Override
    public Set<String> getDeviceSerials() {
        return this.mSerials;
    }

    @Override
    public void setCommandLineArgs(String commandLineArgs) {
        this.mCommandLineArgs = commandLineArgs;
    }

    @Override
    public String getCommandLineArgs() {
        return this.mCommandLineArgs;
    }

    @Override
    public void setBuildFingerprint(String buildFingerprint) {
        this.mBuildFingerprint = buildFingerprint;
    }

    @Override
    public String getBuildFingerprint() {
        return this.mBuildFingerprint;
    }

    @Override
    public int getModuleCompleteCount() {
        int completeModules = 0;
        for (IModuleResult module : this.mModuleResults.values()) {
            if (!module.isDone()) continue;
            ++completeModules;
        }
        return completeModules;
    }

    @Override
    public RetryChecksumStatus getRetryChecksumStatus() {
        return this.mRetryChecksumStatus;
    }

    @Override
    public void setRetryChecksumStatus(RetryChecksumStatus retryStatus) {
        this.mRetryChecksumStatus = retryStatus;
    }

    @Override
    public File getRetryDirectory() {
        return this.mRetryDirectory;
    }

    @Override
    public void setRetryDirectory(File resultDir) {
        this.mRetryDirectory = resultDir;
    }

    public static final class RunHistory {
        public long startTime;
        public long endTime;
    }
}

