/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.InfoStore;
import com.android.json.stream.JsonWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;

public class HostInfoStore
extends InfoStore {
    protected File mJsonFile;
    protected JsonWriter mJsonWriter = null;

    public HostInfoStore() {
        this.mJsonFile = null;
    }

    public HostInfoStore(File file) throws Exception {
        this.mJsonFile = file;
    }

    @Override
    public void open() throws IOException {
        FileOutputStream out = new FileOutputStream(this.mJsonFile);
        this.mJsonWriter = new JsonWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));
        this.mJsonWriter.setIndent("  ");
        this.mJsonWriter.beginObject();
    }

    @Override
    public void close() throws Exception {
        this.mJsonWriter.endObject();
        this.mJsonWriter.flush();
        this.mJsonWriter.close();
    }

    @Override
    public void startGroup() throws IOException {
        this.mJsonWriter.beginObject();
    }

    @Override
    public void startGroup(String name) throws IOException {
        this.mJsonWriter.name(name);
        this.mJsonWriter.beginObject();
    }

    @Override
    public void endGroup() throws IOException {
        this.mJsonWriter.endObject();
    }

    @Override
    public void startArray() throws IOException {
        this.mJsonWriter.beginArray();
    }

    @Override
    public void startArray(String name) throws IOException {
        HostInfoStore.checkName(name);
        this.mJsonWriter.name(name);
        this.mJsonWriter.beginArray();
    }

    @Override
    public void endArray() throws IOException {
        this.mJsonWriter.endArray();
    }

    @Override
    public void addResult(String name, int value) throws IOException {
        HostInfoStore.checkName(name);
        this.mJsonWriter.name(name);
        this.mJsonWriter.value(value);
    }

    @Override
    public void addResult(String name, long value) throws IOException {
        HostInfoStore.checkName(name);
        this.mJsonWriter.name(name);
        this.mJsonWriter.value(value);
    }

    @Override
    public void addResult(String name, float value) throws IOException {
        HostInfoStore.checkName(name);
        this.mJsonWriter.name(name);
        this.mJsonWriter.value(value);
    }

    @Override
    public void addResult(String name, double value) throws IOException {
        HostInfoStore.checkName(name);
        this.mJsonWriter.name(name);
        this.mJsonWriter.value(value);
    }

    @Override
    public void addResult(String name, boolean value) throws IOException {
        HostInfoStore.checkName(name);
        this.mJsonWriter.name(name);
        this.mJsonWriter.value(value);
    }

    @Override
    public void addResult(String name, String value) throws IOException {
        HostInfoStore.checkName(name);
        this.mJsonWriter.name(name);
        this.mJsonWriter.value(HostInfoStore.checkString(value));
    }

    @Override
    public void addArrayResult(String name, int[] array) throws IOException {
        HostInfoStore.checkName(name);
        this.mJsonWriter.name(name);
        this.mJsonWriter.beginArray();
        for (int value : HostInfoStore.checkArray(array)) {
            this.mJsonWriter.value(value);
        }
        this.mJsonWriter.endArray();
    }

    @Override
    public void addArrayResult(String name, long[] array) throws IOException {
        HostInfoStore.checkName(name);
        this.mJsonWriter.name(name);
        this.mJsonWriter.beginArray();
        for (long value : HostInfoStore.checkArray(array)) {
            this.mJsonWriter.value(value);
        }
        this.mJsonWriter.endArray();
    }

    @Override
    public void addArrayResult(String name, float[] array) throws IOException {
        HostInfoStore.checkName(name);
        this.mJsonWriter.name(name);
        this.mJsonWriter.beginArray();
        for (float value : HostInfoStore.checkArray(array)) {
            this.mJsonWriter.value(value);
        }
        this.mJsonWriter.endArray();
    }

    @Override
    public void addArrayResult(String name, double[] array) throws IOException {
        HostInfoStore.checkName(name);
        this.mJsonWriter.name(name);
        this.mJsonWriter.beginArray();
        for (double value : HostInfoStore.checkArray(array)) {
            this.mJsonWriter.value(value);
        }
        this.mJsonWriter.endArray();
    }

    @Override
    public void addArrayResult(String name, boolean[] array) throws IOException {
        HostInfoStore.checkName(name);
        this.mJsonWriter.name(name);
        this.mJsonWriter.beginArray();
        for (boolean value : HostInfoStore.checkArray(array)) {
            this.mJsonWriter.value(value);
        }
        this.mJsonWriter.endArray();
    }

    @Override
    public void addListResult(String name, List<String> list) throws IOException {
        HostInfoStore.checkName(name);
        this.mJsonWriter.name(name);
        this.mJsonWriter.beginArray();
        for (String value : HostInfoStore.checkStringList(list)) {
            this.mJsonWriter.value(HostInfoStore.checkString(value));
        }
        this.mJsonWriter.endArray();
    }

    @Override
    public void addBytesResult(String name, byte[] bytes) throws IOException {
        HostInfoStore.checkName(name);
        this.mJsonWriter.name(name);
        this.mJsonWriter.value(Base64.getEncoder().encodeToString(bytes));
    }
}

