/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class DynamicConfig {
    public static final String NS = null;
    public static final String CONFIG_TAG = "dynamicConfig";
    public static final String ENTRY_TAG = "entry";
    public static final String VALUE_TAG = "value";
    public static final String KEY_ATTR = "key";
    public static final String REMOTE_CONFIG_REQUIRED_KEY = "remote_config_required";
    public static final String REMOTE_CONFIG_RETRIEVED_KEY = "remote_config_retrieved";
    public static final String CONFIG_FOLDER_ON_DEVICE = "/sdcard/dynamic-config-files/";
    protected Map<String, List<String>> mDynamicConfigMap = new HashMap<String, List<String>>();

    public void initializeConfig(File file) throws XmlPullParserException, IOException {
        this.mDynamicConfigMap = DynamicConfig.createConfigMap(file);
    }

    public void initializeConfig(FileInputStream fileStream) throws XmlPullParserException, IOException {
        this.mDynamicConfigMap = DynamicConfig.createConfigMap(fileStream);
    }

    public String getValue(String key) {
        this.assertRemoteConfigRequirementMet();
        List<String> singleValue = this.mDynamicConfigMap.get(key);
        if (singleValue == null || singleValue.size() == 0 || singleValue.size() > 1) {
            return null;
        }
        return singleValue.get(0);
    }

    public List<String> getValues(String key) {
        this.assertRemoteConfigRequirementMet();
        return this.mDynamicConfigMap.get(key);
    }

    public Set<String> keySet() {
        this.assertRemoteConfigRequirementMet();
        return this.mDynamicConfigMap.keySet();
    }

    public boolean remoteConfigRequired() {
        if (this.mDynamicConfigMap.containsKey(REMOTE_CONFIG_REQUIRED_KEY)) {
            String val = this.mDynamicConfigMap.get(REMOTE_CONFIG_REQUIRED_KEY).get(0);
            return Boolean.parseBoolean(val);
        }
        return true;
    }

    public boolean remoteConfigRetrieved() {
        String val = this.mDynamicConfigMap.get(REMOTE_CONFIG_RETRIEVED_KEY).get(0);
        return Boolean.parseBoolean(val);
    }

    public void assertRemoteConfigRequirementMet() {
        Assert.assertTrue((String)"Remote connection to DynamicConfigService required for this test", (!this.remoteConfigRequired() || this.remoteConfigRetrieved() ? 1 : 0) != 0);
    }

    public static File getConfigFile(File configFolder, String moduleName) throws FileNotFoundException {
        File config = DynamicConfig.getConfigFileUnchecked(configFolder, moduleName);
        if (!config.exists()) {
            throw new FileNotFoundException(String.format("Cannot find %s.dynamic", moduleName));
        }
        return config;
    }

    public static File getConfigFileUnchecked(File configFolder, String moduleName) {
        return new File(configFolder, String.format("%s.dynamic", moduleName));
    }

    public static Map<String, List<String>> createConfigMap(File file) throws XmlPullParserException, IOException {
        try (FileInputStream stream = new FileInputStream(file);){
            Map<String, List<String>> map = DynamicConfig.createConfigMap(stream);
            return map;
        }
    }

    public static Map<String, List<String>> createConfigMap(FileInputStream fileStream) throws XmlPullParserException, IOException {
        HashMap<String, List<String>> dynamicConfigMap = new HashMap<String, List<String>>();
        XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
        parser.setInput((Reader)new InputStreamReader(fileStream));
        parser.nextTag();
        parser.require(2, NS, CONFIG_TAG);
        while (parser.nextTag() == 2) {
            parser.require(2, NS, ENTRY_TAG);
            String key = parser.getAttributeValue(NS, KEY_ATTR);
            ArrayList<String> valueList = new ArrayList<String>();
            while (parser.nextTag() == 2) {
                parser.require(2, NS, VALUE_TAG);
                valueList.add(parser.nextText());
                parser.require(3, NS, VALUE_TAG);
            }
            parser.require(3, NS, ENTRY_TAG);
            if (key == null || key.isEmpty()) continue;
            dynamicConfigMap.put(key, valueList);
        }
        parser.require(3, NS, CONFIG_TAG);
        return dynamicConfigMap;
    }
}

