/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.ICaseResult;
import com.android.compatibility.common.util.IInvocationResult;
import com.android.compatibility.common.util.IModuleResult;
import com.android.compatibility.common.util.ITestResult;
import com.android.compatibility.common.util.TestStatus;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;

public final class ChecksumReporter
implements Serializable {
    public static final String NAME = "checksum.data";
    public static final String PREV_NAME = "checksum.previous.data";
    private static final double DEFAULT_FPP = 0.05;
    private static final String SEPARATOR = "/";
    private static final String ID_SEPARATOR = "@";
    private static final String NAME_SEPARATOR = ".";
    private static final short CURRENT_VERSION = 1;
    static final short SERIALIZED_FORMAT_CODE = 650;
    private final BloomFilter<CharSequence> mResultChecksum;
    private final HashMap<String, byte[]> mFileChecksum;
    private final short mVersion;

    public static boolean tryCreateChecksum(File dir, IInvocationResult result) {
        try {
            int totalCount = ChecksumReporter.countTestResults(result);
            ChecksumReporter checksumReporter = new ChecksumReporter(totalCount, 0.05, 1);
            checksumReporter.addInvocation(result);
            checksumReporter.addDirectory(dir);
            checksumReporter.saveToFile(dir);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static ChecksumReporter load(File directory) throws ChecksumValidationException {
        ChecksumReporter reporter = new ChecksumReporter(directory);
        if (reporter.getCapacity() > 1.1) {
            throw new ChecksumValidationException("Capacity exceeded.");
        }
        return reporter;
    }

    /*
     * Unable to fully structure code
     */
    public ChecksumReporter(File directory) throws ChecksumValidationException {
        super();
        file = new File(directory, "checksum.data");
        try {
            fileStream = new FileInputStream(file);
            try {
                outputStream = new BufferedInputStream(fileStream);
                try {
                    objectInput = new ObjectInputStream(outputStream);
                    try {
                        magicNumber = objectInput.readShort();
                        switch (magicNumber) {
                            case 650: {
                                this.mVersion = objectInput.readShort();
                                this.mResultChecksum = (BloomFilter)objectInput.readObject();
                                this.mFileChecksum = (HashMap)objectInput.readObject();
                                ** break;
lbl17:
                                // 1 sources

                                break;
                            }
                            default: {
                                throw new ChecksumValidationException("Unknown format of serialized data.");
                            }
                        }
                    }
                    finally {
                        objectInput.close();
                    }
                }
                finally {
                    outputStream.close();
                }
            }
            finally {
                fileStream.close();
            }
        }
        catch (Exception e) {
            throw new ChecksumValidationException("Unable to load checksum from file", e);
        }
        if (this.mVersion > 1) {
            throw new ChecksumValidationException("File contains a newer version of ChecksumReporter");
        }
    }

    public ChecksumReporter(int testCount, double fpp, short version) {
        this.mResultChecksum = BloomFilter.create((Funnel)Funnels.unencodedCharsFunnel(), (int)testCount, (double)fpp);
        this.mFileChecksum = new HashMap();
        this.mVersion = version;
    }

    public void addInvocation(IInvocationResult invocationResult) {
        for (IModuleResult module : invocationResult.getModules()) {
            String buildFingerprint = invocationResult.getBuildFingerprint();
            this.addModuleResult(module, buildFingerprint);
            for (ICaseResult caseResult : module.getResults()) {
                for (ITestResult testResult : caseResult.getResults()) {
                    this.addTestResult(testResult, module, buildFingerprint);
                }
            }
        }
    }

    public void addFile(File file, String path) {
        byte[] crc;
        try {
            crc = ChecksumReporter.calculateFileChecksum(file);
        }
        catch (ChecksumValidationException e) {
            crc = new byte[]{};
        }
        String key = path + SEPARATOR + file.getName();
        this.mFileChecksum.put(key, crc);
    }

    @VisibleForTesting
    public boolean containsFile(File file, String path) {
        String key = path + SEPARATOR + file.getName();
        if (this.mFileChecksum.containsKey(key)) {
            try {
                byte[] crc = ChecksumReporter.calculateFileChecksum(file);
                return Arrays.equals(this.mFileChecksum.get(key), crc);
            }
            catch (ChecksumValidationException e) {
                return false;
            }
        }
        return false;
    }

    public void addDirectory(File directory) {
        this.addDirectory(directory, directory.getName());
    }

    private void addDirectory(File directory, String path) {
        for (String childName : directory.list()) {
            File child = new File(directory, childName);
            if (child.isDirectory()) {
                this.addDirectory(child, path + SEPARATOR + child.getName());
                continue;
            }
            this.addFile(child, path);
        }
    }

    public void addTestResult(ITestResult testResult, IModuleResult moduleResult, String buildFingerprint) {
        String signature = ChecksumReporter.generateTestResultSignature(testResult, moduleResult, buildFingerprint);
        this.mResultChecksum.put((Object)signature);
    }

    @VisibleForTesting
    public boolean containsTestResult(ITestResult testResult, IModuleResult moduleResult, String buildFingerprint) {
        String signature = ChecksumReporter.generateTestResultSignature(testResult, moduleResult, buildFingerprint);
        return this.mResultChecksum.mightContain((Object)signature);
    }

    public void addModuleResult(IModuleResult moduleResult, String buildFingerprint) {
        this.mResultChecksum.put((Object)ChecksumReporter.generateModuleResultSignature(moduleResult, buildFingerprint));
        this.mResultChecksum.put((Object)ChecksumReporter.generateModuleSummarySignature(moduleResult, buildFingerprint));
    }

    @VisibleForTesting
    public Boolean containsModuleResult(IModuleResult moduleResult, String buildFingerprint) {
        return this.mResultChecksum.mightContain((Object)ChecksumReporter.generateModuleResultSignature(moduleResult, buildFingerprint));
    }

    public void saveToFile(File directory) throws IOException {
        File file = new File(directory, NAME);
        try (FileOutputStream fileStream = new FileOutputStream(file, false);
             BufferedOutputStream outputStream = new BufferedOutputStream(fileStream);
             ObjectOutputStream objectOutput = new ObjectOutputStream(outputStream);){
            objectOutput.writeShort(650);
            objectOutput.writeShort(this.mVersion);
            objectOutput.writeObject(this.mResultChecksum);
            objectOutput.writeObject(this.mFileChecksum);
        }
    }

    @VisibleForTesting
    double getCapacity() {
        return this.mResultChecksum.expectedFpp() / 0.05;
    }

    static String generateTestResultSignature(ITestResult testResult, IModuleResult module, String buildFingerprint) {
        StringBuilder sb = new StringBuilder();
        String stacktrace = testResult.getStackTrace();
        stacktrace = stacktrace == null ? "" : stacktrace.trim();
        stacktrace = stacktrace.replaceAll("\\r?\\n|\\r", "");
        sb.append(buildFingerprint).append(SEPARATOR).append(module.getId()).append(SEPARATOR).append(testResult.getFullName()).append(SEPARATOR).append(testResult.getResultStatus().getValue()).append(SEPARATOR).append(stacktrace).append(SEPARATOR);
        return sb.toString();
    }

    static String generateTestResultSignature(String packageName, String suiteName, String caseName, String testName, String abi, String status, String stacktrace, String buildFingerprint) {
        String testId = ChecksumReporter.buildTestId(suiteName, caseName, testName, abi);
        StringBuilder sb = new StringBuilder();
        stacktrace = stacktrace == null ? "" : stacktrace.trim();
        stacktrace = stacktrace.replaceAll("\\r?\\n|\\r", "");
        sb.append(buildFingerprint).append(SEPARATOR).append(packageName).append(SEPARATOR).append(testId).append(SEPARATOR).append(status).append(SEPARATOR).append(stacktrace).append(SEPARATOR);
        return sb.toString();
    }

    private static String buildTestId(String suiteName, String caseName, String testName, String abi) {
        String name = Joiner.on((String)NAME_SEPARATOR).skipNulls().join((Object)Strings.emptyToNull((String)suiteName), (Object)Strings.emptyToNull((String)caseName), new Object[]{Strings.emptyToNull((String)testName)});
        return Joiner.on((String)ID_SEPARATOR).skipNulls().join((Object)Strings.emptyToNull((String)name), (Object)Strings.emptyToNull((String)abi), new Object[0]);
    }

    private static String generateModuleResultSignature(IModuleResult module, String buildFingerprint) {
        StringBuilder sb = new StringBuilder();
        sb.append(buildFingerprint).append(SEPARATOR).append(module.getId()).append(SEPARATOR).append(module.isDone()).append(SEPARATOR).append(module.countResults(TestStatus.FAIL));
        return sb.toString();
    }

    private static String generateModuleSummarySignature(IModuleResult module, String buildFingerprint) {
        StringBuilder sb = new StringBuilder();
        sb.append(buildFingerprint).append(SEPARATOR).append(module.getId()).append(SEPARATOR).append(module.countResults(TestStatus.FAIL));
        return sb.toString();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static byte[] calculateFileChecksum(File file) throws ChecksumValidationException {
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] byArray;
            try (BufferedInputStream inputStream = new BufferedInputStream(fis);){
                int cnt;
                MessageDigest hashSum = MessageDigest.getInstance("SHA-256");
                int bufferSize = 8192;
                byte[] buffer = new byte[bufferSize];
                while ((cnt = ((InputStream)inputStream).read(buffer)) != -1) {
                    hashSum.update(buffer, 0, cnt);
                }
                byte[] partialHash = new byte[32];
                hashSum.digest(partialHash, 0, 32);
                byArray = partialHash;
            }
            return byArray;
        }
        catch (NoSuchAlgorithmException e) {
            throw new ChecksumValidationException("Unable to hash file.", e);
        }
        catch (IOException e) {
            throw new ChecksumValidationException("Unable to hash file.", e);
        }
        catch (DigestException e) {
            throw new ChecksumValidationException("Unable to hash file.", e);
        }
    }

    private static int countTestResults(IInvocationResult invocation) {
        int count = 0;
        for (IModuleResult module : invocation.getModules()) {
            count += 2;
            for (ICaseResult caseResult : module.getResults()) {
                count += caseResult.getResults().size();
            }
        }
        return count;
    }

    public static class ChecksumValidationException
    extends Exception {
        public ChecksumValidationException(String detailMessage) {
            super(detailMessage);
        }

        public ChecksumValidationException(String detailMessage, Throwable throwable) {
            super(detailMessage, throwable);
        }
    }
}

