/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.BusinessLogic;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BusinessLogicFactory {
    private static final String BUSINESS_LOGIC_RULES_LISTS = "businessLogicRulesLists";
    private static final String TEST_NAME = "testName";
    private static final String BUSINESS_LOGIC_RULES = "businessLogicRules";
    private static final String RULE_CONDITIONS = "ruleConditions";
    private static final String RULE_ACTIONS = "ruleActions";
    private static final String RULES_LIST_DESCRIPTION = "description";
    private static final String METHOD_NAME = "methodName";
    private static final String METHOD_ARGS = "methodArgs";
    private static final String AUTHENTICATION_STATUS = "authenticationStatus";
    public static final String CONDITIONAL_TESTS_ENABLED = "conditionalTestsEnabled";
    private static final String TIMESTAMP = "timestamp";
    private static final String TIMESTAMP_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final String REDACTION_REGEXES = "redactionRegexes";

    public static BusinessLogic createFromFile(FileInputStream stream) {
        try {
            String businessLogicString = BusinessLogicFactory.readStream(stream);
            return BusinessLogicFactory.createBL(businessLogicString);
        }
        catch (IOException e) {
            throw new RuntimeException("Business Logic failed", e);
        }
    }

    public static BusinessLogic createFromFile(File f) {
        try {
            String businessLogicString = BusinessLogicFactory.readFile(f);
            return BusinessLogicFactory.createBL(businessLogicString);
        }
        catch (IOException e) {
            throw new RuntimeException("Business Logic failed", e);
        }
    }

    private static BusinessLogic createBL(String businessLogicString) {
        HashMap<String, List<BusinessLogic.BusinessLogicRulesList>> rulesMap = new HashMap<String, List<BusinessLogic.BusinessLogicRulesList>>();
        BusinessLogic bl = new BusinessLogic();
        try {
            JSONObject root = new JSONObject(businessLogicString);
            JSONArray jsonRulesLists = null;
            if (root.has(AUTHENTICATION_STATUS)) {
                String authStatus = root.getString(AUTHENTICATION_STATUS);
                bl.setAuthenticationStatus(authStatus);
            }
            if (root.has(CONDITIONAL_TESTS_ENABLED)) {
                boolean enabled;
                bl.mConditionalTestsEnabled = enabled = root.getBoolean(CONDITIONAL_TESTS_ENABLED);
            }
            if (root.has(TIMESTAMP)) {
                bl.mTimestamp = BusinessLogicFactory.parseTimestamp(root.getString(TIMESTAMP));
            }
            if (root.has(REDACTION_REGEXES)) {
                bl.mRedactionRegexes = BusinessLogicFactory.parseRedactionRegexes(root.getJSONArray(REDACTION_REGEXES));
            }
            try {
                jsonRulesLists = root.getJSONArray(BUSINESS_LOGIC_RULES_LISTS);
            }
            catch (JSONException e) {
                bl.mRules = rulesMap;
                return bl;
            }
            for (int i = 0; i < jsonRulesLists.length(); ++i) {
                JSONObject jsonRulesList = jsonRulesLists.getJSONObject(i);
                String testName = jsonRulesList.getString(TEST_NAME);
                ArrayList<BusinessLogic.BusinessLogicRulesList> testRulesLists = (ArrayList<BusinessLogic.BusinessLogicRulesList>)rulesMap.get(testName);
                if (testRulesLists == null) {
                    testRulesLists = new ArrayList<BusinessLogic.BusinessLogicRulesList>();
                }
                testRulesLists.add(BusinessLogicFactory.extractRulesList(jsonRulesList));
                rulesMap.put(testName, testRulesLists);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("Business Logic failed", e);
        }
        bl.mRules = rulesMap;
        return bl;
    }

    private static List<String> parseRedactionRegexes(JSONArray redactionRegexesJSONArray) throws JSONException {
        ArrayList<String> redactionRegexes = new ArrayList<String>();
        for (int i = 0; i < redactionRegexesJSONArray.length(); ++i) {
            redactionRegexes.add(redactionRegexesJSONArray.getString(i));
        }
        return redactionRegexes;
    }

    private static BusinessLogic.BusinessLogicRulesList extractRulesList(JSONObject rulesListJSONObject) throws JSONException {
        String description = null;
        try {
            description = rulesListJSONObject.getString(RULES_LIST_DESCRIPTION);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        ArrayList<BusinessLogic.BusinessLogicRule> rules = new ArrayList<BusinessLogic.BusinessLogicRule>();
        JSONArray rulesJSONArray = null;
        try {
            rulesJSONArray = rulesListJSONObject.getJSONArray(BUSINESS_LOGIC_RULES);
        }
        catch (JSONException e) {
            return new BusinessLogic.BusinessLogicRulesList(rules, description);
        }
        for (int j = 0; j < rulesJSONArray.length(); ++j) {
            JSONObject ruleJSONObject = rulesJSONArray.getJSONObject(j);
            List<BusinessLogic.BusinessLogicRuleCondition> ruleConditions = BusinessLogicFactory.extractRuleConditionList(ruleJSONObject);
            List<BusinessLogic.BusinessLogicRuleAction> ruleActions = BusinessLogicFactory.extractRuleActionList(ruleJSONObject);
            rules.add(new BusinessLogic.BusinessLogicRule(ruleConditions, ruleActions));
        }
        return new BusinessLogic.BusinessLogicRulesList(rules, description);
    }

    private static List<BusinessLogic.BusinessLogicRuleCondition> extractRuleConditionList(JSONObject ruleJSONObject) throws JSONException {
        ArrayList<BusinessLogic.BusinessLogicRuleCondition> ruleConditions = new ArrayList<BusinessLogic.BusinessLogicRuleCondition>();
        JSONArray ruleConditionsJSONArray = null;
        try {
            ruleConditionsJSONArray = ruleJSONObject.getJSONArray(RULE_CONDITIONS);
        }
        catch (JSONException e) {
            return ruleConditions;
        }
        for (int i = 0; i < ruleConditionsJSONArray.length(); ++i) {
            JSONObject ruleConditionJSONObject = ruleConditionsJSONArray.getJSONObject(i);
            String methodName = ruleConditionJSONObject.getString(METHOD_NAME);
            boolean negated = false;
            if (methodName.startsWith("!")) {
                methodName = methodName.substring(1);
                negated = true;
            }
            ArrayList<String> methodArgs = new ArrayList<String>();
            JSONArray methodArgsJSONArray = null;
            try {
                methodArgsJSONArray = ruleConditionJSONObject.getJSONArray(METHOD_ARGS);
            }
            catch (JSONException e) {
                ruleConditions.add(new BusinessLogic.BusinessLogicRuleCondition(methodName, methodArgs, negated));
                continue;
            }
            for (int j = 0; j < methodArgsJSONArray.length(); ++j) {
                methodArgs.add(methodArgsJSONArray.getString(j));
            }
            ruleConditions.add(new BusinessLogic.BusinessLogicRuleCondition(methodName, methodArgs, negated));
        }
        return ruleConditions;
    }

    private static List<BusinessLogic.BusinessLogicRuleAction> extractRuleActionList(JSONObject ruleJSONObject) throws JSONException {
        ArrayList<BusinessLogic.BusinessLogicRuleAction> ruleActions = new ArrayList<BusinessLogic.BusinessLogicRuleAction>();
        JSONArray ruleActionsJSONArray = ruleJSONObject.getJSONArray(RULE_ACTIONS);
        for (int i = 0; i < ruleActionsJSONArray.length(); ++i) {
            JSONObject ruleActionJSONObject = ruleActionsJSONArray.getJSONObject(i);
            String methodName = ruleActionJSONObject.getString(METHOD_NAME);
            ArrayList<String> methodArgs = new ArrayList<String>();
            JSONArray methodArgsJSONArray = null;
            try {
                methodArgsJSONArray = ruleActionJSONObject.getJSONArray(METHOD_ARGS);
            }
            catch (JSONException e) {
                ruleActions.add(new BusinessLogic.BusinessLogicRuleAction(methodName, methodArgs));
                continue;
            }
            for (int j = 0; j < methodArgsJSONArray.length(); ++j) {
                methodArgs.add(methodArgsJSONArray.getString(j));
            }
            ruleActions.add(new BusinessLogic.BusinessLogicRuleAction(methodName, methodArgs));
        }
        return ruleActions;
    }

    private static Date parseTimestamp(String timestamp) {
        SimpleDateFormat format = new SimpleDateFormat(TIMESTAMP_PATTERN);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            return format.parse(timestamp);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private static String readFile(File f) throws IOException {
        StringBuilder sb = new StringBuilder((int)f.length());
        String lineSeparator = System.getProperty("line.separator");
        try (Scanner scanner = new Scanner(f);){
            while (scanner.hasNextLine()) {
                sb.append(scanner.nextLine() + lineSeparator);
            }
            String string = sb.toString();
            return string;
        }
    }

    private static String readStream(FileInputStream stream) throws IOException {
        int irChar = -1;
        StringBuilder builder = new StringBuilder();
        try (BufferedReader ir = new BufferedReader(new InputStreamReader(stream));){
            while ((irChar = ((Reader)ir).read()) != -1) {
                builder.append((char)irChar);
            }
        }
        return builder.toString();
    }
}

