/*
 * Decompiled with CFR 0.152.
 */
package com.android.catbox.util;

import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.math.Quantiles;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TestMetricsUtil {
    private static final String TEST_HEADER_SEPARATOR = "\n\n";
    private static final String METRIC_SEPARATOR = "\n";
    private static final String METRIC_KEY_VALUE_SEPARATOR = ":";
    private static final String STATS_KEY_MIN = "min";
    private static final String STATS_KEY_MAX = "max";
    private static final String STATS_KEY_MEAN = "mean";
    private static final String STATS_KEY_VAR = "var";
    private static final String STATS_KEY_STDEV = "stdev";
    private static final String STATS_KEY_MEDIAN = "median";
    private static final String STATS_KEY_TOTAL = "total";
    private static final String STATS_KEY_COUNT = "metric-count";
    private static final String STATS_KEY_PERCENTILE_PREFIX = "p";
    private static final String STATS_KEY_SEPARATOR = "-";
    private static final Joiner CLASS_METHOD_JOINER = Joiner.on((String)"#").skipNulls();
    private String mTestIterationSeparator = "$";
    private Set<Integer> mActualPercentiles = new HashSet<Integer>();
    private Map<String, ArrayListMultimap<String, MetricMeasurement.Metric>> mStoredTestMetrics = new HashMap<String, ArrayListMultimap<String, MetricMeasurement.Metric>>();

    public void storeTestMetrics(TestDescription testDescription, Map<String, MetricMeasurement.Metric> testMetrics) {
        String newTestId;
        if (testMetrics == null) {
            return;
        }
        String className = testDescription.getClassName();
        int iterationSeparatorIndex = testDescription.getClassName().indexOf(this.mTestIterationSeparator);
        if (iterationSeparatorIndex != -1) {
            className = testDescription.getClassName().substring(0, iterationSeparatorIndex);
        }
        if (!this.mStoredTestMetrics.containsKey(newTestId = CLASS_METHOD_JOINER.join((Object)className, (Object)testDescription.getTestName(), new Object[0]))) {
            this.mStoredTestMetrics.put(newTestId, (ArrayListMultimap<String, MetricMeasurement.Metric>)ArrayListMultimap.create());
        }
        ArrayListMultimap<String, MetricMeasurement.Metric> storedMetricsForThisTest = this.mStoredTestMetrics.get(newTestId);
        HashMap<String, MetricMeasurement.Metric> rawMetrics = this.getRawMetricsOnly(testMetrics);
        for (Map.Entry<String, MetricMeasurement.Metric> entry : rawMetrics.entrySet()) {
            String key = entry.getKey();
            if (key.indexOf(this.mTestIterationSeparator) != -1 && key.contains(testDescription.getClassName())) {
                key = key.substring(0, key.indexOf(this.mTestIterationSeparator));
                key = CLASS_METHOD_JOINER.join((Object)key, (Object)testDescription.getTestName(), new Object[0]);
            }
            storedMetricsForThisTest.put((Object)key, (Object)entry.getValue());
        }
    }

    public Map<String, Map<String, String>> getAggregatedStoredTestMetrics() {
        HashMap<String, Map<String, String>> aggregatedStoredMetrics = new HashMap<String, Map<String, String>>();
        for (String testName : this.mStoredTestMetrics.keySet()) {
            ArrayListMultimap<String, MetricMeasurement.Metric> currentTest = this.mStoredTestMetrics.get(testName);
            LinkedHashMap<String, MetricMeasurement.Metric> aggregateMetrics = new LinkedHashMap<String, MetricMeasurement.Metric>();
            for (String metricKey : currentTest.keySet()) {
                List metrics = currentTest.get((Object)metricKey);
                List measures = metrics.stream().map(MetricMeasurement.Metric::getMeasurements).collect(Collectors.toList());
                List<String> rawValues = measures.stream().map(MetricMeasurement.Measurements::getSingleString).map(m -> {
                    List<String> splitVals = Arrays.asList(m.split(",", 0));
                    if (splitVals.size() == 1 && splitVals.get(0).isEmpty()) {
                        return Collections.emptyList();
                    }
                    return splitVals;
                }).flatMap(Collection::stream).map(String::trim).collect(Collectors.toList());
                if (rawValues.isEmpty() || !TestMetricsUtil.isAllDoubleValues(rawValues)) continue;
                this.buildStats(metricKey, rawValues, aggregateMetrics);
            }
            Map compatibleTestMetrics = TfMetricProtoUtil.compatibleConvert(aggregateMetrics);
            aggregatedStoredMetrics.put(testName, compatibleTestMetrics);
        }
        return aggregatedStoredMetrics;
    }

    public void setPercentiles(Set<Integer> percentiles) {
        this.mActualPercentiles = percentiles;
    }

    public void setIterationSeparator(String separator) {
        this.mTestIterationSeparator = separator;
    }

    public Map<String, ArrayListMultimap<String, MetricMeasurement.Metric>> getStoredTestMetric() {
        return this.mStoredTestMetrics;
    }

    public static boolean isAllDoubleValues(List<String> rawValues) {
        return rawValues.stream().allMatch(val -> {
            try {
                Double.parseDouble(val);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
    }

    public static Map<String, Double> getStats(Collection<Double> values, Set<Integer> percentiles) {
        LinkedHashMap<String, Double> stats = new LinkedHashMap<String, Double>();
        double sum = values.stream().mapToDouble(Double::doubleValue).sum();
        double count = values.size();
        double mean = values.stream().mapToDouble(Double::doubleValue).average().orElseThrow(IllegalStateException::new);
        double variance = values.stream().reduce(0.0, (a, b) -> a + Math.pow(b - mean, 2.0) / count);
        HashSet<Integer> updatedPercentile = new HashSet<Integer>(percentiles);
        updatedPercentile.add(50);
        Map percentileStat = Quantiles.percentiles().indexes(updatedPercentile).compute(values);
        double median = (Double)percentileStat.get(50);
        stats.put(STATS_KEY_MIN, Collections.min(values));
        stats.put(STATS_KEY_MAX, Collections.max(values));
        stats.put(STATS_KEY_MEAN, mean);
        stats.put(STATS_KEY_VAR, variance);
        stats.put(STATS_KEY_STDEV, Math.sqrt(variance));
        stats.put(STATS_KEY_MEDIAN, median);
        stats.put(STATS_KEY_TOTAL, sum);
        stats.put(STATS_KEY_COUNT, count);
        percentileStat.entrySet().stream().forEach(e -> {
            if ((Integer)e.getKey() != 50 || percentiles.contains(50)) {
                stats.put(STATS_KEY_PERCENTILE_PREFIX + ((Integer)e.getKey()).toString(), (Double)e.getValue());
            }
        });
        return stats;
    }

    private void buildStats(String metricKey, List<String> values, Map<String, MetricMeasurement.Metric> aggregateMetrics) {
        List<Double> doubleValues = values.stream().map(Double::parseDouble).collect(Collectors.toList());
        Map<String, Double> stats = TestMetricsUtil.getStats(doubleValues, this.mActualPercentiles);
        for (String statKey : stats.keySet()) {
            MetricMeasurement.Metric.Builder metricBuilder = MetricMeasurement.Metric.newBuilder();
            metricBuilder.getMeasurementsBuilder().setSingleString(String.format("%2.2f", stats.get(statKey)));
            aggregateMetrics.put(String.join((CharSequence)STATS_KEY_SEPARATOR, metricKey, statKey), metricBuilder.build());
        }
    }

    private HashMap<String, MetricMeasurement.Metric> getRawMetricsOnly(Map<String, MetricMeasurement.Metric> metrics) {
        HashMap<String, MetricMeasurement.Metric> rawMetrics = new HashMap<String, MetricMeasurement.Metric>();
        for (Map.Entry<String, MetricMeasurement.Metric> entry : metrics.entrySet()) {
            if (!MetricMeasurement.DataType.RAW.equals((Object)entry.getValue().getType())) continue;
            rawMetrics.put(entry.getKey(), entry.getValue());
        }
        return rawMetrics;
    }
}

