/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.result.suite;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.proto.FileProtoResultReporter;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.util.IDisableable;
import java.io.File;
import java.io.FileNotFoundException;

@OptionClass(alias="result-reporter")
public class CompatibilityProtoResultReporter
extends FileProtoResultReporter
implements IDisableable {
    public static final String PROTO_FILE_NAME = "test-record.pb";
    public static final String PROTO_DIR = "proto";
    @Option(name="disable", description="Whether or not to disable this reporter.")
    private boolean mDisable = false;
    private CompatibilityBuildHelper mBuildHelper;
    private File mResultDir = null;
    private File mBaseProtoFile = null;

    public void processStartInvocation(TestRecordProto.TestRecord invocationStartRecord, IInvocationContext invocationContext) {
        if (this.mBuildHelper == null) {
            this.mBuildHelper = new CompatibilityBuildHelper((IBuildInfo)invocationContext.getBuildInfos().get(0));
            this.mResultDir = CompatibilityProtoResultReporter.getProtoResultDirectory(this.mBuildHelper);
            this.mBaseProtoFile = new File(this.mResultDir, PROTO_FILE_NAME);
            this.setFileOutput(this.mBaseProtoFile);
        }
        super.processStartInvocation(invocationStartRecord, invocationContext);
    }

    public static File getProtoResultDirectory(CompatibilityBuildHelper buildHelper) {
        File protoDir = null;
        try {
            File resultDir = buildHelper.getResultDir();
            if (resultDir != null) {
                resultDir.mkdirs();
            }
            protoDir = new File(resultDir, PROTO_DIR);
            protoDir.mkdir();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (!protoDir.exists()) {
            throw new RuntimeException("Result Directory was not created: " + protoDir.getAbsolutePath());
        }
        LogUtil.CLog.d((String)"Proto Results Directory: %s", (Object[])new Object[]{protoDir.getAbsolutePath()});
        return protoDir;
    }

    public boolean isDisabled() {
        return this.mDisable;
    }
}

