/*
 * Decompiled with CFR 0.152.
 */
package com.android.catbox.targetpreparer;

import com.android.ddmlib.Log;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

@OptionClass(alias="skip-test-preparer")
public class SkipTestPreparer
extends BaseTargetPreparer {
    @Option(name="comp-property", description="ADB property of device to check against")
    private String mCompProp;
    @Option(name="comp-property-int-value", description="Integer value of ADB property to check against")
    private int mPropVal;
    @Option(name="int-comparison-operator", description="Operator to compare expected and actual int values")
    private String mCompOperator;
    private static final Set<String> supportedOperators = ImmutableSet.of((Object)"lt", (Object)"gt", (Object)"eq", (Object)"neq");

    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        if (this.mCompProp == null || this.mCompOperator == null) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Missing value for comp-property or comp-property-int-value. Skipping preparer.");
            return;
        }
        boolean skipTestFlag = false;
        if (!supportedOperators.contains(this.mCompOperator)) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.WARN, (String)String.format("Incompatible operator %s. Skipping preparer", this.mCompOperator));
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)String.format("Supported operators are %s", String.join((CharSequence)",", supportedOperators)));
            return;
        }
        int devicePropertyValue = Integer.parseInt(device.executeShellCommand(String.format("getprop %s", this.mCompProp)).trim());
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)String.format("%s returned %d", this.mCompProp, devicePropertyValue));
        skipTestFlag = this.getSkipTestFlag(devicePropertyValue);
        if (skipTestFlag) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Skip condition satisfied. Skipping test module.");
            throw new TargetSetupError(String.format("Test incompatible with %s = %d", this.mCompProp, devicePropertyValue), device.getDeviceDescriptor());
        }
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Skip condition not satisfied. Proceeding with test module.");
    }

    private boolean getSkipTestFlag(int devicePropertyValue) {
        switch (this.mCompOperator) {
            case "lt": {
                LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Checking skip condition %d < %d", (Object[])new Object[]{devicePropertyValue, this.mPropVal});
                return devicePropertyValue < this.mPropVal;
            }
            case "gt": {
                LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Checking skip condition %d > %d", (Object[])new Object[]{devicePropertyValue, this.mPropVal});
                return devicePropertyValue > this.mPropVal;
            }
            case "eq": {
                LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Checking skip condition %d == %d", (Object[])new Object[]{devicePropertyValue, this.mPropVal});
                return devicePropertyValue == this.mPropVal;
            }
            case "neq": {
                LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Checking condition %d != %d", (Object[])new Object[]{devicePropertyValue, this.mPropVal});
                return devicePropertyValue != this.mPropVal;
            }
        }
        return false;
    }
}

