/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.testtype;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.util.BusinessLogic;
import com.android.compatibility.common.util.BusinessLogicExecutor;
import com.android.compatibility.common.util.BusinessLogicFactory;
import com.android.compatibility.common.util.BusinessLogicHostExecutor;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.testtype.junit4.BaseHostJUnit4Test;
import java.io.File;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;

public class BusinessLogicHostTestBase
extends BaseHostJUnit4Test {
    private static final String PARAM_START = "[";
    @Rule
    public TestName mTestCase = new TestName();
    protected BusinessLogic mBusinessLogic;
    protected boolean mCanReadBusinessLogic = true;

    @Before
    public void handleBusinessLogic() {
        this.loadBusinessLogic();
        this.executeBusinessLogic();
    }

    protected void executeBusinessLogic() {
        String testName;
        String methodName = this.mTestCase.getMethodName();
        Assert.assertTrue((String)String.format("Test \"%s\" is unable to execute as it depends on the missing remote configuration.", methodName), (boolean)this.mCanReadBusinessLogic);
        if (methodName.contains(PARAM_START)) {
            methodName = methodName.substring(0, methodName.lastIndexOf(PARAM_START));
        }
        if (this.mBusinessLogic.hasLogicFor(testName = String.format("%s#%s", ((Object)((Object)this)).getClass().getName(), methodName))) {
            LogUtil.CLog.i((String)"Applying business logic for test case: ", (Object[])new Object[]{testName});
            BusinessLogicHostExecutor executor = new BusinessLogicHostExecutor(this.getDevice(), this.getBuild(), (Object)this, this.mBusinessLogic.getRedactionRegexes());
            this.mBusinessLogic.applyLogicFor(testName, (BusinessLogicExecutor)executor);
        }
    }

    protected void loadBusinessLogic() {
        File businessLogicFile = null;
        CompatibilityBuildHelper helper = new CompatibilityBuildHelper(this.getBuild());
        if (helper.hasBusinessLogicHostFile()) {
            businessLogicFile = helper.getBusinessLogicHostFile();
        } else {
            String bitness = this.getAbi() != null ? this.getAbi().getBitness() : "";
            String moduleName = this.getInvocationContext().getConfigurationDescriptor().getModuleName();
            businessLogicFile = helper.getBusinessLogicHostFile(bitness + moduleName);
        }
        if (businessLogicFile != null && businessLogicFile.canRead()) {
            this.mBusinessLogic = BusinessLogicFactory.createFromFile((File)businessLogicFile);
        } else {
            this.mCanReadBusinessLogic = false;
        }
    }

    public static void skipTest(String message) {
        Assume.assumeTrue((String)message, (boolean)false);
    }

    public static void failTest(String message) {
        Assert.fail((String)message);
    }
}

