/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.targetprep;

import com.android.ddmlib.Log;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.AaptParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

@OptionClass(alias="device-interaction-helper", global_namespace=false)
public class DeviceInteractionHelperInstaller
extends BaseTargetPreparer {
    @Option(name="default-package", description="name of the package containing fallback device interaction helpers")
    private String mDefaultHelperPackage = "com.android.cts.helpers.aosp";
    @Option(name="property-name", description="name of a device property listing necessary OEM helper packages")
    private String mHelperPackagePropertyKey = "ro.vendor.cts_interaction_helper_packages";
    private Set<String> mInstalledPackages = new HashSet<String>();

    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        String defaultHelperName = this.mDefaultHelperPackage + ".apk";
        try {
            File defaultHelpers = testInfo.getDependencyFile(defaultHelperName, true);
            this.installHelperApk(device, defaultHelpers, this.mDefaultHelperPackage);
        }
        catch (FileNotFoundException e) {
            throw new BuildError("Unable to find " + defaultHelperName + ". Make sure the file is present in your testcases directory or set  an explicit path with default-interaction-helper-package.", device.getDeviceDescriptor());
        }
        String searchPath = device.getProperty(this.mHelperPackagePropertyKey);
        if (searchPath == null || searchPath.isEmpty()) {
            return;
        }
        for (String pkg : searchPath.split(":")) {
            if (pkg.isEmpty() || this.mInstalledPackages.contains(pkg)) continue;
            try {
                String apkName = pkg + ".apk";
                File apkFile = testInfo.getDependencyFile(apkName, true);
                this.checkApkFile(device, apkFile, pkg);
                this.installHelperApk(device, apkFile, pkg);
            }
            catch (FileNotFoundException e) {
                LogUtil.CLog.w((String)"Unable to find apk for %s", (Object[])new Object[]{pkg});
            }
        }
    }

    public void tearDown(TestInformation testInfo, Throwable t) throws DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        for (String pkg : this.mInstalledPackages) {
            String msg = device.uninstallPackage(pkg);
            if (msg == null) continue;
            LogUtil.CLog.w((String)String.format("Error uninstalling package '%s': %s", pkg, msg));
        }
    }

    private void checkApkFile(ITestDevice device, File apkFile, String expectedPackage) throws BuildError {
        String path = apkFile.getPath();
        if (!apkFile.canRead()) {
            throw new BuildError("Helper " + path + " does not exist or is unreadable.", device.getDeviceDescriptor());
        }
        AaptParser parser = this.parseApk(apkFile);
        if (parser == null) {
            throw new BuildError("Unable to parse helper apk " + path, device.getDeviceDescriptor());
        }
        String apkPackage = parser.getPackageName();
        if (apkPackage == null || apkPackage.isEmpty()) {
            throw new BuildError("Unable to parse helper apk " + path, device.getDeviceDescriptor());
        }
        if (!expectedPackage.equals(apkPackage)) {
            throw new BuildError(String.format("Helper apk %s declares package %s but was expected to declare %s", path, apkPackage, expectedPackage), device.getDeviceDescriptor());
        }
    }

    protected AaptParser parseApk(File apkFile) {
        return AaptParser.parse((File)apkFile);
    }

    private void installHelperApk(ITestDevice device, File apkFile, String apkPackage) throws BuildError, DeviceNotAvailableException, TargetSetupError {
        String msg;
        if (apkFile == null) {
            throw new BuildError("Invalid apk name", device.getDeviceDescriptor());
        }
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Installing %s from %s", (Object[])new Object[]{apkFile.getName(), apkFile.getPath()});
        ArrayList<String> extraArgs = new ArrayList<String>();
        if (device.isAppEnumerationSupported()) {
            extraArgs.add("--force-queryable");
        }
        if ((msg = device.installPackage(apkFile, true, extraArgs.toArray(new String[0]))) != null) {
            throw new TargetSetupError(String.format("Failed to install %s: %s", apkFile.getName(), msg), device.getDeviceDescriptor());
        }
        this.mInstalledPackages.add(apkPackage);
    }
}

