/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.targetprep;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.tradefed.util.DynamicConfigFileReader;
import com.android.compatibility.common.util.BusinessLogic;
import com.android.compatibility.common.util.BusinessLogicFactory;
import com.android.compatibility.common.util.FeatureUtil;
import com.android.compatibility.common.util.PropertyUtil;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IAbiReceiver;
import com.android.tradefed.testtype.IInvocationContextReceiver;
import com.android.tradefed.testtype.suite.TestSuiteInfo;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.MultiMap;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.net.HttpHelper;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParserException;

@OptionClass(alias="business-logic-preparer")
public class BusinessLogicPreparer
extends BaseTargetPreparer
implements IAbiReceiver,
IInvocationContextReceiver {
    private static final String SUITE_PLACEHOLDER = "{suite-name}";
    private static final String GLOBAL_APE_API_KEY = "ape-api-key";
    private static final String FILE_LOCATION = "business-logic";
    private static final String BL_CACHE_FILE = "business-logic-cache";
    private static final int BL_CACHE_DAYS = 5;
    private static final long BL_CACHE_MILLIS = 432000000L;
    private static final String FILE_EXT = ".bl";
    private static final int DEFAULT_CONNECTION_TIME = 60;
    private static final long SLEEP_BETWEEN_CONNECTIONS_MS = 5000L;
    private static final String DYNAMIC_CONFIG_FEATURES_KEY = "business_logic_device_features";
    private static final String DYNAMIC_CONFIG_PROPERTIES_KEY = "business_logic_device_properties";
    private static final String DYNAMIC_CONFIG_PACKAGES_KEY = "business_logic_device_packages";
    private static final String DYNAMIC_CONFIG_EXTENDED_DEVICE_INFO_KEY = "business_logic_extended_device_info";
    @Option(name="business-logic-url", description="The URL to use when accessing the business logic service, parameters not included", mandatory=true)
    private String mUrl;
    @Option(name="business-logic-api-key", description="The API key to use when accessing the business logic service.", mandatory=true)
    private String mApiKey;
    @Option(name="business-logic-api-scope", description="The URI of api scope to use when retrieving business logic rules.")
    private String mApiScope;
    @Option(name="cache-business-logic", description="Whether to keep and use cached business logic files.")
    private boolean mCache = false;
    @Option(name="clean-cache-business-logic", description="Like option 'cache-business-logic', but forces a refresh of the cached business logic file")
    private boolean mCleanCache = false;
    @Option(name="ignore-business-logic-failure", description="Whether to proceed with the suite invocation if retrieval of business logic fails.")
    private boolean mIgnoreFailure = false;
    @Option(name="business-logic-connection-time", description="Amount of time to attempt connection to the business logic service, in seconds.")
    private int mMaxConnectionTime = 60;
    @Option(name="config-filename", description="The module name for module-level configurations, or the suite name for suite-level configurations. Will lookup suite name if not provided.")
    private String mModuleName = null;
    @Option(name="version", description="The module configuration version to retrieve.")
    private String mModuleVersion = null;
    private String mDeviceFilePushed;
    private String mHostFilePushed;
    private IAbi mAbi = null;
    private IInvocationContext mModuleContext = null;

    public void setAbi(IAbi abi) {
        this.mAbi = abi;
    }

    public IAbi getAbi() {
        return this.mAbi;
    }

    public void setInvocationContext(IInvocationContext invocationContext) {
        this.mModuleContext = invocationContext;
    }

    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        IBuildInfo buildInfo = testInfo.getBuildInfo();
        ITestDevice device = testInfo.getDevice();
        CompatibilityBuildHelper buildHelper = new CompatibilityBuildHelper(buildInfo);
        if (buildHelper.hasBusinessLogicHostFile()) {
            LogUtil.CLog.i((String)"Business logic file already collected, skipping BusinessLogicPreparer.");
            return;
        }
        if (this.mModuleName == null) {
            this.mModuleName = "";
            LogUtil.CLog.w((String)"Option config-filename isn't set. Using empty string instead.");
        }
        if (this.mModuleVersion == null) {
            LogUtil.CLog.w((String)"Option version isn't set. Using 'null' instead.");
            this.mModuleVersion = "null";
        }
        String requestParams = this.buildRequestParams(device, buildInfo);
        String baseUrl = this.mUrl.replace(SUITE_PLACEHOLDER, this.getSuiteNames().get(0));
        String businessLogicString = null;
        if (!this.shouldReadCache() || (businessLogicString = BusinessLogicPreparer.readFromCache(baseUrl, requestParams)) == null) {
            LogUtil.CLog.i((String)"Attempting to connect to business logic service...");
        }
        long start = System.currentTimeMillis();
        IOException connectIssue = null;
        while (businessLogicString == null && System.currentTimeMillis() < start + (long)(this.mMaxConnectionTime * 1000)) {
            try {
                businessLogicString = this.doPost(baseUrl, requestParams);
            }
            catch (IOException e) {
                LogUtil.CLog.d((String)"BusinessLogic connection failure message: %s\nRetrying...", (Object[])new Object[]{e.getMessage()});
                connectIssue = e;
                RunUtil.getDefault().sleep(5000L);
            }
        }
        if (businessLogicString == null) {
            if (this.mIgnoreFailure) {
                LogUtil.CLog.e((String)"Failed to connect to business logic service.\nProceeding with test invocation, tests depending on the remote configuration will fail.\n");
                return;
            }
            String baseMessage = String.format("Cannot connect to business logic service for config %s. If this problem persists, re-invoking with option '--ignore-business-logic-failure' will cause tests to execute anyways (though tests depending on the remote configuration will fail).", this.mModuleName);
            if (connectIssue != null) {
                baseMessage = String.format("%s.\n%s", connectIssue.getMessage(), baseMessage);
            }
            throw new TargetSetupError(baseMessage, device.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.ANDROID_PARTNER_SERVER_ERROR);
        }
        if (this.shouldWriteCache()) {
            BusinessLogicPreparer.writeToCache(businessLogicString, baseUrl, requestParams, this.mCleanCache);
        }
        try {
            File hostFile = FileUtil.createTempFile((String)FILE_LOCATION, (String)FILE_EXT);
            FileUtil.writeToFile((String)businessLogicString, (File)hostFile);
            this.mHostFilePushed = hostFile.getAbsolutePath();
            String bitness = this.mAbi != null ? this.mAbi.getBitness() : "";
            buildHelper.setBusinessLogicHostFile(hostFile, bitness + this.mModuleName);
        }
        catch (IOException e) {
            throw new TargetSetupError(String.format("Retrieved business logic for config %s could not be written to host", this.mModuleName), device.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.FAIL_TO_CREATE_FILE);
        }
        BusinessLogicPreparer.removeDeviceFile(device);
        if (!device.pushString(businessLogicString, "/sdcard/bl")) {
            throw new TargetSetupError(String.format("Retrieved business logic for config %s could not be written to device %s", this.mModuleName, device.getSerialNumber()), device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.FAIL_PUSH_FILE);
        }
        this.mDeviceFilePushed = "/sdcard/bl";
    }

    @VisibleForTesting
    String buildRequestParams(ITestDevice device, IBuildInfo buildInfo) throws DeviceNotAvailableException {
        CompatibilityBuildHelper buildHelper = new CompatibilityBuildHelper(buildInfo);
        MultiMap paramMap = new MultiMap();
        String suiteVersion = buildHelper.getSuiteVersion();
        if (suiteVersion == null) {
            suiteVersion = "null";
        }
        paramMap.put((Object)"suite_version", (Object)suiteVersion);
        paramMap.put((Object)"module_version", (Object)this.mModuleVersion);
        paramMap.put((Object)"oem", (Object)String.valueOf(PropertyUtil.getManufacturer((ITestDevice)device)));
        for (String feature : this.getBusinessLogicFeatures(device, buildInfo)) {
            paramMap.put((Object)"features", (Object)feature);
        }
        for (String property : this.getBusinessLogicProperties(device, buildInfo)) {
            paramMap.put((Object)"properties", (Object)property);
        }
        for (String pkg : this.getBusinessLogicPackages(device, buildInfo)) {
            paramMap.put((Object)"packages", (Object)pkg);
        }
        for (String deviceInfo : this.getExtendedDeviceInfo(buildInfo)) {
            paramMap.put((Object)"device_info", (Object)deviceInfo);
        }
        HttpHelper helper = new HttpHelper();
        String paramString = helper.buildParameters(paramMap);
        LogUtil.CLog.d((String)"Built param string: \"%s\"", (Object[])new Object[]{paramString});
        return paramString;
    }

    @VisibleForTesting
    List<String> getSuiteNames() {
        List testSuiteTags;
        if (this.mModuleContext != null && !(testSuiteTags = this.mModuleContext.getConfigurationDescriptor().getSuiteTags()).isEmpty()) {
            LogUtil.CLog.i((String)"Adding %s from test suite tags to get value from dynamic config", (Object[])new Object[]{testSuiteTags});
            return testSuiteTags;
        }
        String suiteName = TestSuiteInfo.getInstance().getName().toLowerCase();
        LogUtil.CLog.i((String)"Using %s from TestSuiteInfo to get value from dynamic config", (Object[])new Object[]{suiteName});
        return Collections.singletonList(suiteName);
    }

    private List<String> getBusinessLogicProperties(ITestDevice device, IBuildInfo buildInfo) throws DeviceNotAvailableException {
        ArrayList<String> properties = new ArrayList<String>();
        Map clientIds = PropertyUtil.getClientIds((ITestDevice)device);
        for (Map.Entry id : clientIds.entrySet()) {
            properties.add(String.format("%s:%s", id.getKey(), id.getValue()));
        }
        try {
            List<String> propertyNames = DynamicConfigFileReader.getValuesFromConfig(buildInfo, this.getSuiteNames(), DYNAMIC_CONFIG_PROPERTIES_KEY);
            for (String name : propertyNames) {
                String value = String.valueOf(device.getProperty(name));
                properties.add(String.format("%s:%s", name, value));
            }
        }
        catch (IOException | XmlPullParserException e) {
            LogUtil.CLog.e((String)"Failed to pull business logic properties from dynamic config");
        }
        return properties;
    }

    private List<String> getBusinessLogicFeatures(ITestDevice device, IBuildInfo buildInfo) throws DeviceNotAvailableException {
        try {
            List<String> dynamicConfigFeatures = DynamicConfigFileReader.getValuesFromConfig(buildInfo, this.getSuiteNames(), DYNAMIC_CONFIG_FEATURES_KEY);
            Set deviceFeatures = FeatureUtil.getAllFeatures((ITestDevice)device);
            dynamicConfigFeatures.retainAll(deviceFeatures);
            return dynamicConfigFeatures;
        }
        catch (IOException | XmlPullParserException e) {
            LogUtil.CLog.e((String)"Failed to pull business logic features from dynamic config");
            return new ArrayList<String>();
        }
    }

    private List<String> getBusinessLogicPackages(ITestDevice device, IBuildInfo buildInfo) throws DeviceNotAvailableException {
        try {
            List<String> dynamicConfigPackages = DynamicConfigFileReader.getValuesFromConfig(buildInfo, this.getSuiteNames(), DYNAMIC_CONFIG_PACKAGES_KEY);
            Set devicePackages = device.getInstalledPackageNames();
            dynamicConfigPackages.retainAll(devicePackages);
            return dynamicConfigPackages;
        }
        catch (IOException | XmlPullParserException e) {
            LogUtil.CLog.e((String)"Failed to pull business logic packages from dynamic config");
            return new ArrayList<String>();
        }
    }

    private List<String> getExtendedDeviceInfo(IBuildInfo buildInfo) {
        ArrayList<String> extendedDeviceInfo = new ArrayList<String>();
        File deviceInfoPath = buildInfo.getFile("device_info_dir");
        if (deviceInfoPath == null || !deviceInfoPath.exists()) {
            LogUtil.CLog.w((String)"Device Info directory was not created (Make sure you are not running plan \"*ts-dev\" or including option -d/--skip-device-info)");
            return extendedDeviceInfo;
        }
        List<String> requiredDeviceInfo = null;
        try {
            requiredDeviceInfo = DynamicConfigFileReader.getValuesFromConfig(buildInfo, this.getSuiteNames(), DYNAMIC_CONFIG_EXTENDED_DEVICE_INFO_KEY);
        }
        catch (IOException | XmlPullParserException e) {
            LogUtil.CLog.e((String)"Failed to pull business logic Extended DeviceInfo from dynamic config. Error: %s", (Object[])new Object[]{e});
            return extendedDeviceInfo;
        }
        File ediFile = null;
        String[] fileAndKey = null;
        try {
            for (String ediEntry : requiredDeviceInfo) {
                fileAndKey = ediEntry.split(":");
                if (fileAndKey.length <= 1) {
                    LogUtil.CLog.e((String)"Dynamic config Extended DeviceInfo key has problem.");
                    return new ArrayList<String>();
                }
                ediFile = FileUtil.findFile((File)deviceInfoPath, (String)(fileAndKey[0] + ".deviceinfo.json"));
                if (ediFile == null) {
                    LogUtil.CLog.e((String)"Could not find Extended DeviceInfo JSON file: %s.", (Object[])new Object[]{deviceInfoPath + fileAndKey[0] + ".deviceinfo.json"});
                    return new ArrayList<String>();
                }
                String jsonString = FileUtil.readStringFromFile((File)ediFile);
                JSONObject jsonObj = new JSONObject(jsonString);
                String value = jsonObj.getString(fileAndKey[1]);
                extendedDeviceInfo.add(String.format("%s:%s:%s", fileAndKey[0], fileAndKey[1], value));
            }
        }
        catch (IOException | RuntimeException | JSONException e) {
            LogUtil.CLog.e((String)"Failed to read or parse Extended DeviceInfo JSON file: %s. Error: %s", (Object[])new Object[]{deviceInfoPath + fileAndKey[0] + ".deviceinfo.json", e});
            return new ArrayList<String>();
        }
        return extendedDeviceInfo;
    }

    private boolean shouldReadCache() {
        return this.mCache && !this.mCleanCache;
    }

    private boolean shouldWriteCache() {
        return this.mCache || this.mCleanCache;
    }

    private static synchronized String readFromCache(String baseUrl, String params) {
        File cachedFile = BusinessLogicPreparer.getCachedFile(baseUrl, params);
        if (!cachedFile.exists()) {
            LogUtil.CLog.i((String)"No cached business logic found");
            return null;
        }
        try {
            BusinessLogic cachedLogic = BusinessLogicFactory.createFromFile((File)cachedFile);
            Date cachedDate = cachedLogic.getTimestamp();
            if (System.currentTimeMillis() - cachedDate.getTime() < 432000000L) {
                LogUtil.CLog.i((String)"Using cached business logic from: %s", (Object[])new Object[]{cachedDate.toString()});
                return FileUtil.readStringFromFile((File)cachedFile);
            }
            LogUtil.CLog.i((String)"Cached business logic out-of-date, deleting cached file");
            FileUtil.deleteFile((File)cachedFile);
        }
        catch (IOException e) {
            LogUtil.CLog.w((String)"Failed to read cached business logic, deleting cached file");
            FileUtil.deleteFile((File)cachedFile);
        }
        return null;
    }

    private static synchronized void writeToCache(String blString, String baseUrl, String params, boolean overwrite) {
        File cachedFile = BusinessLogicPreparer.getCachedFile(baseUrl, params);
        if (!cachedFile.exists() || overwrite) {
            try {
                FileUtil.writeToFile((String)blString, (File)cachedFile);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write business logic to cache file", e);
            }
        }
    }

    private static File getCachedFile(String baseUrl, String params) {
        int hashCode = (baseUrl + params).hashCode();
        return new File(System.getProperty("java.io.tmpdir"), BL_CACHE_FILE + hashCode);
    }

    private String doPost(String baseUrl, String params) throws IOException {
        String accessToken = this.getToken();
        if (Strings.isNullOrEmpty((String)accessToken)) {
            baseUrl = baseUrl + String.format("?key=%s", this.mApiKey);
        }
        URL url = new URL(baseUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("User-Agent", "BusinessLogicClient");
        if (!Strings.isNullOrEmpty((String)accessToken)) {
            conn.setRequestProperty("Authorization", String.format("Bearer %s", accessToken));
        }
        conn.setDoOutput(true);
        try (DataOutputStream wr = new DataOutputStream(conn.getOutputStream());){
            wr.writeBytes(params);
        }
        int responseCode = conn.getResponseCode();
        LogUtil.CLog.d((String)"Business Logic Service Response Code : %s", (Object[])new Object[]{responseCode});
        return StreamUtil.getStringFromStream((InputStream)conn.getInputStream());
    }

    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        if (this.mHostFilePushed != null) {
            FileUtil.deleteFile((File)new File(this.mHostFilePushed));
        }
        if (this.mDeviceFilePushed != null && !(e instanceof DeviceNotAvailableException)) {
            BusinessLogicPreparer.removeDeviceFile(testInfo.getDevice());
        }
    }

    private static void removeDeviceFile(ITestDevice device) throws DeviceNotAvailableException {
        device.deleteFile("/sdcard/bl");
    }

    private String getToken() {
        String keyFilePath = System.getenv("APE_API_KEY");
        if (Strings.isNullOrEmpty((String)keyFilePath)) {
            File globalKeyFile = (File)GlobalConfiguration.getInstance().getHostOptions().getServiceAccountJsonKeyFiles().get(GLOBAL_APE_API_KEY);
            if (globalKeyFile == null || !globalKeyFile.exists()) {
                LogUtil.CLog.d((String)"Unable to fetch the service key because neither environment variable APE_API_KEY is set nor the key file is dynamically downloaded.");
                return null;
            }
            keyFilePath = globalKeyFile.getAbsolutePath();
        }
        if (Strings.isNullOrEmpty((String)this.mApiScope)) {
            LogUtil.CLog.d((String)"API scope not set, use flag --business-logic-api-scope.");
            return null;
        }
        try {
            GoogleCredential credential = GoogleCredential.fromStream((InputStream)new FileInputStream(keyFilePath)).createScoped(Collections.singleton(this.mApiScope));
            credential.refreshToken();
            return credential.getAccessToken();
        }
        catch (FileNotFoundException e) {
            LogUtil.CLog.e((String)String.format("Service key file %s doesn't exist.", keyFilePath));
        }
        catch (IOException e) {
            LogUtil.CLog.e((String)String.format("Can't read the service key file, %s", keyFilePath));
        }
        return null;
    }
}

