/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.result.suite;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.tradefed.util.CollectorUtil;
import com.android.compatibility.common.util.MetricsReportLog;
import com.android.compatibility.common.util.ResultType;
import com.android.compatibility.common.util.ResultUnit;
import com.android.ddmlib.Log;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@OptionClass(alias="test-metrics-json-reporter")
public class TestMetricsJsonResultReporter
implements ITestInvocationListener {
    private static final String PRODUCT_CPU_ABI_KEY = "ro.product.cpu.abi";
    private CompatibilityBuildHelper mBuildHelper;
    private IInvocationContext mContext;
    private IInvocationContext mModuleContext;
    private IBuildInfo mBuildInfo;
    @Option(name="dest-dir", description="The directory under the result to store the files. Default to 'report-log-files'.")
    private String mDestDir = "report-log-files";
    private String mTempReportFolder = "temp-report-logs";
    @Option(name="report-log-name", description="Name of the JSON report file.")
    private String mReportLogName = null;
    @Option(name="report-test-name-mapping", description="Mapping for test name to use in report.")
    private Map<String, String> mReportTestNameMap = new HashMap<String, String>();
    @Option(name="report-all-metrics", description="Report all the generated metrics. Default to 'true'.")
    private boolean mReportAllMetrics = true;
    @Option(name="report-metric-key-mapping", description="Mapping for Metric Keys to be reported. Only report the keys provided in the mapping.")
    private Map<String, String> mReportMetricKeyMap = new HashMap<String, String>();

    private IBuildInfo getPrimaryBuildInfo() {
        if (this.mContext == null) {
            return null;
        }
        return (IBuildInfo)this.mContext.getBuildInfos().get(0);
    }

    CompatibilityBuildHelper createBuildHelper() {
        return new CompatibilityBuildHelper(this.getPrimaryBuildInfo());
    }

    String getAbiInfo() {
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Getting ABI Information.");
        if (this.mModuleContext == null) {
            return "";
        }
        List abis = this.mModuleContext.getAttributes().get((Object)"module-abi");
        if (abis == null || abis.isEmpty()) {
            return "";
        }
        if (abis.size() > 1) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.WARN, (String)String.format("More than one ABI name specified (using first one): %s", abis.toString()));
        }
        return (String)abis.get(0);
    }

    private void initializeReporterConfig() {
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Initializing Test Metrics Result Reporter Config.");
        this.mBuildInfo = this.getPrimaryBuildInfo();
        if (this.mBuildHelper == null) {
            this.mBuildHelper = this.createBuildHelper();
        }
        if (this.mReportLogName == null) {
            this.mReportLogName = this.mContext.getTestTag();
        }
    }

    private void writeTestMetrics(TestDescription testDescription, HashMap<String, MetricMeasurement.Metric> metrics) {
        String classMethodName;
        String streamName = classMethodName = testDescription.toString();
        if (this.mReportTestNameMap != null && this.mReportTestNameMap.containsKey(classMethodName)) {
            streamName = this.mReportTestNameMap.get(classMethodName);
        }
        String abiName = this.getAbiInfo();
        MetricsReportLog reportLog = new MetricsReportLog(this.mBuildInfo, abiName, classMethodName, this.mReportLogName, streamName);
        if (this.mReportAllMetrics) {
            this.writeAllMetrics(reportLog, metrics);
        } else {
            this.writeMetricsForGivenKeys(reportLog, metrics);
        }
        reportLog.submit();
    }

    private void writeAllMetrics(MetricsReportLog reportLog, HashMap<String, MetricMeasurement.Metric> metrics) {
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Writing all the metrics to JSON report.");
        Map metricsMap = TfMetricProtoUtil.compatibleConvert(metrics);
        for (String key : metricsMap.keySet()) {
            try {
                double value = Double.parseDouble((String)metricsMap.get(key));
                reportLog.addValue(key, value, ResultType.NEUTRAL, ResultUnit.NONE);
            }
            catch (NumberFormatException exception) {
                LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)String.format("Unable to parse value '%s' for '%s' metric key.", metricsMap.get(key), key));
            }
        }
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Successfully completed writing the metrics to JSON report.");
    }

    private void writeMetricsForGivenKeys(MetricsReportLog reportLog, HashMap<String, MetricMeasurement.Metric> metrics) {
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Writing given set of metrics to JSON report.");
        if (this.mReportMetricKeyMap == null || this.mReportMetricKeyMap.isEmpty()) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.WARN, (String)"Skip reporting metrics. Metric keys are not provided.");
            return;
        }
        for (String key : this.mReportMetricKeyMap.keySet()) {
            if (!metrics.containsKey(key) || metrics.get(key) == null) {
                LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.WARN, (String)String.format("%s metric key is missing.", key));
                continue;
            }
            Map metricsMap = TfMetricProtoUtil.compatibleConvert(metrics);
            try {
                double value = Double.parseDouble((String)metricsMap.get(key));
                reportLog.addValue(this.mReportMetricKeyMap.get(key), value, ResultType.NEUTRAL, ResultUnit.NONE);
            }
            catch (NumberFormatException exception) {
                LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)String.format("Unable to parse value '%s' for '%s' metric key.", metricsMap.get(key), key));
            }
        }
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Successfully completed writing the metrics to JSON report.");
    }

    private void copyGeneratedReportToResultsDirectory() {
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Copying the report log to results directory.");
        try {
            File resultDir = this.mBuildHelper.getResultDir();
            if (this.mDestDir != null) {
                resultDir = new File(resultDir, this.mDestDir);
            }
            if (!resultDir.exists()) {
                resultDir.mkdirs();
            }
            if (!resultDir.isDirectory()) {
                LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)String.format("%s is not a directory", resultDir.getAbsolutePath()));
                return;
            }
            File hostReportDir = FileUtil.createNamedTempDir((String)this.mTempReportFolder);
            if (!hostReportDir.isDirectory()) {
                LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)String.format("%s is not a directory", hostReportDir.getAbsolutePath()));
                return;
            }
            CollectorUtil.reformatRepeatedStreams(hostReportDir);
            CollectorUtil.pullFromHost(hostReportDir, resultDir);
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Copying the report log completed successfully.");
        }
        catch (IOException exception) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)exception.getMessage());
        }
    }

    public void invocationStarted(IInvocationContext context) {
        this.mContext = context;
        this.initializeReporterConfig();
    }

    public void invocationEnded(long elapsedTime) {
        this.copyGeneratedReportToResultsDirectory();
    }

    public void testEnded(TestDescription testDescription, HashMap<String, MetricMeasurement.Metric> metrics) {
        if (!metrics.isEmpty()) {
            this.writeTestMetrics(testDescription, metrics);
        }
    }

    public void testModuleStarted(IInvocationContext moduleContext) {
        this.mModuleContext = moduleContext;
    }

    public void testModuleEnded() {
        this.mModuleContext = null;
    }
}

