/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.GenericTimingItem;
import com.android.loganalysis.item.IItem;
import com.android.loganalysis.item.SystemServicesTimingItem;
import com.android.loganalysis.parser.IParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimingsLogParser
implements IParser {
    private static final String SYSTEM_SERVICES_TIME_PREFIX = "^\\d*-\\d*\\s*\\d*:\\d*:\\d*.\\d*\\s*\\d*\\s*\\d*\\s*[DV]\\s*(?<componentname>.*):\\s*(?<subname>\\S*)\\s*";
    private static final String SYSTEM_SERVICES_TIME_SUFFIX = ":\\s*(?<time>.*)ms\\s*$";
    private static final DateFormat DEFAULT_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final String DEFAULT_YEAR = "1970";
    private static final Pattern SYSTEM_SERVICES_DURATION = Pattern.compile(String.format("%stook to complete%s", "^\\d*-\\d*\\s*\\d*:\\d*:\\d*.\\d*\\s*\\d*\\s*\\d*\\s*[DV]\\s*(?<componentname>.*):\\s*(?<subname>\\S*)\\s*", ":\\s*(?<time>.*)ms\\s*$"));
    private static final Pattern SYSTEM_SERVICES_START_TIME = Pattern.compile(String.format("%sstart time%s", "^\\d*-\\d*\\s*\\d*:\\d*:\\d*.\\d*\\s*\\d*\\s*\\d*\\s*[DV]\\s*(?<componentname>.*):\\s*(?<subname>\\S*)\\s*", ":\\s*(?<time>.*)ms\\s*$"));
    private List<DurationPattern> durationPatterns = new ArrayList<DurationPattern>();

    @Override
    public IItem parse(List<String> lines) {
        throw new UnsupportedOperationException("Method has not been implemented in lieu of others");
    }

    public void addDurationPatternPair(String name, Pattern startTimePattern, Pattern endTimePattern) {
        DurationPattern durationPattern = new DurationPattern(name, startTimePattern, endTimePattern);
        this.durationPatterns.add(durationPattern);
    }

    public void clearDurationPatterns() {
        this.durationPatterns.clear();
    }

    public List<GenericTimingItem> parseGenericTimingItems(BufferedReader input) throws IOException {
        String line;
        ArrayList<GenericTimingItem> items = new ArrayList<GenericTimingItem>();
        HashMap<String, Double> pendingItems = new HashMap<String, Double>();
        while ((line = input.readLine()) != null) {
            items.addAll(this.parseGenericTimingItem(line, pendingItems));
        }
        return items;
    }

    private List<GenericTimingItem> parseGenericTimingItem(String line, Map<String, Double> pendingItems) {
        ArrayList<GenericTimingItem> items = new ArrayList<GenericTimingItem>();
        for (DurationPattern durationPattern : this.durationPatterns) {
            Matcher matcher = durationPattern.mStartTimePattern.matcher(line);
            if (matcher.find()) {
                double startTimeMillis = this.parseTime(line);
                pendingItems.put(durationPattern.mName, startTimeMillis);
                continue;
            }
            matcher = durationPattern.mEndTimePattern.matcher(line);
            if (!matcher.find()) continue;
            double endTimeMillis = this.parseTime(line);
            Double startTimeMillis = pendingItems.get(durationPattern.mName);
            if (startTimeMillis == null) continue;
            GenericTimingItem newItem = new GenericTimingItem();
            newItem.setName(durationPattern.mName);
            newItem.setStartAndEnd(startTimeMillis, endTimeMillis);
            items.add(newItem);
            pendingItems.remove(durationPattern.mName);
        }
        return items;
    }

    private double parseTime(String line) {
        String timeStr = String.format("%s-%s", DEFAULT_YEAR, line);
        try {
            return DEFAULT_TIME_FORMAT.parse(timeStr).getTime();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public List<SystemServicesTimingItem> parseSystemServicesTimingItems(BufferedReader input) throws IOException {
        String line;
        HashSet<String> matchedLines = new HashSet<String>();
        ArrayList<SystemServicesTimingItem> items = new ArrayList<SystemServicesTimingItem>();
        while ((line = input.readLine()) != null) {
            SystemServicesTimingItem item;
            if (matchedLines.contains(line) || (item = this.parseSystemServicesTimingItem(line)) == null) continue;
            items.add(item);
            matchedLines.add(line);
        }
        return items;
    }

    private SystemServicesTimingItem parseSystemServicesTimingItem(String line) {
        Matcher matcher = SYSTEM_SERVICES_DURATION.matcher(line);
        boolean durationMatched = matcher.matches();
        if (!durationMatched) {
            matcher = SYSTEM_SERVICES_START_TIME.matcher(line);
        }
        if (!matcher.matches()) {
            return null;
        }
        SystemServicesTimingItem item = new SystemServicesTimingItem();
        item.setComponent(matcher.group("componentname").trim());
        item.setSubcomponent(matcher.group("subname").trim());
        if (durationMatched) {
            item.setDuration(Double.parseDouble(matcher.group("time")));
        } else {
            item.setStartTime(Double.parseDouble(matcher.group("time")));
        }
        return item;
    }

    private static class DurationPattern {
        String mName;
        Pattern mStartTimePattern;
        Pattern mEndTimePattern;

        DurationPattern(String name, Pattern startTimePattern, Pattern endTimePattern) {
            this.mName = name;
            this.mStartTimePattern = startTimePattern;
            this.mEndTimePattern = endTimePattern;
        }
    }
}

