/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.SmartMonkeyLogItem;
import com.android.loganalysis.parser.IParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SmartMonkeyLogParser
implements IParser {
    private static final String TIME_STAMP_GROUP = "^(\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}.\\d{3}): ";
    private static final String INVOKE_NUM_GROUP = "\\[.*?(\\d+)\\]";
    private static final String SEQ_NUM_GROUP = "\\(Seq:.*?(\\d+)\\)";
    private static final Pattern START_TIME = Pattern.compile("^(\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}.\\d{3}): Starting.*");
    private static final Pattern START_UPTIME = Pattern.compile("^(\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}.\\d{3}): Device uptime: (\\d+) sec$");
    private static final Pattern STOP_UPTIME = Pattern.compile("^(\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}.\\d{3}): Device uptime: (\\d+) sec, Monkey run duration: (\\d+) sec$");
    private static final Pattern THROTTLE = Pattern.compile("^(\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}.\\d{3}): Throttle: (\\d+).*");
    private static final Pattern TARGET_INVOCATIONS = Pattern.compile("^(\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}.\\d{3}): Target invocation count: (\\d+)");
    private static final Pattern INTERMEDIATE_COUNT = Pattern.compile("^(\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}.\\d{3}): \\[.*?(\\d+)\\]\\(Seq:.*?(\\d+)\\).*");
    private static final Pattern INTERMEDIATE_TIME = Pattern.compile("^(\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}.\\d{3}): .*");
    private static final Pattern FINISHED = Pattern.compile("^(\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}.\\d{3}): Monkey finished");
    private static final Pattern FINAL_COUNT = Pattern.compile("^(\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}.\\d{3}): Invocations completed: (\\d+)");
    private static final Pattern APPS_PACKAGES = Pattern.compile("^(\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}.\\d{3}): Starting \\[(.*)\\]\\[(.*)\\]");
    private static final Pattern ABORTED = Pattern.compile("^(\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}.\\d{3}): Monkey aborted.");
    private static final Pattern UI_ANR = Pattern.compile("^(\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}.\\d{3}): \\[.*?(\\d+)\\]\\(Seq:.*?(\\d+)\\)-UI Exception: ANR: (.*)");
    private static final Pattern UI_CRASH = Pattern.compile("^(\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}.\\d{3}): \\[.*?(\\d+)\\]\\(Seq:.*?(\\d+)\\)-UI Exception: CRASH: (.*)");
    private final SmartMonkeyLogItem mSmartMonkeyLog = new SmartMonkeyLogItem();

    public SmartMonkeyLogItem parse(BufferedReader input) throws IOException {
        String line;
        while ((line = input.readLine()) != null) {
            this.parseLine(line);
        }
        return this.mSmartMonkeyLog;
    }

    @Override
    public SmartMonkeyLogItem parse(List<String> lines) {
        for (String line : lines) {
            this.parseLine(line);
        }
        if (this.mSmartMonkeyLog.getStopUptimeDuration() == 0L) {
            this.mSmartMonkeyLog.setIsFinished(false);
        } else {
            this.mSmartMonkeyLog.setIsFinished(true);
        }
        return this.mSmartMonkeyLog;
    }

    private void parseLine(String line) {
        Matcher m = THROTTLE.matcher(line);
        if (m.matches()) {
            this.mSmartMonkeyLog.setThrottle(Integer.parseInt(m.group(2)));
        }
        if ((m = TARGET_INVOCATIONS.matcher(line)).matches()) {
            this.mSmartMonkeyLog.setTargetInvocations(Integer.parseInt(m.group(2)));
        }
        if ((m = APPS_PACKAGES.matcher(line)).matches()) {
            String[] pkgsArray;
            String[] appsArray;
            String apps = m.group(2);
            String packages = m.group(3);
            for (String a : appsArray = apps.split("\\|")) {
                this.mSmartMonkeyLog.addApplication(a);
            }
            for (String p : pkgsArray = packages.split("\\|")) {
                this.mSmartMonkeyLog.addPackage(p);
            }
        }
        if ((m = INTERMEDIATE_COUNT.matcher(line)).matches()) {
            this.mSmartMonkeyLog.setIntermediateCount(Integer.parseInt(m.group(2)));
        }
        if ((m = START_TIME.matcher(line)).matches()) {
            this.mSmartMonkeyLog.setStartTime(SmartMonkeyLogParser.parseTime(m.group(1)));
        }
        if ((m = START_UPTIME.matcher(line)).matches()) {
            this.mSmartMonkeyLog.setStartUptimeDuration(Long.parseLong(m.group(2)));
        }
        if ((m = STOP_UPTIME.matcher(line)).matches()) {
            this.mSmartMonkeyLog.setStopTime(SmartMonkeyLogParser.parseTime(m.group(1)));
            this.mSmartMonkeyLog.setStopUptimeDuration(Long.parseLong(m.group(2)));
            this.mSmartMonkeyLog.setTotalDuration(Long.parseLong(m.group(3)));
        }
        if ((m = INTERMEDIATE_TIME.matcher(line)).matches()) {
            this.mSmartMonkeyLog.setIntermediateTime(SmartMonkeyLogParser.parseTime(m.group(1)));
        }
        if ((m = FINAL_COUNT.matcher(line)).matches()) {
            this.mSmartMonkeyLog.setFinalCount(Integer.parseInt(m.group(2)));
        }
        if ((m = FINISHED.matcher(line)).matches()) {
            this.mSmartMonkeyLog.setIsFinished(true);
        }
        if ((m = ABORTED.matcher(line)).matches()) {
            this.mSmartMonkeyLog.setIsAborted(true);
        }
        if ((m = UI_CRASH.matcher(line)).matches()) {
            this.mSmartMonkeyLog.addCrashTime(SmartMonkeyLogParser.parseTime(m.group(1)));
        }
        if ((m = UI_ANR.matcher(line)).matches()) {
            this.mSmartMonkeyLog.addAnrTime(SmartMonkeyLogParser.parseTime(m.group(1)));
        }
    }

    public static Date parseTime(String timeStr) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").parse(timeStr);
        }
        catch (ParseException parseException) {
            return null;
        }
    }
}

