/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.MiscLogcatItem;
import com.android.loganalysis.item.NativeCrashItem;
import com.android.loganalysis.parser.IParser;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NativeCrashParser
implements IParser {
    public static final Pattern FINGERPRINT = Pattern.compile("^Build fingerprint: '(.*)'$");
    private static final Pattern APP = Pattern.compile("^pid: (\\d+), tid: (\\d+)(, name: .+)?  >>> (\\S+) <<<$");

    @Override
    public NativeCrashItem parse(List<String> lines) {
        MiscLogcatItem nc = null;
        StringBuilder stack = new StringBuilder();
        for (String line : lines) {
            Matcher m = FINGERPRINT.matcher(line);
            if (m.matches()) {
                nc = new NativeCrashItem();
                ((NativeCrashItem)nc).setFingerprint(m.group(1));
            }
            if (nc == null) continue;
            m = APP.matcher(line);
            if (m.matches()) {
                nc.setPid(Integer.valueOf(m.group(1)));
                nc.setTid(Integer.valueOf(m.group(2)));
                nc.setApp(m.group(4));
            }
            stack.append(line);
            stack.append("\n");
        }
        if (nc != null) {
            nc.setStack(stack.toString().trim());
        }
        return nc;
    }
}

