/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.AnrItem;
import com.android.loganalysis.item.IItem;
import com.android.loganalysis.item.MiscLogcatItem;
import com.android.loganalysis.item.MonkeyLogItem;
import com.android.loganalysis.item.NativeCrashItem;
import com.android.loganalysis.item.TracesItem;
import com.android.loganalysis.parser.AnrParser;
import com.android.loganalysis.parser.IParser;
import com.android.loganalysis.parser.JavaCrashParser;
import com.android.loganalysis.parser.NativeCrashParser;
import com.android.loganalysis.parser.TracesParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MonkeyLogParser
implements IParser {
    private static final Pattern THROTTLE = Pattern.compile("adb shell monkey.* --throttle (\\d+).*");
    private static final Pattern SEED_AND_TARGET_COUNT = Pattern.compile(":Monkey: seed=(\\d+) count=(\\d+)");
    private static final Pattern SECURITY_EXCEPTIONS = Pattern.compile("adb shell monkey.* --ignore-security-exceptions.*");
    private static final Pattern PACKAGES = Pattern.compile(":AllowPackage: (\\S+)");
    private static final Pattern CATEGORIES = Pattern.compile(":IncludeCategory: (\\S+)");
    private static final Pattern START_UPTIME = Pattern.compile("# (.*) - device uptime = (\\d+\\.\\d+): Monkey command used for this test:");
    private static final Pattern STOP_UPTIME = Pattern.compile("# (.*) - device uptime = (\\d+\\.\\d+): Monkey command ran for: (\\d+):(\\d+) \\(mm:ss\\)");
    private static final Pattern INTERMEDIATE_COUNT = Pattern.compile("\\s+// Sending event #(\\d+)");
    private static final Pattern FINISHED = Pattern.compile("// Monkey finished");
    private static final Pattern FINAL_COUNT = Pattern.compile("Events injected: (\\d+)");
    private static final Pattern NO_ACTIVITIES = Pattern.compile("\\*\\* No activities found to run, monkey aborted.");
    private static final Pattern DROPPED_KEYS = Pattern.compile(":Dropped: .*keys=(\\d+).*");
    private static final Pattern DROPPED_POINTERS = Pattern.compile(":Dropped: .*pointers=(\\d+).*");
    private static final Pattern DROPPED_TRACKBALLS = Pattern.compile(":Dropped: .*trackballs=(\\d+).*");
    private static final Pattern DROPPED_FLIPS = Pattern.compile(":Dropped: .*flips=(\\d+).*");
    private static final Pattern DROPPED_ROTATIONS = Pattern.compile(":Dropped: .*rotations=(\\d+).*");
    private static final Pattern MONKEY_LOG_MESSAGE = Pattern.compile("$(:|Sleeping|    //)");
    private static final Pattern ANR = Pattern.compile("// NOT RESPONDING: (\\S+) \\(pid (\\d+)\\)");
    private static final Pattern CRASH = Pattern.compile("// CRASH: (\\S+) \\(pid (\\d+)\\)");
    private static final Pattern EMPTY_NATIVE_CRASH = Pattern.compile("\\*\\* New native crash detected.");
    private static final Pattern ABORTED = Pattern.compile("\\*\\* Monkey aborted due to error.");
    private static final Pattern TRACES_START = Pattern.compile("anr traces:");
    private static final Pattern TRACES_STOP = Pattern.compile("// anr traces status was \\d+");
    private boolean mMatchingAnr = false;
    private boolean mMatchingCrash = false;
    private boolean mMatchingJavaCrash = false;
    private boolean mMatchingNativeCrash = false;
    private boolean mMatchingTraces = false;
    private boolean mMatchedTrace = false;
    private List<String> mBlock = null;
    private String mApp = null;
    private Integer mPid = null;
    private MonkeyLogItem mMonkeyLog = new MonkeyLogItem();

    public MonkeyLogItem parse(BufferedReader input) throws IOException {
        String line;
        while ((line = input.readLine()) != null) {
            this.parseLine(line);
        }
        return this.mMonkeyLog;
    }

    @Override
    public MonkeyLogItem parse(List<String> lines) {
        for (String line : lines) {
            this.parseLine(line);
        }
        return this.mMonkeyLog;
    }

    private void parseLine(String line) {
        Matcher m;
        IItem crash;
        if (this.mMatchingAnr) {
            if ("".equals(line)) {
                crash = new AnrParser().parse((List)this.mBlock);
                this.addCrashAndReset((MiscLogcatItem)crash);
            } else {
                Matcher m2 = MONKEY_LOG_MESSAGE.matcher(line);
                if (!m2.matches()) {
                    this.mBlock.add(line);
                }
                return;
            }
        }
        if (this.mMatchingCrash) {
            if (!this.mMatchingJavaCrash && !this.mMatchingNativeCrash && line.startsWith("// Short Msg: ")) {
                if (line.contains("Native crash")) {
                    this.mMatchingNativeCrash = true;
                } else {
                    this.mMatchingJavaCrash = true;
                }
            }
            if ((m = ABORTED.matcher(line)).matches()) {
                crash = null;
                if (this.mMatchingJavaCrash) {
                    crash = new JavaCrashParser().parse((List)this.mBlock);
                } else if (this.mMatchingNativeCrash) {
                    crash = new NativeCrashParser().parse((List)this.mBlock);
                }
                this.addCrashAndReset((MiscLogcatItem)crash);
            } else {
                m = MONKEY_LOG_MESSAGE.matcher(line);
                if (!m.matches() && line.startsWith("// ") && !line.startsWith("// ** ")) {
                    line = line.replace("// ", "");
                    this.mBlock.add(line);
                }
                return;
            }
        }
        if (this.mMatchingTraces) {
            m = TRACES_STOP.matcher(line);
            if (m.matches()) {
                IItem traces = new TracesParser().parse((List)this.mBlock);
                if (traces != null && ((TracesItem)traces).getApp() != null && ((TracesItem)traces).getStack() != null && this.mMonkeyLog.getCrash() instanceof AnrItem && ((TracesItem)traces).getApp().equals(this.mMonkeyLog.getCrash().getApp())) {
                    ((AnrItem)this.mMonkeyLog.getCrash()).setTrace(((TracesItem)traces).getStack());
                }
                this.reset();
                this.mMatchedTrace = true;
            } else {
                m = MONKEY_LOG_MESSAGE.matcher(line);
                if (!m.matches()) {
                    this.mBlock.add(line);
                }
                return;
            }
        }
        if ((m = THROTTLE.matcher(line)).matches()) {
            this.mMonkeyLog.setThrottle(Integer.parseInt(m.group(1)));
        }
        if ((m = SEED_AND_TARGET_COUNT.matcher(line)).matches()) {
            this.mMonkeyLog.setSeed(Long.parseLong(m.group(1)));
            this.mMonkeyLog.setTargetCount(Integer.parseInt(m.group(2)));
        }
        if ((m = SECURITY_EXCEPTIONS.matcher(line)).matches()) {
            this.mMonkeyLog.setIgnoreSecurityExceptions(true);
        }
        if ((m = PACKAGES.matcher(line)).matches()) {
            this.mMonkeyLog.addPackage(m.group(1));
        }
        if ((m = CATEGORIES.matcher(line)).matches()) {
            this.mMonkeyLog.addCategory(m.group(1));
        }
        if ((m = START_UPTIME.matcher(line)).matches()) {
            this.mMonkeyLog.setStartTime(this.parseTime(m.group(1)));
            this.mMonkeyLog.setStartUptimeDuration((long)(Double.parseDouble(m.group(2)) * 1000.0));
        }
        if ((m = STOP_UPTIME.matcher(line)).matches()) {
            this.mMonkeyLog.setStopTime(this.parseTime(m.group(1)));
            this.mMonkeyLog.setStopUptimeDuration((long)(Double.parseDouble(m.group(2)) * 1000.0));
            this.mMonkeyLog.setTotalDuration(60000 * Integer.parseInt(m.group(3)) + 1000 * Integer.parseInt(m.group(4)));
        }
        if ((m = INTERMEDIATE_COUNT.matcher(line)).matches()) {
            this.mMonkeyLog.setIntermediateCount(Integer.parseInt(m.group(1)));
        }
        if ((m = FINAL_COUNT.matcher(line)).matches()) {
            this.mMonkeyLog.setFinalCount(Integer.parseInt(m.group(1)));
        }
        if ((m = FINISHED.matcher(line)).matches()) {
            this.mMonkeyLog.setIsFinished(true);
        }
        if ((m = NO_ACTIVITIES.matcher(line)).matches()) {
            this.mMonkeyLog.setNoActivities(true);
        }
        if ((m = DROPPED_KEYS.matcher(line)).matches()) {
            this.mMonkeyLog.setDroppedCount(MonkeyLogItem.DroppedCategory.KEYS, Integer.parseInt(m.group(1)));
        }
        if ((m = DROPPED_POINTERS.matcher(line)).matches()) {
            this.mMonkeyLog.setDroppedCount(MonkeyLogItem.DroppedCategory.POINTERS, Integer.parseInt(m.group(1)));
        }
        if ((m = DROPPED_TRACKBALLS.matcher(line)).matches()) {
            this.mMonkeyLog.setDroppedCount(MonkeyLogItem.DroppedCategory.TRACKBALLS, Integer.parseInt(m.group(1)));
        }
        if ((m = DROPPED_FLIPS.matcher(line)).matches()) {
            this.mMonkeyLog.setDroppedCount(MonkeyLogItem.DroppedCategory.FLIPS, Integer.parseInt(m.group(1)));
        }
        if ((m = DROPPED_ROTATIONS.matcher(line)).matches()) {
            this.mMonkeyLog.setDroppedCount(MonkeyLogItem.DroppedCategory.ROTATIONS, Integer.parseInt(m.group(1)));
        }
        m = ANR.matcher(line);
        if (this.mMonkeyLog.getCrash() == null && m.matches()) {
            this.mApp = m.group(1);
            this.mPid = Integer.parseInt(m.group(2));
            this.mBlock = new LinkedList<String>();
            this.mMatchingAnr = true;
        }
        m = CRASH.matcher(line);
        if (this.mMonkeyLog.getCrash() == null && m.matches()) {
            this.mApp = m.group(1);
            this.mPid = Integer.parseInt(m.group(2));
            this.mBlock = new LinkedList<String>();
            this.mMatchingCrash = true;
        }
        m = EMPTY_NATIVE_CRASH.matcher(line);
        if (this.mMonkeyLog.getCrash() == null && m.matches()) {
            crash = new NativeCrashItem();
            ((MiscLogcatItem)crash).setStack("");
            this.addCrashAndReset((MiscLogcatItem)crash);
        }
        m = TRACES_START.matcher(line);
        if (!this.mMatchedTrace && m.matches()) {
            this.mBlock = new LinkedList<String>();
            this.mMatchingTraces = true;
        }
    }

    private void addCrashAndReset(MiscLogcatItem crash) {
        if (crash != null) {
            if (crash.getPid() == null) {
                crash.setPid(this.mPid);
            }
            if (crash.getApp() == null) {
                crash.setApp(this.mApp);
            }
            this.mMonkeyLog.setCrash(crash);
        }
        this.reset();
    }

    private void reset() {
        this.mApp = null;
        this.mPid = null;
        this.mMatchingAnr = false;
        this.mMatchingCrash = false;
        this.mMatchingJavaCrash = false;
        this.mMatchingNativeCrash = false;
        this.mMatchingTraces = false;
        this.mBlock = null;
    }

    private Date parseTime(String timeStr) {
        try {
            return new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy").parse(timeStr);
        }
        catch (ParseException parseException) {
            try {
                return new SimpleDateFormat("E, MM/dd/yyyy hh:mm:ss a").parse(timeStr);
            }
            catch (ParseException parseException2) {
                return null;
            }
        }
    }
}

