/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.MemoryHealthItem;
import com.android.loganalysis.parser.IParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MemoryHealthParser
implements IParser {
    private Map<String, Map<String, Long>> mForeground;
    private Map<String, Map<String, Long>> mBackground;
    private static final Map<String, String> SECTION_MAPPINGS;
    private static final Pattern COUNT_PATTERN;
    private static final Pattern METRIC_PATTERN;
    private static final Pattern PROCESS_PATTERN;

    @Override
    public MemoryHealthItem parse(List<String> lines) {
        Map<String, Map<String, Long>> currentSection = null;
        HashMap<String, Long> currentProcess = new HashMap<String, Long>();
        String processName = null;
        for (String line : lines) {
            if (line.contains("Foreground")) {
                currentSection = this.mForeground = new HashMap<String, Map<String, Long>>();
                continue;
            }
            if (line.contains("Background")) {
                this.mBackground = new HashMap<String, Map<String, Long>>();
                currentSection = this.mBackground;
                continue;
            }
            if (COUNT_PATTERN.matcher(line).matches()) {
                currentProcess.put("count", this.parseLong(line));
                currentSection.put(processName, currentProcess);
                continue;
            }
            if (METRIC_PATTERN.matcher(line).matches()) {
                Matcher m = METRIC_PATTERN.matcher(line);
                m.matches();
                Long value = this.parseLong(m.group(2));
                String key = SECTION_MAPPINGS.get(m.group(1));
                if (key == null) continue;
                currentProcess.put(key, value);
                continue;
            }
            if (!PROCESS_PATTERN.matcher(line).matches()) continue;
            processName = line;
            currentProcess = new HashMap();
        }
        return new MemoryHealthItem(this.mForeground, this.mBackground);
    }

    private long parseLong(String str) {
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public MemoryHealthItem parse(BufferedReader reader) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            lines.add(line);
            line = reader.readLine();
        }
        return this.parse(lines);
    }

    static {
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("Average Dalvik Heap", "dalvik_avg");
        mappings.put("Average Native Heap", "native_avg");
        mappings.put("Average PSS", "pss_avg");
        mappings.put("Peak Dalvik Heap", "dalvik_peak");
        mappings.put("Peak Native Heap", "native_peak");
        mappings.put("Peak PSS", "pss_peak");
        mappings.put("Average Summary Java Heap", "summary_java_heap_avg");
        mappings.put("Average Summary Native Heap", "summary_native_heap_avg");
        mappings.put("Average Summary Code", "summary_code_avg");
        mappings.put("Average Summary Stack", "summary_stack_avg");
        mappings.put("Average Summary Graphics", "summary_graphics_avg");
        mappings.put("Average Summary Other", "summary_other_avg");
        mappings.put("Average Summary System", "summary_system_avg");
        mappings.put("Average Summary Overall Pss", "summary_overall_pss_avg");
        SECTION_MAPPINGS = Collections.unmodifiableMap(mappings);
        COUNT_PATTERN = Pattern.compile("^Count (\\d+)$");
        METRIC_PATTERN = Pattern.compile("^([^:]+): (\\d+)$");
        PROCESS_PATTERN = Pattern.compile("^\\S+$");
    }
}

