/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.DumpsysProcessMeminfoItem;
import com.android.loganalysis.parser.IParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DumpsysProcessMeminfoParser
implements IParser {
    private static final Pattern MEMINFO_OUTPUT = Pattern.compile("(\\d+),(\\d+),([^,]+),((?:(?:N/A|\\d+),){44})(.*)");
    private static final Pattern MEMINFO_ADDITIONAL_OUTPUT = Pattern.compile("([^,]+),((?:(?:N/A|\\d+),){8})");
    private static final Pattern MEMINFO_VALUE = Pattern.compile("(N/A|\\d+),");

    @Override
    public DumpsysProcessMeminfoItem parse(List<String> lines) {
        DumpsysProcessMeminfoItem item = new DumpsysProcessMeminfoItem();
        block4: for (String line : lines) {
            Matcher m = MEMINFO_OUTPUT.matcher(line);
            if (!m.matches()) continue;
            try {
                item.setPid(Integer.parseInt(m.group(2)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            item.setProcessName(m.group(3));
            String mainValues = m.group(4);
            Matcher mainMatcher = MEMINFO_VALUE.matcher(mainValues);
            Map nativeData = (Map)item.get("NATIVE");
            Map dalvikData = (Map)item.get("DALVIK");
            Map otherData = (Map)item.get("OTHER");
            Map totalData = (Map)item.get("TOTAL");
            for (int i = 0; i < DumpsysProcessMeminfoItem.MAIN_OUTPUT_ORDER.length; ++i) {
                String curMeasurement = DumpsysProcessMeminfoItem.MAIN_OUTPUT_ORDER[i];
                this.parseNextValue(mainMatcher, nativeData, curMeasurement);
                this.parseNextValue(mainMatcher, dalvikData, curMeasurement);
                this.parseNextValue(mainMatcher, otherData, curMeasurement);
                this.parseNextValue(mainMatcher, totalData, curMeasurement);
            }
            String additionalData = m.group(5);
            Matcher additionalMatcher = MEMINFO_ADDITIONAL_OUTPUT.matcher(additionalData);
            while (additionalMatcher.find()) {
                try {
                    String curLabel = additionalMatcher.group(1);
                    Matcher additionalValueMatcher = MEMINFO_VALUE.matcher(additionalMatcher.group(2));
                    HashMap<String, Long> curData = new HashMap<String, Long>();
                    for (int i = 0; i < DumpsysProcessMeminfoItem.OTHER_OUTPUT_ORDER.length; ++i) {
                        String curMeasurement = DumpsysProcessMeminfoItem.OTHER_OUTPUT_ORDER[i];
                        this.parseNextValue(additionalValueMatcher, curData, curMeasurement);
                    }
                    item.put(curLabel, curData);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    continue block4;
                }
            }
        }
        return item;
    }

    private void parseNextValue(Matcher m, Map<String, Long> output, String key) {
        if (!m.find()) {
            return;
        }
        String value = m.group(1);
        if ("N/A".equals(value)) {
            return;
        }
        try {
            output.put(key, Long.parseLong(value));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

