/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.ActivityServiceItem;
import com.android.loganalysis.item.LocationDumpsItem;
import com.android.loganalysis.parser.AbstractSectionParser;
import com.android.loganalysis.parser.LocationServiceParser;
import com.android.loganalysis.parser.NoopParser;
import java.util.List;

public class ActivityServiceParser
extends AbstractSectionParser {
    private static final String LOCATION_SECTION_REGEX = "^\\s*SERVICE com.google.android.gms/com.google.android.location.internal.GoogleLocationManagerService \\w+ pid=\\d+";
    private static final String NOOP_SECTION_REGEX = "^\\s*SERVICE .*/.*";
    private LocationServiceParser mLocationParser = new LocationServiceParser();
    private ActivityServiceItem mActivityServiceItem = null;
    private boolean mParsedInput = false;

    @Override
    public ActivityServiceItem parse(List<String> lines) {
        this.setup();
        for (String line : lines) {
            if (!this.mParsedInput && !"".equals(line.trim())) {
                this.mParsedInput = true;
            }
            this.parseLine(line);
        }
        this.commit();
        return this.mActivityServiceItem;
    }

    protected void setup() {
        this.addSectionParser(this.mLocationParser, LOCATION_SECTION_REGEX);
        this.addSectionParser(new NoopParser(), NOOP_SECTION_REGEX);
    }

    @Override
    protected void commit() {
        super.commit();
        if (this.mParsedInput && this.mActivityServiceItem == null) {
            this.mActivityServiceItem = new ActivityServiceItem();
        }
        if (this.mActivityServiceItem != null) {
            this.mActivityServiceItem.setLocationDumps((LocationDumpsItem)this.getSection(this.mLocationParser));
        }
    }
}

