/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.item;

import com.android.loganalysis.item.ConflictingItemException;
import com.android.loganalysis.item.GenericItem;
import com.android.loganalysis.item.IItem;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ProcessUsageItem
implements IItem {
    public static final String PROCESS_USAGE = "PROCESS_USAGE";
    private Collection<ProcessUsageInfoItem> mProcessUsage = new LinkedList<ProcessUsageInfoItem>();

    public void addProcessUsage(String processUID, int alarmWakeups, LinkedList<SensorInfoItem> sensorUsage) {
        this.mProcessUsage.add(new ProcessUsageInfoItem(processUID, alarmWakeups, sensorUsage));
    }

    @Override
    public IItem merge(IItem other) throws ConflictingItemException {
        throw new ConflictingItemException("Wakelock items cannot be merged");
    }

    @Override
    public boolean isConsistent(IItem other) {
        return false;
    }

    public Collection<ProcessUsageInfoItem> getProcessUsage() {
        return this.mProcessUsage;
    }

    @Override
    public JSONObject toJson() {
        JSONObject object = new JSONObject();
        if (this.mProcessUsage != null) {
            try {
                JSONArray processUsage = new JSONArray();
                for (ProcessUsageInfoItem usage : this.mProcessUsage) {
                    processUsage.put((Object)usage.toJson());
                }
                object.put(PROCESS_USAGE, (Object)processUsage);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return object;
    }

    public static class ProcessUsageInfoItem
    extends GenericItem {
        public static final String ALARM_WAKEUPS = "ALARM_WAKEUPS";
        public static final String SENSOR_USAGE = "SENSOR_USAGE";
        public static final String PROCESS_UID = "PROCESS_UID";
        private static final Set<String> ATTRIBUTES = new HashSet<String>(Arrays.asList("ALARM_WAKEUPS", "SENSOR_USAGE", "PROCESS_UID"));

        public ProcessUsageInfoItem(String uid, int alarmWakeups, LinkedList<SensorInfoItem> sensorUsage) {
            super(ATTRIBUTES);
            this.setAttribute(PROCESS_UID, uid);
            this.setAttribute(ALARM_WAKEUPS, alarmWakeups);
            this.setAttribute(SENSOR_USAGE, sensorUsage);
        }

        public int getAlarmWakeups() {
            return (Integer)this.getAttribute(ALARM_WAKEUPS);
        }

        public LinkedList<SensorInfoItem> getSensorUsage() {
            return (LinkedList)this.getAttribute(SENSOR_USAGE);
        }

        public String getProcessUID() {
            return (String)this.getAttribute(PROCESS_UID);
        }

        @Override
        public JSONObject toJson() {
            JSONObject object = new JSONObject();
            try {
                object.put(PROCESS_UID, (Object)this.getProcessUID());
                JSONArray sensorUsage = new JSONArray();
                for (SensorInfoItem usage : this.getSensorUsage()) {
                    sensorUsage.put((Object)usage.toJson());
                }
                object.put(SENSOR_USAGE, (Object)sensorUsage);
                object.put(ALARM_WAKEUPS, this.getAlarmWakeups());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return object;
        }
    }

    public static class SensorInfoItem
    extends GenericItem {
        public static final String SENSOR_NAME = "SENSOR_NAME";
        public static final String USAGE_DURATION = "USAGE_DURATION";
        private static final Set<String> ATTRIBUTES = new HashSet<String>(Arrays.asList("SENSOR_NAME", "USAGE_DURATION"));

        public SensorInfoItem(String name, long usageDuration) {
            super(ATTRIBUTES);
            this.setAttribute(SENSOR_NAME, name);
            this.setAttribute(USAGE_DURATION, usageDuration);
        }

        public String getSensorName() {
            return (String)this.getAttribute(SENSOR_NAME);
        }

        public long getUsageDurationMs() {
            return (Long)this.getAttribute(USAGE_DURATION);
        }
    }
}

