/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.item;

import com.android.loganalysis.item.GenericItem;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class MemoryHealthItem
extends GenericItem {
    private static final String BACKGROUND = "background";
    private static final String FOREGROUND = "foreground";
    public static final String DALVIK_AVG = "dalvik_avg";
    public static final String NATIVE_AVG = "native_avg";
    public static final String PSS_AVG = "pss_avg";
    public static final String DALVIK_PEAK = "dalvik_peak";
    public static final String NATIVE_PEAK = "native_peak";
    public static final String PSS_PEAK = "pss_peak";
    public static final String SUMMARY_JAVA_HEAP_AVG = "summary_java_heap_avg";
    public static final String SUMMARY_NATIVE_HEAP_AVG = "summary_native_heap_avg";
    public static final String SUMMARY_CODE_AVG = "summary_code_avg";
    public static final String SUMMARY_STACK_AVG = "summary_stack_avg";
    public static final String SUMMARY_GRAPHICS_AVG = "summary_graphics_avg";
    public static final String SUMMARY_OTHER_AVG = "summary_other_avg";
    public static final String SUMMARY_SYSTEM_AVG = "summary_system_avg";
    public static final String SUMMARY_OVERALL_PSS_AVG = "summary_overall_pss_avg";

    public MemoryHealthItem(Map<String, Map<String, Long>> foreground, Map<String, Map<String, Long>> background) {
        super(new HashSet<String>(Arrays.asList(FOREGROUND, BACKGROUND)));
        super.setAttribute(FOREGROUND, foreground);
        super.setAttribute(BACKGROUND, background);
    }

    public Map<String, Map<String, Long>> getForeground() {
        return (Map)super.getAttribute(FOREGROUND);
    }

    public Map<String, Map<String, Long>> getBackground() {
        return (Map)super.getAttribute(BACKGROUND);
    }

    @Override
    public JSONObject toJson() {
        JSONObject memoryHealth = new JSONObject();
        try {
            memoryHealth.put(FOREGROUND, (Object)this.mapToJson(this.getForeground()));
            memoryHealth.put(BACKGROUND, (Object)this.mapToJson(this.getBackground()));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return memoryHealth;
    }

    private JSONObject mapToJson(Map<String, Map<String, Long>> map) {
        JSONObject out = new JSONObject();
        for (Map.Entry<String, Map<String, Long>> entry : map.entrySet()) {
            try {
                out.put(entry.getKey(), (Object)this.processToJson(entry.getValue()));
            }
            catch (JSONException jSONException) {}
        }
        return out;
    }

    private JSONObject processToJson(Map<String, Long> map) {
        JSONObject out = new JSONObject();
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            try {
                out.put(entry.getKey(), (Object)entry.getValue());
            }
            catch (JSONException jSONException) {}
        }
        return out;
    }
}

