/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.IRunUtil;
import java.io.File;
import java.util.stream.Stream;

public class PythonVirtualenvHelper {
    private static final String PATH = "PATH";
    private static final String PYTHONHOME = "PYTHONHOME";
    private static final String PYTHONPATH = "PYTHONPATH";
    public static final String VIRTUAL_ENV = "VIRTUAL_ENV";

    public static String getPythonBinDir(String virtualenvPath) {
        if (virtualenvPath == null) {
            throw new NullPointerException("Path to the Python virtual environment should not be null");
        }
        File res = new File(virtualenvPath, "bin");
        if (!res.exists()) {
            throw new RuntimeException("Invalid python virtualenv path " + res.getAbsolutePath());
        }
        return res.getAbsolutePath();
    }

    public static void activate(IRunUtil runUtil, File virtualenvDir) {
        PythonVirtualenvHelper.activate(runUtil, virtualenvDir.getAbsolutePath());
    }

    public static void activate(IRunUtil runUtil, String virtualenvPath) {
        String pythonBinDir = PythonVirtualenvHelper.getPythonBinDir(virtualenvPath);
        String separater = ":";
        String pythonPath = PythonVirtualenvHelper.getPackageInstallLocation(runUtil, virtualenvPath) + separater + System.getenv(PYTHONPATH);
        runUtil.setEnvVariable(PATH, pythonBinDir + separater + System.getenv().get(PATH));
        runUtil.setEnvVariable(VIRTUAL_ENV, virtualenvPath);
        runUtil.setEnvVariable(PYTHONPATH, pythonPath);
        runUtil.unsetEnvVariable(PYTHONHOME);
        LogUtil.CLog.d((String)"Activating virtual environment:");
        LogUtil.CLog.d((String)"%s: %s", (Object[])new Object[]{PATH, pythonBinDir + separater + System.getenv().get(PATH)});
        LogUtil.CLog.d((String)"%s: %s", (Object[])new Object[]{VIRTUAL_ENV, virtualenvPath});
        LogUtil.CLog.d((String)"%s: %s", (Object[])new Object[]{PYTHONPATH, pythonPath});
    }

    private static String getPipPath(String virtualenvPath) {
        File pipFile = new File(PythonVirtualenvHelper.getPythonBinDir(virtualenvPath), "pip3");
        return pipFile.getAbsolutePath();
    }

    public static String getPackageInstallLocation(IRunUtil runUtil, String virtualenvPath) {
        CommandResult result = runUtil.runTimedCmd(60000L, new String[]{PythonVirtualenvHelper.getPipPath(virtualenvPath), "show", "pip"});
        if (result.getStatus() != CommandStatus.SUCCESS) {
            throw new RuntimeException(String.format("Fail to run command: %s show pip.\nStatus:%s\nStdout:%s\nStderr:%s", PythonVirtualenvHelper.getPipPath(virtualenvPath), result.getStatus(), result.getStdout(), result.getStderr()));
        }
        String stdout = result.getStdout();
        String[] lines = stdout.split("\n");
        String locationLine = Stream.of(lines).filter(x -> x.startsWith("Location")).findFirst().orElse("");
        return locationLine.split(" ")[1];
    }
}

