/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.rust;

import com.android.ddmlib.MultiLineReceiver;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RustTestResultParser
extends MultiLineReceiver {
    private String mCurrentTestFile;
    private String mCurrentTestName;
    private String mCurrentTestStatus;
    private String mCurrentTestTime;
    private StringBuilder mCurrentTestTrace;
    private Matcher mCurrentMatcher;
    private Collection<ITestInvocationListener> mListeners = new ArrayList<ITestInvocationListener>();
    private Map<TestDescription, Pair<String, String>> mTestResultCache;
    private Map<TestDescription, String> mTestTraceCache;
    private boolean mSeenOneTestRunStart = false;
    private List<String> mTrackLogsBeforeRunStart = new ArrayList<String>();
    private static int mNumTestsStarted = 0;
    private static int mNumTestsEnded = 0;
    private boolean mDoneCalled = false;
    static final String SKIPPED_ENTRY = "Skipped";
    static final String FAILED_ENTRY = "FailedNoStack";
    static final Pattern COMPLETE_PATTERN = Pattern.compile("test result: (.*) (\\d+) passed; (\\d+) failed; (\\d+) ignored;.*");
    static final Pattern RUST_ONE_LINE_RESULT = Pattern.compile("test (\\S*) (?:- should panic )? *\\.\\.\\. (\\S*)(?: <(\\d+\\.\\d+)s>)?");
    static final Pattern RUST_IGNORE_RESULT = Pattern.compile("test (\\S*) +(?:- should panic )?\\.\\.\\. (ignored).*");
    static final Pattern RUNNING_PATTERN = Pattern.compile("running (.*) test[s]?");
    static final Pattern TEST_FAIL_PATTERN = Pattern.compile("---- (\\S*) stdout ----");
    static final Pattern FAILURES_PATTERN = Pattern.compile("failures:");

    public RustTestResultParser(ITestInvocationListener listener, String runName) {
        this(Arrays.asList(listener), runName);
    }

    public RustTestResultParser(Collection<ITestInvocationListener> listeners, String runName) {
        this.mListeners.addAll(listeners);
        this.mCurrentTestFile = runName;
        this.mCurrentTestTrace = null;
        this.mTestResultCache = new HashMap<TestDescription, Pair<String, String>>();
        this.mTestTraceCache = new HashMap<TestDescription, String>();
    }

    public void processNewLines(String[] lines) {
        if (!this.mSeenOneTestRunStart) {
            this.mTrackLogsBeforeRunStart.addAll(Arrays.asList(lines));
        }
        for (String line : lines) {
            if (this.lineMatchesPattern(line, RUST_IGNORE_RESULT)) {
                this.mCurrentTestName = this.mCurrentMatcher.group(1);
                this.mCurrentTestStatus = this.mCurrentMatcher.group(2);
                this.mCurrentTestTime = null;
                ++mNumTestsEnded;
                this.reportTestResult();
                continue;
            }
            if (this.lineMatchesPattern(line, RUST_ONE_LINE_RESULT)) {
                this.mCurrentTestName = this.mCurrentMatcher.group(1);
                this.mCurrentTestStatus = this.mCurrentMatcher.group(2);
                this.mCurrentTestTime = this.mCurrentMatcher.group(3);
                ++mNumTestsEnded;
                this.reportTestResult();
                continue;
            }
            if (this.lineMatchesPattern(line, RUNNING_PATTERN)) {
                this.mSeenOneTestRunStart = true;
                try {
                    mNumTestsStarted = Integer.parseInt(this.mCurrentMatcher.group(1));
                }
                catch (NumberFormatException e) {
                    LogUtil.CLog.e((String)"Unable to determine number of tests expected, received: %s", (Object[])new Object[]{this.mCurrentMatcher.group(1)});
                }
                mNumTestsEnded = 0;
                this.mTrackLogsBeforeRunStart.clear();
                continue;
            }
            if (this.lineMatchesPattern(line, TEST_FAIL_PATTERN)) {
                if (this.mCurrentTestTrace != null) {
                    this.reportTestTrace();
                }
                this.mCurrentTestName = this.mCurrentMatcher.group(1);
                this.mCurrentTestTrace = new StringBuilder();
                continue;
            }
            if (this.lineMatchesPattern(line, FAILURES_PATTERN)) {
                if (this.mCurrentTestTrace == null) continue;
                this.reportTestTrace();
                this.mCurrentTestTrace = null;
                continue;
            }
            if (this.mCurrentTestTrace == null) continue;
            this.mCurrentTestTrace.append(line).append('\n');
        }
    }

    int processRunSummary(String line) {
        try {
            if (!this.lineMatchesPattern(line, COMPLETE_PATTERN)) {
                throw new RuntimeException("Failed to parse summary line: " + line);
            }
            int passed = Integer.parseInt(this.mCurrentMatcher.group(2));
            int failed = Integer.parseInt(this.mCurrentMatcher.group(3));
            int ignored = Integer.parseInt(this.mCurrentMatcher.group(4));
            return passed + failed + ignored;
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Failed to parse number in " + line);
        }
    }

    private boolean lineMatchesPattern(String line, Pattern p) {
        this.mCurrentMatcher = p.matcher(line);
        return this.mCurrentMatcher.matches();
    }

    public void done() {
        if (this.mDoneCalled) {
            return;
        }
        this.mDoneCalled = true;
        for (ITestInvocationListener listener : this.mListeners) {
            for (Map.Entry<TestDescription, Pair<String, String>> test : this.mTestResultCache.entrySet()) {
                String status = (String)test.getValue().first;
                Double time = this.parseTime((String)test.getValue().second);
                long startTime = System.currentTimeMillis();
                if (time == null) {
                    listener.testStarted(test.getKey());
                } else {
                    listener.testStarted(test.getKey(), startTime);
                }
                if (SKIPPED_ENTRY.equals(status)) {
                    listener.testIgnored(test.getKey());
                } else if (FAILED_ENTRY.equals(status)) {
                    listener.testFailed(test.getKey(), this.mTestTraceCache.getOrDefault(test.getKey(), ""));
                } else if (status != null) {
                    listener.testFailed(test.getKey(), status);
                }
                if (time == null) {
                    listener.testEnded(test.getKey(), new HashMap());
                    continue;
                }
                listener.testEnded(test.getKey(), startTime + (long)(time * 1000.0), new HashMap());
            }
            if (!this.mSeenOneTestRunStart) {
                listener.testRunFailed(String.format("test did not report any run:\n%s", String.join((CharSequence)"\n", this.mTrackLogsBeforeRunStart)));
                continue;
            }
            if (mNumTestsStarted <= mNumTestsEnded) continue;
            listener.testRunFailed(String.format("Test run incomplete. Started %d tests, finished %d", mNumTestsStarted, mNumTestsEnded));
        }
    }

    private void reportTestResult() {
        TestDescription testId = new TestDescription(this.mCurrentTestFile, this.mCurrentTestName);
        String status = this.mCurrentTestStatus.equals("ok") ? null : (this.mCurrentTestStatus.startsWith("ignored") ? SKIPPED_ENTRY : (this.mCurrentTestStatus.equals("FAILED") ? FAILED_ENTRY : this.mCurrentTestStatus));
        this.mTestResultCache.put(testId, (Pair<String, String>)new Pair((Object)status, (Object)this.mCurrentTestTime));
    }

    private void reportTestTrace() {
        int lastNewline;
        for (lastNewline = this.mCurrentTestTrace.length(); lastNewline > 0 && this.mCurrentTestTrace.charAt(lastNewline - 1) == '\n'; --lastNewline) {
        }
        this.mCurrentTestTrace.delete(lastNewline, this.mCurrentTestTrace.length());
        TestDescription testId = new TestDescription(this.mCurrentTestFile, this.mCurrentTestName);
        this.mTestTraceCache.put(testId, this.mCurrentTestTrace.toString());
    }

    private Double parseTime(String time) {
        if (time == null) {
            return null;
        }
        try {
            return Double.valueOf(time);
        }
        catch (NumberFormatException e) {
            LogUtil.CLog.e((String)"Test run time value is invalid, received: %s", (Object[])new Object[]{time});
            return null;
        }
    }

    public boolean isCancelled() {
        return false;
    }
}

