/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.rust;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.CollectingOutputReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.coverage.CoverageOptions;
import com.android.tradefed.testtype.rust.RustTestBase;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;

@OptionClass(alias="rust-device")
public class RustBinaryTest
extends RustTestBase
implements IDeviceTest,
IConfigurationReceiver {
    static final String DEFAULT_TEST_PATH = "/data/local/tmp";
    @Option(name="test-device-path", description="The path on the device where tests are located.")
    private String mTestDevicePath = "/data/local/tmp";
    @Option(name="module-name", description="The name of the test module to run.")
    private String mTestModule = null;
    private IConfiguration mConfiguration = null;
    private ITestDevice mDevice = null;

    public void setConfiguration(IConfiguration configuration) {
        this.mConfiguration = configuration;
    }

    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    public ITestDevice getDevice() {
        return this.mDevice;
    }

    public void setModuleName(String name) {
        this.mTestModule = name;
    }

    public String getTestModule() {
        return this.mTestModule;
    }

    private String getTestPath() {
        StringBuilder testPath = new StringBuilder(this.mTestDevicePath);
        String testModule = this.getTestModule();
        if (testModule != null) {
            testPath.append("/");
            testPath.append(testModule);
        }
        return testPath.toString();
    }

    String getFileName(String fullPath) {
        int pos = fullPath.lastIndexOf(47);
        if (pos == -1) {
            return fullPath;
        }
        String fileName = fullPath.substring(pos + 1);
        if (fileName.isEmpty()) {
            throw new IllegalArgumentException("input should not end with \"/\"");
        }
        return fileName;
    }

    private boolean shouldSkipFile(String fullPath) throws DeviceNotAvailableException {
        if (fullPath == null || fullPath.isEmpty()) {
            return true;
        }
        String moduleName = this.getTestModule();
        String fileName = this.getFileName(fullPath);
        if (moduleName != null && !fileName.startsWith(moduleName)) {
            return true;
        }
        return !this.mDevice.isExecutable(fullPath);
    }

    private boolean doRunAllTestsInSubdirectory(String root, ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (this.mDevice.isDirectory(root)) {
            LogUtil.CLog.d((String)"Look into rust directory %s on %s", (Object[])new Object[]{root, this.mDevice.getSerialNumber()});
            boolean found = false;
            for (String child : this.mDevice.getChildren(root)) {
                LogUtil.CLog.d((String)"Look into child path %s", (Object[])new Object[]{root + "/" + child});
                if (!this.doRunAllTestsInSubdirectory(root + "/" + child, listener)) continue;
                found = true;
            }
            return found;
        }
        if (this.shouldSkipFile(root)) {
            LogUtil.CLog.d((String)"Skip rust test %s on %s", (Object[])new Object[]{root, this.mDevice.getSerialNumber()});
            return false;
        }
        LogUtil.CLog.d((String)"To run rust test %s on %s", (Object[])new Object[]{root, this.mDevice.getSerialNumber()});
        this.runTest(listener, root);
        return true;
    }

    private void runInvocation(RustTestBase.Invocation invocation, IShellOutputReceiver receiver, String ... extraArgs) throws DeviceNotAvailableException {
        StringBuilder commandBuilder = new StringBuilder();
        commandBuilder.append("cd ");
        commandBuilder.append(invocation.workingDir);
        commandBuilder.append(" && ");
        for (RustTestBase.EnvPair envPair : invocation.env) {
            commandBuilder.append(envPair.key);
            commandBuilder.append("=");
            commandBuilder.append(envPair.val);
            commandBuilder.append(" ");
        }
        for (String arg : invocation.command) {
            commandBuilder.append(arg);
            commandBuilder.append(" ");
        }
        for (String arg : extraArgs) {
            commandBuilder.append(arg);
            commandBuilder.append(" ");
        }
        commandBuilder.deleteCharAt(commandBuilder.length() - 1);
        this.mDevice.executeShellCommand(commandBuilder.toString(), receiver, this.mTestTimeout, TimeUnit.MILLISECONDS, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(ITestInvocationListener listener, String fullPath) throws DeviceNotAvailableException {
        LogUtil.CLog.d((String)("RustBinaryTest runTest: " + fullPath));
        File file = new File(fullPath);
        List<RustTestBase.Invocation> invocations = this.generateInvocations(file);
        HashSet<String> foundTests = new HashSet<String>();
        for (RustTestBase.Invocation invocation : invocations) {
            try {
                CollectingOutputReceiver receiver = new CollectingOutputReceiver();
                this.runInvocation(invocation, (IShellOutputReceiver)receiver, "--list");
                this.collectTestLines(receiver.getOutput().split("\n"), foundTests);
            }
            catch (DeviceNotAvailableException e) {
                LogUtil.CLog.e((String)"Could not retrieve tests list from device: %s", (Object[])new Object[]{e.getMessage()});
                throw e;
            }
        }
        int testCount = foundTests.size();
        LogUtil.CLog.d((String)"Total test count: %d", (Object[])new Object[]{testCount});
        long startTimeMs = System.currentTimeMillis();
        String name = new File(fullPath).getName();
        listener.testRunStarted(name, testCount, 0, startTimeMs);
        for (RustTestBase.Invocation invocation : invocations) {
            if (this.mConfiguration != null && this.mConfiguration.getCoverageOptions().getCoverageToolchains().contains(CoverageOptions.Toolchain.GCOV)) {
                invocation.env.add(new RustTestBase.EnvPair(this, "GCOV_PREFIX", "/data/misc/trace"));
            }
            IShellOutputReceiver resultParser = this.createParser(listener, name);
            try {
                this.runInvocation(invocation, resultParser, new String[0]);
            }
            catch (DeviceNotAvailableException e) {
                listener.testRunFailed(String.format("Device not available: %s", e.getMessage()));
            }
            finally {
                resultParser.flush();
            }
        }
        long testTimeMs = System.currentTimeMillis() - startTimeMs;
        listener.testRunEnded(testTimeMs, new HashMap());
    }

    private void wrongTestPath(String msg, String testPath, ITestInvocationListener listener) {
        LogUtil.CLog.e((String)(msg + testPath));
        long startTimeMs = System.currentTimeMillis();
        listener.testRunStarted(testPath, 1, 0, startTimeMs);
        listener.testRunFailed(msg + testPath);
        listener.testRunEnded(0L, new HashMap());
    }

    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (this.mDevice == null) {
            throw new IllegalArgumentException("Device has not been set");
        }
        String testPath = this.getTestPath();
        if (!this.mDevice.doesFileExist(testPath)) {
            this.wrongTestPath("Could not find test directory ", testPath, listener);
            return;
        }
        LogUtil.CLog.d((String)("To run tests in directory " + testPath));
        if (!this.doRunAllTestsInSubdirectory(testPath, listener)) {
            this.wrongTestPath("No test found under ", testPath, listener);
        }
    }
}

