/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.rust;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.tradefed.build.BuildInfoKey;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.TestErrorIdentifier;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.testtype.rust.RustTestBase;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.TestRunnerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@OptionClass(alias="rust-host")
public class RustBinaryHostTest
extends RustTestBase
implements IBuildReceiver {
    static final String RUST_LOG_STDERR_FORMAT = "%s-stderr";
    static final String RUST_LOG_STDOUT_FORMAT = "%s-stdout";
    @Option(name="test-file", description="The test file name or file path.")
    private Set<String> mBinaryNames = new HashSet<String>();
    private IBuildInfo mBuildInfo;

    public void setBuild(IBuildInfo buildInfo) {
        this.mBuildInfo = buildInfo;
    }

    public final void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        try {
            List<File> rustFilesList = this.findFiles();
            for (File file : rustFilesList) {
                if (!file.exists()) {
                    LogUtil.CLog.d((String)"ignoring %s which doesn't look like a test file.", (Object[])new Object[]{file.getAbsolutePath()});
                    continue;
                }
                file.setExecutable(true);
                this.runSingleRustFile(listener, file);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<File> findFiles() throws IOException {
        File testsDir = this.mBuildInfo.getFile(BuildInfoKey.BuildInfoFileKey.HOST_LINKED_DIR);
        if (testsDir == null && this.mBuildInfo instanceof IDeviceBuildInfo) {
            testsDir = ((IDeviceBuildInfo)this.mBuildInfo).getTestsDir();
        }
        ArrayList<File> files = new ArrayList<File>();
        for (String fileName : this.mBinaryNames) {
            File res = null;
            File filePath = new File(fileName);
            String paths = "";
            if (filePath.isAbsolute()) {
                res = filePath;
            } else {
                if (testsDir == null) {
                    throw new RuntimeException(String.format("Cannot find %s without test directory", fileName));
                }
                paths = testsDir + "\n";
                String baseName = filePath.getName();
                if (!baseName.equals(fileName)) {
                    try {
                        Set candidates = FileUtil.findFilesObject((File)testsDir, (String)baseName);
                        for (File f : candidates) {
                            paths = paths + String.format("  found: %s\n", f.getPath());
                            if (!f.getPath().endsWith(fileName)) continue;
                            res = f;
                            break;
                        }
                        if (res == null) {
                            LogUtil.CLog.e((String)"Cannot find %s; try to find %s", (Object[])new Object[]{fileName, baseName});
                        }
                    }
                    catch (IOException e) {
                        res = null;
                    }
                }
                if (res == null && (res = FileUtil.findFile((String)baseName, (IAbi)this.getAbi(), (File[])new File[]{testsDir})) != null && res.isDirectory()) {
                    File byBaseName;
                    File currentDir = res;
                    res = FileUtil.findFile((String)baseName, (IAbi)this.getAbi(), (File[])new File[]{currentDir});
                    if (res == null && (byBaseName = FileUtil.findFile((String)(baseName + ".*"), (IAbi)this.getAbi(), (File[])new File[]{currentDir})) != null && byBaseName.isFile()) {
                        res = byBaseName;
                    }
                }
            }
            if (res == null) {
                throw new RuntimeException(String.format("Cannot find %s under %s", fileName, paths));
            }
            files.add(res);
        }
        return files;
    }

    private void runSingleRustFile(ITestInvocationListener listener, File file) {
        LogUtil.CLog.d((String)"Run single Rust File: %s", (Object[])new Object[]{file.getAbsolutePath()});
        List<RustTestBase.Invocation> invocations = this.generateInvocations(file);
        HashSet<String> foundTests = new HashSet<String>();
        for (RustTestBase.Invocation invocation : invocations) {
            boolean success = this.countTests(invocation, foundTests);
            if (success) continue;
            FailureDescription failure = FailureDescription.create((String)"Could not count the number of tests", (TestRecordProto.FailureStatus)TestRecordProto.FailureStatus.TEST_FAILURE);
            listener.testRunStarted(file.getName(), 0);
            listener.testRunFailed(failure);
            listener.testRunEnded(0L, new HashMap());
            LogUtil.CLog.e((String)failure.getErrorMessage());
            return;
        }
        int testCount = foundTests.size();
        LogUtil.CLog.d((String)"Total test count: %d", (Object[])new Object[]{testCount});
        long startTimeMs = System.currentTimeMillis();
        listener.testRunStarted(file.getName(), testCount, 0, startTimeMs);
        if (testCount > 0) {
            for (RustTestBase.Invocation invocation : invocations) {
                try {
                    this.runTest(listener, invocation, file.getName());
                }
                catch (IOException e) {
                    listener.testRunFailed(e.getMessage());
                    long testTimeMs = System.currentTimeMillis() - startTimeMs;
                    listener.testRunEnded(testTimeMs, new HashMap());
                    throw new RuntimeException(e);
                }
            }
        }
        long testTimeMs = System.currentTimeMillis() - startTimeMs;
        listener.testRunEnded(testTimeMs, new HashMap());
    }

    private boolean countTests(RustTestBase.Invocation invocation, Set<String> foundTests) {
        CommandResult listResult = this.runInvocation(invocation, "--list");
        if (listResult.getStatus() == CommandStatus.SUCCESS) {
            this.collectTestLines(listResult.getStdout().split("\n"), foundTests);
            return true;
        }
        LogUtil.CLog.w((String)"Could not run command '%s' to get test list.\nstdout: %s\nstderr: %s", (Object[])new Object[]{String.join((CharSequence)" ", invocation.command) + " --list", listResult.getStdout(), listResult.getStderr()});
        return false;
    }

    private CommandResult runInvocation(RustTestBase.Invocation invocation, String ... extraArgs) {
        String ldLibraryPath;
        IRunUtil runUtil = this.getRunUtil();
        runUtil.setWorkingDir(invocation.workingDir);
        boolean ldLibraryPathSetInEnv = false;
        for (RustTestBase.EnvPair envPair : invocation.env) {
            runUtil.setEnvVariable(envPair.key, envPair.val);
            if (!"LD_LIBRARY_PATH".equals(envPair.key)) continue;
            ldLibraryPathSetInEnv = true;
        }
        if (!ldLibraryPathSetInEnv && (ldLibraryPath = TestRunnerUtil.getLdLibraryPath((File)new File(invocation.command[0]))) != null) {
            runUtil.setEnvVariable("LD_LIBRARY_PATH", ldLibraryPath);
        }
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(invocation.command));
        command.addAll(Arrays.asList(extraArgs));
        return runUtil.runTimedCmd(this.mTestTimeout, command.toArray(new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(ITestInvocationListener listener, RustTestBase.Invocation invocation, String runName) throws IOException {
        CommandResult result = this.runInvocation(invocation, new String[0]);
        if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
            String message = String.format("Something went wrong when running the rust binary:Exit Code: %s\nstdout: %s\nstderr: %s", result.getExitCode(), result.getStdout(), result.getStderr());
            FailureDescription failure = FailureDescription.create((String)message, (TestRecordProto.FailureStatus)TestRecordProto.FailureStatus.TEST_FAILURE).setErrorIdentifier((ErrorIdentifier)TestErrorIdentifier.TEST_BINARY_EXIT_CODE_ERROR);
            listener.testRunFailed(failure);
            LogUtil.CLog.e((String)message);
        }
        File resultFile = null;
        try {
            FileInputStreamSource data;
            resultFile = FileUtil.createTempFile((String)"rust-res", (String)".txt");
            if (result.getStderr().length() > 0) {
                FileUtil.writeToFile((String)result.getStderr(), (File)resultFile);
                data = new FileInputStreamSource(resultFile);
                try {
                    listener.testLog(String.format(RUST_LOG_STDERR_FORMAT, runName), LogDataType.TEXT, (InputStreamSource)data);
                }
                finally {
                    data.close();
                }
            }
            if (result.getStdout().length() > 0) {
                FileUtil.writeToFile((String)result.getStdout(), (File)resultFile);
                data = new FileInputStreamSource(resultFile);
                try {
                    listener.testLog(String.format(RUST_LOG_STDOUT_FORMAT, runName), LogDataType.TEXT, (InputStreamSource)data);
                }
                finally {
                    data.close();
                }
            }
            IShellOutputReceiver parser = this.createParser(listener, runName);
            parser.addOutput(result.getStdout().getBytes(), 0, result.getStdout().length());
            parser.flush();
        }
        catch (RuntimeException e) {
            listener.testRunFailed(String.format("Failed to parse the rust test output: %s", e.getMessage()));
            LogUtil.CLog.e((Throwable)e);
        }
        finally {
            FileUtil.deleteFile((File)resultFile);
        }
    }

    IRunUtil getRunUtil() {
        return new RunUtil();
    }
}

