/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.python;

import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.invoker.ExecutionFiles;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ByteArrayInputStreamSource;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.ResultForwarder;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.ITestFilterReceiver;
import com.android.tradefed.testtype.PythonUnitTestResultParser;
import com.android.tradefed.testtype.TestTimeoutEnforcer;
import com.android.tradefed.util.AdbUtils;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@OptionClass(alias="python-host")
public class PythonBinaryHostTest
implements IRemoteTest,
ITestFilterReceiver {
    protected static final String ANDROID_SERIAL_VAR = "ANDROID_SERIAL";
    protected static final String LD_LIBRARY_PATH = "LD_LIBRARY_PATH";
    static final String USE_TEST_OUTPUT_FILE_OPTION = "use-test-output-file";
    static final String TEST_OUTPUT_FILE_FLAG = "test-output-file";
    private static final String PYTHON_LOG_STDOUT_FORMAT = "%s-stdout";
    private static final String PYTHON_LOG_STDERR_FORMAT = "%s-stderr";
    private static final String PYTHON_LOG_TEST_OUTPUT_FORMAT = "%s-test-output";
    private Set<String> mIncludeFilters = new LinkedHashSet<String>();
    private Set<String> mExcludeFilters = new LinkedHashSet<String>();
    private String mLdLibraryPath = null;
    @Option(name="par-file-name", description="The binary names inside the build info to run.")
    private Set<String> mBinaryNames = new HashSet<String>();
    @Option(name="python-binaries", description="The full path to a runnable python binary. Can be repeated.")
    private Set<File> mBinaries = new HashSet<File>();
    @Option(name="test-timeout", description="Timeout for a single par file to terminate.", isTimeVal=true)
    private long mTestTimeout = 20000L;
    @Option(name="inject-serial-option", description="Whether or not to pass a -s <serialnumber> option to the binary")
    private boolean mInjectSerial = false;
    @Option(name="inject-android-serial", description="Whether or not to pass a ANDROID_SERIAL variable to the process.")
    private boolean mInjectAndroidSerialVar = true;
    @Option(name="python-options", description="Option string to be passed to the binary when running")
    private List<String> mTestOptions = new ArrayList<String>();
    @Option(name="use-test-output-file", description="Whether the test should write results to the file specified via the --test-output-file flag instead of stderr which could contain spurious messages that break result parsing. Using this option requires that the Python test have the necessary logic to accept the flag and write results in the expected format.")
    private boolean mUseTestOutputFile = false;
    @Option(name="test-case-timeout", description="The timeout that will be applied to each test case of the run.")
    private Duration mTestCaseTimeout = Duration.ofSeconds(0L);
    private TestInformation mTestInfo;
    private IRunUtil mRunUtil;

    public void addIncludeFilter(String filter) {
        this.mIncludeFilters.add(filter);
    }

    public void addExcludeFilter(String filter) {
        this.mExcludeFilters.add(filter);
    }

    public void addAllIncludeFilters(Set<String> filters) {
        this.mIncludeFilters.addAll(filters);
    }

    public void addAllExcludeFilters(Set<String> filters) {
        this.mExcludeFilters.addAll(filters);
    }

    public void clearIncludeFilters() {
        this.mIncludeFilters.clear();
    }

    public void clearExcludeFilters() {
        this.mExcludeFilters.clear();
    }

    public Set<String> getIncludeFilters() {
        return this.mIncludeFilters;
    }

    public Set<String> getExcludeFilters() {
        return this.mExcludeFilters;
    }

    public final void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        this.mTestInfo = testInfo;
        File testDir = this.mTestInfo.executionFiles().get(ExecutionFiles.FilesKey.HOST_TESTS_DIRECTORY);
        if (testDir == null || !testDir.exists()) {
            testDir = this.mTestInfo.executionFiles().get(ExecutionFiles.FilesKey.TESTS_DIRECTORY);
        }
        ArrayList<String> ldLibraryPath = new ArrayList<String>();
        if (testDir != null && testDir.exists()) {
            List<String> libPaths = Arrays.asList("lib", "lib64", "host/testcases/lib", "host/testcases/lib64");
            for (String path : libPaths) {
                File libDir = new File(testDir, path);
                if (!libDir.exists()) continue;
                ldLibraryPath.add(libDir.getAbsolutePath());
            }
            if (!ldLibraryPath.isEmpty()) {
                this.mLdLibraryPath = Joiner.on(":").join(ldLibraryPath);
            }
        }
        List<File> pythonFilesList = this.findParFiles();
        for (File pyFile : pythonFilesList) {
            if (!pyFile.exists()) {
                LogUtil.CLog.d((String)"ignoring %s which doesn't look like a test file.", (Object[])new Object[]{pyFile.getAbsolutePath()});
                continue;
            }
            String path = this.mLdLibraryPath;
            List<String> paths = this.findAllSubdir(pyFile.getParentFile(), ldLibraryPath);
            if (this.mLdLibraryPath != null) {
                paths.add(0, this.mLdLibraryPath);
            }
            this.mLdLibraryPath = Joiner.on(":").join(paths);
            pyFile.setExecutable(true);
            this.runSinglePythonFile(listener, testInfo, pyFile);
            this.mLdLibraryPath = path;
        }
    }

    private List<File> findParFiles() {
        ArrayList<File> files = new ArrayList<File>();
        for (String parFileName : this.mBinaryNames) {
            File res = null;
            try {
                res = this.mTestInfo.getDependencyFile(parFileName, false);
                files.add(res);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(String.format("Couldn't find a par file %s", parFileName));
            }
        }
        files.addAll(this.mBinaries);
        return files;
    }

    /*
     * Loose catch block
     */
    private void runSinglePythonFile(ITestInvocationListener listener, TestInformation testInfo, File pyFile) {
        block45: {
            File stderrFile;
            CommandResult result;
            String runName;
            File tempTestOutputFile;
            block43: {
                ArrayList<String> commandLine = new ArrayList<String>();
                commandLine.add(pyFile.getAbsolutePath());
                if (!(this.mTestInfo.getDevice().getIDevice() instanceof StubDevice) && this.mInjectSerial) {
                    commandLine.add("-s");
                    commandLine.add(this.mTestInfo.getDevice().getSerialNumber());
                }
                this.getRunUtil().setWorkingDir(pyFile.getParentFile());
                String separator = System.getProperty("path.separator");
                ArrayList<String> paths = new ArrayList<String>();
                paths.addAll(this.findAllSubdir(pyFile.getParentFile(), new ArrayList<String>()));
                paths.add(System.getenv("PATH"));
                String path = paths.stream().distinct().collect(Collectors.joining(separator));
                LogUtil.CLog.d((String)"Using updated $PATH: %s", (Object[])new Object[]{path});
                this.getRunUtil().setEnvVariablePriority(IRunUtil.EnvPriority.SET);
                this.getRunUtil().setEnvVariable("PATH", path);
                if (this.mLdLibraryPath != null) {
                    this.getRunUtil().setEnvVariable(LD_LIBRARY_PATH, this.mLdLibraryPath);
                }
                if (this.mInjectAndroidSerialVar) {
                    this.getRunUtil().setEnvVariable(ANDROID_SERIAL_VAR, this.mTestInfo.getDevice().getSerialNumber());
                }
                tempTestOutputFile = null;
                if (this.mUseTestOutputFile) {
                    try {
                        tempTestOutputFile = FileUtil.createTempFile((String)"python-test-output", (String)".txt");
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    commandLine.add("--test-output-file");
                    commandLine.add(tempTestOutputFile.getAbsolutePath());
                }
                AdbUtils.updateAdb(testInfo, this.getRunUtil(), this.getAdbPath());
                commandLine.addAll(this.mTestOptions);
                runName = pyFile.getName();
                PythonForwarder forwarder = new PythonForwarder(listener, runName);
                ResultForwarder receiver = forwarder;
                if (this.mTestCaseTimeout.toMillis() > 0L) {
                    receiver = new TestTimeoutEnforcer(this.mTestCaseTimeout.toMillis(), TimeUnit.MILLISECONDS, new ITestInvocationListener[]{receiver});
                }
                PythonUnitTestResultParser pythonParser = new PythonUnitTestResultParser(Arrays.asList(receiver), "python-run", this.mIncludeFilters, this.mExcludeFilters);
                result = null;
                stderrFile = null;
                stderrFile = FileUtil.createTempFile((String)"python-res", (String)".txt");
                if (this.mUseTestOutputFile) {
                    result = this.getRunUtil().runTimedCmd(this.mTestTimeout, commandLine.toArray(new String[0]));
                } else {
                    try (FileOutputStream fileOutputParser = new FileOutputStream(stderrFile);){
                        result = this.getRunUtil().runTimedCmd(this.mTestTimeout, null, (OutputStream)fileOutputParser, commandLine.toArray(new String[0]));
                        fileOutputParser.flush();
                    }
                }
                if (!Strings.isNullOrEmpty(result.getStdout())) {
                    LogUtil.CLog.i((String)"\nstdout:\n%s", (Object[])new Object[]{result.getStdout()});
                    try (ByteArrayInputStreamSource data = new ByteArrayInputStreamSource(result.getStdout().getBytes());){
                        listener.testLog(String.format(PYTHON_LOG_STDOUT_FORMAT, runName), LogDataType.TEXT, (InputStreamSource)data);
                    }
                }
                if (!Strings.isNullOrEmpty(result.getStderr())) {
                    LogUtil.CLog.i((String)"\nstderr:\n%s", (Object[])new Object[]{result.getStderr()});
                }
                File testOutputFile = stderrFile;
                if (this.mUseTestOutputFile) {
                    testOutputFile = tempTestOutputFile;
                    PythonBinaryHostTest.testLogFile(listener, String.format(PYTHON_LOG_TEST_OUTPUT_FORMAT, runName), testOutputFile);
                }
                String testOutput = FileUtil.readStringFromFile((File)testOutputFile);
                pythonParser.processNewLines(testOutput.split("\n"));
                if (stderrFile == null) break block43;
                try {
                    if (this.mUseTestOutputFile) {
                        FileUtil.writeToFile((String)result.getStderr(), (File)stderrFile);
                    }
                    PythonBinaryHostTest.testLogFile(listener, String.format(PYTHON_LOG_STDERR_FORMAT, runName), stderrFile);
                }
                catch (IOException e) {
                    LogUtil.CLog.e((Throwable)e);
                }
            }
            FileUtil.deleteFile((File)stderrFile);
            FileUtil.deleteFile((File)tempTestOutputFile);
            break block45;
            catch (RuntimeException e) {
                block44: {
                    StringBuilder message = new StringBuilder();
                    String stderr = "";
                    try {
                        stderr = FileUtil.readStringFromFile((File)stderrFile);
                    }
                    catch (IOException ioe) {
                        LogUtil.CLog.e((Throwable)ioe);
                    }
                    message.append(String.format("Failed to parse the python logs: %s. Please ensure that verbosity of output is high enough to be parsed. Stderr: %s", e.getMessage(), stderr));
                    if (this.mUseTestOutputFile) {
                        message.append(String.format(" Make sure that your test writes its output to the file specified by the --%s flag and that its contents (%s) are in the format expected by the test runner.", TEST_OUTPUT_FILE_FLAG, String.format(PYTHON_LOG_TEST_OUTPUT_FORMAT, runName)));
                    }
                    this.reportFailure(listener, runName, message.toString());
                    LogUtil.CLog.e((Throwable)e);
                    if (stderrFile == null) break block44;
                    try {
                        if (this.mUseTestOutputFile) {
                            FileUtil.writeToFile((String)result.getStderr(), (File)stderrFile);
                        }
                        PythonBinaryHostTest.testLogFile(listener, String.format(PYTHON_LOG_STDERR_FORMAT, runName), stderrFile);
                    }
                    catch (IOException e2) {
                        LogUtil.CLog.e((Throwable)e2);
                    }
                }
                FileUtil.deleteFile((File)stderrFile);
                FileUtil.deleteFile((File)tempTestOutputFile);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
                {
                    catch (Throwable throwable) {
                        if (stderrFile != null) {
                            try {
                                if (this.mUseTestOutputFile) {
                                    FileUtil.writeToFile((String)result.getStderr(), (File)stderrFile);
                                }
                                PythonBinaryHostTest.testLogFile(listener, String.format(PYTHON_LOG_STDERR_FORMAT, runName), stderrFile);
                            }
                            catch (IOException e3) {
                                LogUtil.CLog.e((Throwable)e3);
                            }
                        }
                        FileUtil.deleteFile((File)stderrFile);
                        FileUtil.deleteFile((File)tempTestOutputFile);
                        throw throwable;
                    }
                }
            }
        }
    }

    IRunUtil getRunUtil() {
        if (this.mRunUtil == null) {
            this.mRunUtil = new RunUtil();
        }
        return this.mRunUtil;
    }

    String getAdbPath() {
        return GlobalConfiguration.getDeviceManagerInstance().getAdbPath();
    }

    private List<String> findAllSubdir(File parentDir, List<String> knownPaths) {
        ArrayList<String> subDir = new ArrayList<String>();
        subDir.add(parentDir.getAbsolutePath());
        if (parentDir.listFiles() == null) {
            return subDir;
        }
        for (File child : parentDir.listFiles()) {
            if (child == null || !child.isDirectory() || knownPaths.contains(child.getAbsolutePath())) continue;
            subDir.addAll(this.findAllSubdir(child, knownPaths));
        }
        return subDir;
    }

    private void reportFailure(ITestInvocationListener listener, String runName, String errorMessage) {
        listener.testRunStarted(runName, 0);
        FailureDescription description = FailureDescription.create((String)errorMessage, (TestRecordProto.FailureStatus)TestRecordProto.FailureStatus.TEST_FAILURE);
        listener.testRunFailed(description);
        listener.testRunEnded(0L, new HashMap());
    }

    private static void testLogFile(ITestInvocationListener listener, String dataName, File f) {
        try (FileInputStreamSource data = new FileInputStreamSource(f);){
            listener.testLog(dataName, LogDataType.TEXT, (InputStreamSource)data);
        }
    }

    public static class PythonForwarder
    extends ResultForwarder {
        private String mRunName;

        public PythonForwarder(ITestInvocationListener listener, String name) {
            super(new ITestInvocationListener[]{listener});
            this.mRunName = name;
        }

        public void testRunStarted(String runName, int testCount) {
            this.testRunStarted(runName, testCount, 0);
        }

        public void testRunStarted(String runName, int testCount, int attempt) {
            this.testRunStarted(runName, testCount, attempt, System.currentTimeMillis());
        }

        public void testRunStarted(String runName, int testCount, int attempt, long startTime) {
            super.testRunStarted(this.mRunName, testCount, attempt, startTime);
        }
    }
}

