/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.pandora;

import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionCopier;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.ExecutionFiles;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.IShardableTest;
import com.android.tradefed.testtype.ITestFilterReceiver;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.PythonVirtualenvHelper;
import com.android.tradefed.util.RunUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;

public class PtsBotTest
implements IRemoteTest,
ITestFilterReceiver,
IShardableTest {
    private static final String TAG = "PandoraPtsBot";
    private static final int PANDORA_SERVER_PORT = 8999;
    private static final int HCI_PROXY_PORT = 1234;
    private static final int HCI_ROOTCANAL_PORT_CF = 7300;
    private static final int CONTROL_ROOTCANAL_PORT_CF = 7500;
    private static final int ROOTCANAL_VSOCK_CID = 2;
    private static final int MODEM_SIMULATOR_VSOCK_CID = 2;
    private static final int MODEM_SIMULATOR_VSOCK_PORT = 9600;
    private int hostPandoraServerPort;
    private int hostHciRootcanalPort;
    private int hostControlRootcanalPort;
    private int hostModemSimulatorPort;
    private static final int PTS_INACTIVITY_TIMEOUT = 90;
    private static final String A2DP_SNK_PROPERTY = "bluetooth.profile.a2dp.sink.enabled";
    private static final String A2DP_SRC_PROPERTY = "bluetooth.profile.a2dp.source.enabled";
    private static final String HFP_HF_PROPERTY = "bluetooth.profile.hfp.hf.enabled";
    private static final String HFP_AG_PROPERTY = "bluetooth.profile.hfp.ag.enabled";
    private IRunUtil mRunUtil = new RunUtil();
    @Option(name="pts-bot-path", description="pts-bot binary path.")
    private File ptsBotPath = new File("pts-bot");
    @Option(name="pts-setup-path", description="Bluetooth SIG pts setup path.")
    private File ptsSetupPath = null;
    @Option(name="create-bin-temp-dir", description="Create a temporary directory to store pts-bot binaries and avoid conflicts when multiple runners are on the same machine")
    private boolean createBinTempDir = false;
    private File binTempDir = null;
    @Option(name="python-home", description="PYTHONHOME value to use while running pts-bot.")
    private File pythonHome = null;
    @Option(name="mmi2grpc", description="mmi2grpc python module path.")
    private File mmi2grpc = null;
    @Option(name="tests-config-file", description="Tests config file.", importance=Option.Importance.ALWAYS)
    private File testsConfigFile = null;
    @Option(name="profile", description="Profile to be tested.", importance=Option.Importance.ALWAYS)
    private SortedSet<String> profiles = new TreeSet<String>();
    @Option(name="physical", description="Run PTS-bot with a physical Bluetooth communication.", importance=Option.Importance.ALWAYS)
    private boolean physical = false;
    @Option(name="max-flaky-tests", description="Maximum number of flaky tests for the entire run.")
    private int maxFlakyTests = 0;
    private int flakyCount = 0;
    @Option(name="max-retries-per-test", description="Maximum number of retries for a flaky test.")
    private int maxRetriesPerTest = 0;
    private final Set<String> includeFilters = new LinkedHashSet<String>();
    private final Set<String> excludeFilters = new LinkedHashSet<String>();
    private int shardIndex = 0;
    private int totalShards = 1;

    public void addIncludeFilter(String filter) {
        this.includeFilters.add(filter);
    }

    public void addAllIncludeFilters(Set<String> filters) {
        this.includeFilters.addAll(filters);
    }

    public void addExcludeFilter(String filter) {
        this.excludeFilters.add(filter);
    }

    public void addAllExcludeFilters(Set<String> filters) {
        this.excludeFilters.addAll(filters);
    }

    public Set<String> getIncludeFilters() {
        return this.includeFilters;
    }

    public Set<String> getExcludeFilters() {
        return this.excludeFilters;
    }

    public void clearIncludeFilters() {
        this.includeFilters.clear();
    }

    public void clearExcludeFilters() {
        this.excludeFilters.clear();
    }

    public Collection<IRemoteTest> split(int shardCountHint) {
        if (this.physical || shardCountHint <= 1) {
            return null;
        }
        ArrayList<IRemoteTest> shards = new ArrayList<IRemoteTest>(shardCountHint);
        boolean startIndex = false;
        int i = 0;
        while (i < shardCountHint) {
            PtsBotTest shard = new PtsBotTest();
            shard.addAllIncludeFilters(this.getIncludeFilters());
            shard.addAllExcludeFilters(this.getExcludeFilters());
            try {
                OptionCopier.copyOptions((Object)this, (Object)shard);
            }
            catch (ConfigurationException e) {
                LogUtil.CLog.e((String)"Failed to copy options: %s", (Object[])new Object[]{e.getMessage()});
            }
            shard.shardIndex = i++;
            shard.totalShards = shardCountHint;
            shards.add(shard);
        }
        return shards;
    }

    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (this.createBinTempDir) {
            try {
                this.binTempDir = FileUtil.createTempDir((String)"pts-bot");
            }
            catch (IOException e) {
                throw new RuntimeException("Not able to create temp directory");
            }
        }
        if (!this.testsConfigFile.exists()) {
            try {
                this.testsConfigFile = testInfo.getDependencyFile(this.testsConfigFile.getName(), false);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Tests config file does not exist");
            }
        }
        if (!this.mmi2grpc.exists()) {
            try {
                File testsDir = testInfo.executionFiles().get(ExecutionFiles.FilesKey.TESTS_DIRECTORY);
                this.mmi2grpc = FileUtil.findDirectory((String)this.mmi2grpc.getName(), (File[])new File[]{testsDir});
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (this.mmi2grpc == null) {
                throw new RuntimeException("mmi2grpc folder does not exist");
            }
        }
        this.ptsBotPath.setExecutable(true);
        this.displayPtsBotVersion();
        LogUtil.CLog.i((String)"Tests config file: %s", (Object[])new Object[]{this.testsConfigFile.getPath()});
        LogUtil.CLog.i((String)"Profiles to be tested: %s", (Object[])new Object[]{this.profiles});
        ITestDevice testDevice = testInfo.getDevice();
        this.hostPandoraServerPort = this.adbForwardPort(testDevice, 0, 8999);
        LogUtil.CLog.i((String)"PTS HCI port: %s", (Object[])new Object[]{this.getHciPort()});
        if (!this.physical) {
            this.hostHciRootcanalPort = this.adbForwardVsockPort(testDevice, 0, 2, 7300);
            this.hostControlRootcanalPort = this.adbForwardVsockPort(testDevice, 0, 2, 7500);
            this.hostModemSimulatorPort = this.adbForwardVsockPort(testDevice, 0, 2, 9600);
        }
        String[] allFilteredTests = this.getAllFilteredTests(testInfo).toArray(new String[0]);
        int chunkSize = allFilteredTests.length / this.totalShards;
        if (allFilteredTests.length % this.totalShards > 0) {
            ++chunkSize;
        }
        int startIndex = this.shardIndex * chunkSize;
        int endIndex = this.totalShards == 1 || this.shardIndex == this.totalShards - 1 ? allFilteredTests.length : (this.shardIndex + 1) * chunkSize;
        String[] tests = Arrays.copyOfRange(allFilteredTests, startIndex, endIndex);
        this.runPtsBotTests(tests, testInfo, listener);
        this.adbForwardRemovePort(testDevice, this.hostPandoraServerPort);
        if (!this.physical) {
            this.adbForwardRemovePort(testDevice, this.hostHciRootcanalPort);
            this.adbForwardRemovePort(testDevice, this.hostControlRootcanalPort);
            this.adbForwardRemovePort(testDevice, this.hostModemSimulatorPort);
        }
        if (this.binTempDir != null) {
            FileUtil.recursiveDelete((File)this.binTempDir);
        }
    }

    private void displayPtsBotVersion() {
        CommandResult c = this.mRunUtil.runTimedCmd(5000L, new String[]{"which", this.ptsBotPath.getPath()});
        if (c.getStatus() != CommandStatus.SUCCESS) {
            LogUtil.CLog.e((String)"Failed to get pts-bot path");
            LogUtil.CLog.e((String)"Status: %s\nStdout: %s\nStderr: %s", (Object[])new Object[]{c.getStatus(), c.getStdout(), c.getStderr()});
            throw new RuntimeException("Failed to get pts-bot path. Error:\n" + c.getStderr());
        }
        String ptsBotAbsolutePath = c.getStdout().trim();
        c = this.mRunUtil.runTimedCmd(5000L, new String[]{ptsBotAbsolutePath, "--version"});
        if (c.getStatus() != CommandStatus.SUCCESS) {
            LogUtil.CLog.e((String)"Failed to get pts-bot version");
            LogUtil.CLog.e((String)"Status: %s\nStdout: %s\nStderr: %s", (Object[])new Object[]{c.getStatus(), c.getStdout(), c.getStderr()});
            throw new RuntimeException("Failed to get pts-bot version. Error:\n" + c.getStderr());
        }
        LogUtil.CLog.d((String)"pts-bot version: %s", (Object[])new Object[]{c.getStdout().trim()});
    }

    private int getHciPort() {
        return this.physical ? 1234 : this.hostHciRootcanalPort;
    }

    private SortedSet<String> getAllFilteredTests(TestInformation testInfo) {
        TreeSet<String> allFilteredTests = new TreeSet<String>();
        for (String profile : this.profiles) {
            if (this.shouldSkipProfileOrTest(profile)) continue;
            allFilteredTests.addAll(Arrays.stream(this.listPtsBotTestsForProfile(profile, testInfo)).filter(testName -> !this.shouldSkipProfileOrTest((String)testName)).collect(Collectors.toList()));
        }
        return allFilteredTests;
    }

    private boolean shouldSkipProfileOrTest(String profileName) {
        for (String filter : this.excludeFilters) {
            if (!profileName.startsWith(filter)) continue;
            return true;
        }
        for (String filter : this.includeFilters) {
            if (profileName.startsWith(filter)) {
                return false;
            }
            if (!filter.startsWith(profileName)) continue;
            return false;
        }
        return !this.includeFilters.isEmpty();
    }

    private String[] listPtsBotTestsForProfile(String profile, TestInformation testInfo) {
        try {
            ProcessBuilder processBuilder = this.ptsBot(testInfo, "--list", profile);
            LogUtil.CLog.i((String)"Running command: %s", (Object[])new Object[]{String.join((CharSequence)" ", processBuilder.command())});
            Process process = processBuilder.start();
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            stdError.lines().forEach(line -> LogUtil.CLog.e((String)line));
            stdError.close();
            String line2 = stdInput.lines().filter(l -> l.startsWith("Tests:")).findFirst().orElse(null);
            stdInput.close();
            if (line2 != null) {
                String testsStr = line2.substring(line2.indexOf("[") + 1, line2.indexOf("]"));
                if (!testsStr.equals("")) {
                    return testsStr.replaceAll("\"", "").split(", ");
                }
                return new String[0];
            }
        }
        catch (IOException e) {
            LogUtil.CLog.e((Throwable)e);
            throw new RuntimeException("Cannot run pts-bot, make sure it is properly installed");
        }
        throw new RuntimeException(String.format("Cannot list tests for %s", profile));
    }

    private void runPtsBotTests(String[] tests, TestInformation testInfo, ITestInvocationListener listener) {
        if (tests.length == 0) {
            LogUtil.CLog.w((String)"No tests to execute");
            return;
        }
        for (String profile : this.profiles) {
            String[] profileTests = (String[])Arrays.stream(tests).filter(testName -> testName.startsWith(profile)).toArray(String[]::new);
            if (profileTests.length > 0) {
                HashMap runMetrics = new HashMap();
                listener.testRunStarted(profile, profileTests.length);
                long startTimestamp = System.currentTimeMillis();
                for (String testName2 : profileTests) {
                    this.toggleA2dpSinkIfNeeded(testInfo.getDevice(), testName2);
                    this.toggleHfpHfIfNeeded(testInfo.getDevice(), testName2);
                    this.runPtsBotTest(profile, testName2, testInfo, listener);
                }
                long endTimestamp = System.currentTimeMillis();
                listener.testRunEnded(endTimestamp - startTimestamp, runMetrics);
                continue;
            }
            LogUtil.CLog.i((String)"No tests applicable for %s", (Object[])new Object[]{profile});
        }
    }

    private void toggleA2dpSinkIfNeeded(ITestDevice testDevice, String testName) {
        LogUtil.CLog.i((String)("toggleA2dpSinkIfNeeded: " + testName));
        if (testName.startsWith("A2DP/SNK") || testName.startsWith("AVCTP/CT") || testName.startsWith("AVDTP/SNK") || testName.startsWith("AVRCP/CT") && !testName.startsWith("AVRCP/CT/VLH") || testName.startsWith("AVRCP/TG/VLH")) {
            this.setProperty(testDevice, A2DP_SNK_PROPERTY, true);
            this.setProperty(testDevice, A2DP_SRC_PROPERTY, false);
        } else if (!this.getProperty(testDevice, A2DP_SRC_PROPERTY).equals("true")) {
            this.setProperty(testDevice, A2DP_SNK_PROPERTY, false);
            this.setProperty(testDevice, A2DP_SRC_PROPERTY, true);
        }
    }

    private void toggleHfpHfIfNeeded(ITestDevice testDevice, String testName) {
        LogUtil.CLog.i((String)("toggleHfpHfIfNeeded: " + testName));
        if (testName.startsWith("HFP/HF")) {
            this.setProperty(testDevice, HFP_HF_PROPERTY, true);
            this.setProperty(testDevice, HFP_AG_PROPERTY, false);
        } else if (!this.getProperty(testDevice, HFP_HF_PROPERTY).equals("true")) {
            this.setProperty(testDevice, HFP_HF_PROPERTY, false);
            this.setProperty(testDevice, HFP_AG_PROPERTY, true);
        }
    }

    private void setProperty(ITestDevice testDevice, String property, boolean enable) {
        LogUtil.CLog.i((String)("setProperty: " + property));
        try {
            String cmd = String.format("setprop %s %s", property, enable);
            CommandResult result = testDevice.executeShellV2Command(cmd);
            if (result.getExitCode() != 0) {
                LogUtil.CLog.e((String)("Failed to set property: " + property + ": " + result.getStderr()));
            }
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.e((String)("setProperty error: " + (Object)((Object)e)));
        }
    }

    private String getProperty(ITestDevice testDevice, String property) {
        LogUtil.CLog.i((String)("getProperty: " + property));
        try {
            String cmd = String.format("getprop %s", property);
            CommandResult result = testDevice.executeShellV2Command(cmd);
            if (result.getExitCode() == 0) {
                return result.getStdout();
            }
            LogUtil.CLog.e((String)("Failed to get property: " + property + ": " + result.getStderr()));
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.e((String)("getProperty error: " + (Object)((Object)e)));
        }
        return "";
    }

    private boolean runPtsBotTest(String profile, String testName, TestInformation testInfo, ITestInvocationListener listener) {
        TestDescription testDescription = new TestDescription(profile, testName);
        listener.testStarted(testDescription);
        LogUtil.CLog.i((String)testName);
        this.androidLogInfo(testInfo.getDevice(), "Test Started: " + testName);
        boolean success = false;
        boolean inconclusive = false;
        int retryCount = 0;
        while (true) {
            try {
                ProcessBuilder processBuilder = this.ptsBot(testInfo, testName, String.valueOf(this.hostPandoraServerPort), String.valueOf(this.hostControlRootcanalPort), String.valueOf(this.hostModemSimulatorPort));
                LogUtil.CLog.i((String)"Running command: %s", (Object[])new Object[]{String.join((CharSequence)" ", processBuilder.command())});
                Process process = processBuilder.start();
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
                BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                    stdError.lines().forEach(line -> LogUtil.CLog.e((String)line));
                    try {
                        stdError.close();
                    }
                    catch (IOException e) {
                        throw new CompletionException(e);
                    }
                });
                Optional<String> lastLine = stdInput.lines().peek(line -> LogUtil.CLog.i((String)line)).reduce((last, value) -> value);
                if (lastLine.isPresent()) {
                    try {
                        success = Integer.parseInt(lastLine.get().split(", ")[1].substring(0, 1)) == 1;
                        inconclusive = Integer.parseInt(lastLine.get().split(", ")[3].substring(0, 1)) == 1;
                    }
                    catch (Exception e) {
                        LogUtil.CLog.e((String)"Failed to parse status");
                    }
                }
                stdInput.close();
                future.join();
            }
            catch (Exception e) {
                LogUtil.CLog.e((Throwable)e);
                LogUtil.CLog.e((String)"Cannot run pts-bot, make sure it is properly installed");
            }
            if (success) break;
            if (++retryCount == 1) {
                ++this.flakyCount;
            }
            if (this.flakyCount > this.maxFlakyTests || retryCount > this.maxRetriesPerTest) break;
            this.androidLogWarning(testInfo.getDevice(), String.format("Test %s: %s, retrying [count=%s]", inconclusive ? "Inconclusive" : "Failed", testName, retryCount));
        }
        if (success) {
            this.androidLogInfo(testInfo.getDevice(), "Test Ended [Success]: " + testName);
        } else {
            this.androidLogError(testInfo.getDevice(), "Test Ended [Failed]: " + testName);
            listener.testFailed(testDescription, String.format("Test case %s failed, please route bugs to android-bluetooth@google.com\nRefer to host_log files to find the test logs", testName));
        }
        listener.testEnded(testDescription, Collections.emptyMap());
        return success;
    }

    private ProcessBuilder ptsBot(TestInformation testInfo, String ... args) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.ptsBotPath.getPath());
        command.add("--config");
        command.add(this.testsConfigFile.getPath());
        command.add("--hci");
        command.add(String.valueOf(this.getHciPort()));
        command.add("--inactivity-timeout");
        command.add(String.valueOf(90));
        if (this.ptsSetupPath != null) {
            command.add("--pts-setup");
            command.add(this.ptsSetupPath.getPath());
        }
        command.addAll(Arrays.asList(args));
        ProcessBuilder builder = new ProcessBuilder(command);
        if (this.binTempDir != null) {
            builder.environment().put("XDG_CACHE_HOME", this.binTempDir.getPath());
        }
        if (this.pythonHome != null) {
            builder.environment().put("PYTHONHOME", this.pythonHome.getPath());
        }
        String pythonPath = this.mmi2grpc.getPath();
        File venvDir = testInfo.getBuildInfo().getFile("VIRTUAL_ENV");
        if (venvDir != null) {
            String packagePath = PythonVirtualenvHelper.getPackageInstallLocation(this.mRunUtil, venvDir.getAbsolutePath());
            pythonPath = pythonPath + ":" + packagePath;
        }
        builder.environment().put("PYTHONPATH", pythonPath);
        return builder;
    }

    private int adbForwardPort(ITestDevice testDevice, int hostPort, int dutPort) throws DeviceNotAvailableException {
        return Integer.parseInt(testDevice.executeAdbCommand(new String[]{"forward", String.format("tcp:%s", hostPort), String.format("tcp:%s", dutPort)}).trim());
    }

    private int adbForwardVsockPort(ITestDevice testDevice, int hostPort, int dutCid, int dutPort) throws DeviceNotAvailableException {
        return Integer.parseInt(testDevice.executeAdbCommand(new String[]{"forward", String.format("tcp:%s", hostPort), String.format("vsock:%s:%s", dutCid, dutPort)}).trim());
    }

    private void adbForwardRemovePort(ITestDevice testDevice, int hostPort) throws DeviceNotAvailableException {
        testDevice.executeAdbCommand(new String[]{"forward", "--remove", String.format("tcp:%s", hostPort)});
    }

    private void androidLog(ITestDevice testDevice, String priority, String content) {
        try {
            String timeStamp = new SimpleDateFormat("HH:mm:ss.SSS").format(new Date());
            String command = String.format("log -t %s -p %s '%s (%s host time)'", TAG, priority, content, timeStamp);
            CommandResult result = testDevice.executeShellV2Command(command);
            if (result.getStatus() != CommandStatus.SUCCESS) {
                LogUtil.CLog.w((String)String.format("Command '%s' exited with status %s (code %s)", command, result.getStatus(), result.getExitCode()));
            }
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.w((String)("Failed to send android log, device not available: " + (Object)((Object)e)));
        }
    }

    private void androidLogInfo(ITestDevice testDevice, String content) {
        this.androidLog(testDevice, "i", content);
    }

    private void androidLogWarning(ITestDevice testDevice, String content) {
        this.androidLog(testDevice, "w", content);
    }

    private void androidLogError(ITestDevice testDevice, String content) {
        this.androidLog(testDevice, "e", content);
    }
}

