/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.mobly;

import com.android.tradefed.testtype.mobly.IMoblyYamlResultHandler;
import com.android.tradefed.testtype.mobly.MoblyYamlResultHandlerFactory;
import java.util.Map;

public class MoblyYamlResultRecordHandler
implements IMoblyYamlResultHandler {
    private static final String BEGIN_TIME = "Begin Time";
    private static final String END_TIME = "End Time";
    private static final String RESULT = "Result";
    private static final String STACKTRACE = "Stacktrace";
    private static final String TEST_CLASS = "Test Class";
    private static final String TEST_NAME = "Test Name";

    @Override
    public Record handle(Map<String, Object> docMap) {
        Record.Builder builder = Record.builder();
        builder.setTestClass(String.valueOf(docMap.get(TEST_CLASS)));
        builder.setTestName(String.valueOf(docMap.get(TEST_NAME)));
        builder.setResult(RecordResult.valueOf((String)docMap.get(RESULT)));
        builder.setBeginTime(String.valueOf(docMap.get(BEGIN_TIME)));
        builder.setEndTime(String.valueOf(docMap.get(END_TIME)));
        builder.setStackTrace(String.valueOf(docMap.get(STACKTRACE)));
        return builder.build();
    }

    public static class Record
    implements IMoblyYamlResultHandler.ITestResult {
        private final String mTestClass;
        private final String mTestName;
        private final RecordResult mResult;
        private final long mBeginTime;
        private final long mEndTime;
        private final String mStacktrace;

        private Record(String testClass, String testName, RecordResult result, String beginTime, String endTime, String stacktrace) {
            this.mTestClass = testClass;
            this.mTestName = testName;
            this.mResult = result;
            this.mBeginTime = "null".equals(beginTime) ? 0L : Long.parseLong(beginTime);
            this.mEndTime = "null".equals(endTime) ? 0L : Long.parseLong(endTime);
            this.mStacktrace = stacktrace;
        }

        @Override
        public MoblyYamlResultHandlerFactory.Type getType() {
            return MoblyYamlResultHandlerFactory.Type.RECORD;
        }

        public long getBeginTime() {
            return this.mBeginTime;
        }

        public String getTestClass() {
            return this.mTestClass;
        }

        public String getTestName() {
            return this.mTestName;
        }

        public String getStackTrace() {
            return this.mStacktrace;
        }

        public long getEndTime() {
            return this.mEndTime;
        }

        public RecordResult getResult() {
            return this.mResult;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String mTestClass;
            private String mTestName;
            private RecordResult mResult;
            private String mBeginTime;
            private String mEndTime;
            private String mStacktrace;

            public Builder setTestClass(String testClass) {
                this.mTestClass = testClass;
                return this;
            }

            public Builder setTestName(String testName) {
                this.mTestName = testName;
                return this;
            }

            public Builder setResult(RecordResult result) {
                this.mResult = result;
                return this;
            }

            public Builder setBeginTime(String beginTime) {
                this.mBeginTime = beginTime;
                return this;
            }

            public Builder setEndTime(String endTime) {
                this.mEndTime = endTime;
                return this;
            }

            public Builder setStackTrace(String stacktrace) {
                this.mStacktrace = stacktrace;
                return this;
            }

            public Record build() {
                return new Record(this.mTestClass, this.mTestName, this.mResult, this.mBeginTime, this.mEndTime, this.mStacktrace);
            }
        }
    }

    public static enum RecordResult {
        SKIP,
        PASS,
        FAIL,
        ERROR;

    }
}

