/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.mobly;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.testtype.mobly.IMoblyYamlResultHandler;
import com.android.tradefed.testtype.mobly.MoblyYamlResultControllerInfoHandler;
import com.android.tradefed.testtype.mobly.MoblyYamlResultHandlerFactory;
import com.android.tradefed.testtype.mobly.MoblyYamlResultRecordHandler;
import com.android.tradefed.testtype.mobly.MoblyYamlResultUserDataHandler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class MoblyYamlResultParser {
    private static final String TYPE = "Type";
    private ImmutableList.Builder<ITestInvocationListener> mListenersBuilder = new ImmutableList.Builder();
    private ImmutableList.Builder<IMoblyYamlResultHandler.ITestResult> mResultCacheBuilder = new ImmutableList.Builder();
    private long mRunStartTime;
    private long mRunEndTime;
    private boolean mEnded;
    private boolean mRunFailed;
    private StringBuilder mYamlString = new StringBuilder();

    public MoblyYamlResultParser(ITestInvocationListener listener) {
        this.mListenersBuilder.add((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parse(InputStream inputStream) throws MoblyYamlResultHandlerFactory.InvalidResultTypeException, IllegalAccessException, InstantiationException, IOException {
        if (this.mEnded) {
            return this.mEnded;
        }
        int available = inputStream.available();
        if (available == 0) {
            return false;
        }
        byte[] bytes = new byte[available];
        inputStream.read(bytes);
        this.mYamlString.append(new String(bytes, 0, available, StandardCharsets.UTF_8));
        int yamlEnd = this.mYamlString.lastIndexOf("\n...");
        if (yamlEnd == -1) {
            return false;
        }
        ArrayList<IMoblyYamlResultHandler.ITestResult> resultCache = new ArrayList<IMoblyYamlResultHandler.ITestResult>();
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        try {
            for (Object doc : yaml.loadAll(this.mYamlString.substring(0, yamlEnd))) {
                Map docMap = (Map)doc;
                resultCache.add(this.parseDocumentMap(docMap));
            }
        }
        finally {
            this.mYamlString.delete(0, yamlEnd + 4);
            this.reportToListeners((List<ITestInvocationListener>)((Object)this.mListenersBuilder.build()), resultCache);
        }
        return this.mEnded;
    }

    public boolean getRunFailed() {
        return this.mRunFailed;
    }

    @VisibleForTesting
    protected IMoblyYamlResultHandler.ITestResult parseDocumentMap(Map<String, Object> docMap) throws MoblyYamlResultHandlerFactory.InvalidResultTypeException, IllegalAccessException, InstantiationException {
        LogUtil.CLog.d((String)"Parsed object: %s", (Object[])new Object[]{docMap.toString()});
        String docType = String.valueOf(docMap.get(TYPE));
        LogUtil.CLog.v((String)"Parsing result type: %s", (Object[])new Object[]{docType});
        IMoblyYamlResultHandler resultHandler = new MoblyYamlResultHandlerFactory().getHandler(docType);
        return resultHandler.handle(docMap);
    }

    @VisibleForTesting
    protected void reportToListeners(List<ITestInvocationListener> listeners, List<IMoblyYamlResultHandler.ITestResult> resultCache) {
        for (IMoblyYamlResultHandler.ITestResult result : resultCache) {
            switch (result.getType()) {
                case RECORD: {
                    MoblyYamlResultRecordHandler.Record record = (MoblyYamlResultRecordHandler.Record)result;
                    TestDescription testDescription = new TestDescription(record.getTestClass(), record.getTestName());
                    FailureDescription failureDescription = FailureDescription.create((String)record.getStackTrace(), (TestRecordProto.FailureStatus)TestRecordProto.FailureStatus.TEST_FAILURE);
                    if (MoblyYamlResultRecordHandler.RecordResult.ERROR.equals((Object)record.getResult()) && !testDescription.getTestName().startsWith("test_")) {
                        for (ITestInvocationListener listener : listeners) {
                            listener.testRunFailed(failureDescription);
                        }
                        this.mRunFailed = true;
                        break;
                    }
                    this.mRunStartTime = this.mRunStartTime == 0L ? record.getBeginTime() : Math.min(this.mRunStartTime, record.getBeginTime());
                    this.mRunEndTime = Math.max(this.mRunEndTime, record.getEndTime());
                    for (ITestInvocationListener listener : listeners) {
                        listener.testStarted(testDescription, record.getBeginTime());
                        if (MoblyYamlResultRecordHandler.RecordResult.SKIP.equals((Object)record.getResult())) {
                            listener.testIgnored(testDescription);
                        } else if (!MoblyYamlResultRecordHandler.RecordResult.PASS.equals((Object)record.getResult())) {
                            listener.testFailed(testDescription, failureDescription);
                        }
                        listener.testEnded(testDescription, record.getEndTime(), new HashMap());
                    }
                    break;
                }
                case USER_DATA: {
                    long timestamp = ((MoblyYamlResultUserDataHandler.UserData)result).getTimeStamp();
                    this.mRunStartTime = this.mRunStartTime == 0L ? timestamp : Math.min(this.mRunStartTime, timestamp);
                    break;
                }
                case CONTROLLER_INFO: {
                    this.mRunEndTime = Math.max(this.mRunEndTime, ((MoblyYamlResultControllerInfoHandler.ControllerInfo)result).getTimeStamp());
                    break;
                }
                case SUMMARY: {
                    this.mEnded = true;
                    break;
                }
            }
        }
    }
}

