/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.junit4;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.testtype.junit4.CarryInterruptedException;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

public class RunNotifierWrapper
extends RunNotifier {
    private DeviceNotAvailableException mDnae;
    private RunNotifier notifier;
    private TestInformation mTestInfo;

    public RunNotifierWrapper(RunNotifier notifier) {
        this.notifier = notifier;
    }

    public void setTestInfo(TestInformation testInfo) {
        this.mTestInfo = testInfo;
    }

    public void addFirstListener(RunListener listener) {
        this.notifier.addFirstListener(listener);
    }

    public void fireTestRunStarted(Description description) {
        this.notifier.fireTestRunStarted(description);
    }

    public void fireTestRunFinished(Result result) {
        this.notifier.fireTestRunFinished(result);
    }

    public void fireTestSuiteStarted(Description description) {
        this.notifier.fireTestSuiteStarted(description);
    }

    public void fireTestSuiteFinished(Description description) {
        this.notifier.fireTestSuiteFinished(description);
    }

    public void pleaseStop() {
        this.notifier.pleaseStop();
    }

    public void addListener(RunListener listener) {
        this.notifier.addListener(listener);
    }

    public void removeListener(RunListener listener) {
        this.notifier.removeListener(listener);
    }

    public void fireTestFailure(Failure failure) {
        this.notifier.fireTestFailure(failure);
        if (failure.getException() instanceof DeviceNotAvailableException) {
            this.mDnae = (DeviceNotAvailableException)failure.getException();
        } else if (failure.getException() instanceof InterruptedException) {
            throw new CarryInterruptedException((InterruptedException)failure.getException());
        }
    }

    public void fireTestAssumptionFailed(Failure failure) {
        this.notifier.fireTestAssumptionFailed(failure);
    }

    public void fireTestFinished(Description description) {
        this.notifier.fireTestFinished(description);
    }

    public void fireTestStarted(Description description) {
        this.notifier.fireTestStarted(description);
        if (this.mTestInfo != null && this.mTestInfo.isTestTimedOut()) {
            this.notifier.fireTestIgnored(description);
            throw new CarryInterruptedException(new InterruptedException());
        }
    }

    public void fireTestIgnored(Description description) {
        this.notifier.fireTestIgnored(description);
    }

    public DeviceNotAvailableException getDeviceNotAvailableException() {
        return this.mDnae;
    }
}

