/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.binary;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionCopier;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.observatory.IDiscoverDependencies;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IAbiReceiver;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.IRuntimeHintProvider;
import com.android.tradefed.testtype.IShardableTest;
import com.android.tradefed.testtype.ITestCollector;
import com.android.tradefed.testtype.ITestFilterReceiver;
import com.android.tradefed.util.StreamUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ExecutableBaseTest
implements IRemoteTest,
IRuntimeHintProvider,
ITestCollector,
IShardableTest,
IAbiReceiver,
ITestFilterReceiver,
IDiscoverDependencies {
    public static final String NO_BINARY_ERROR = "Binary %s does not exist.";
    @Option(name="per-binary-timeout", isTimeVal=true, description="Timeout applied to each binary for their execution.")
    private long mTimeoutPerBinaryMs = 300000L;
    @Option(name="binary", description="Path to the binary to be run. Can be repeated.")
    private List<String> mBinaryPaths = new ArrayList<String>();
    @Option(name="test-command-line", description="The test commands of each test names.", requiredForRerun=true)
    private Map<String, String> mTestCommands = new LinkedHashMap<String, String>();
    @Option(name="collect-tests-only", description="Only dry-run through the tests, do not actually run them.")
    private boolean mCollectTestsOnly = false;
    @Option(name="runtime-hint", description="The hint about the test's runtime.", isTimeVal=true)
    private long mRuntimeHintMs = 60000L;
    @Option(name="shard-split", description="Shard by test command or shard count")
    private ShardSplit mShardSplit = ShardSplit.PER_TEST_CMD;
    private IAbi mAbi;
    private TestInformation mTestInfo;
    private Set<String> mIncludeFilters = new LinkedHashSet<String>();
    private Set<String> mExcludeFilters = new LinkedHashSet<String>();

    @VisibleForTesting
    Map<String, String> getTestCommands() {
        return this.mTestCommands;
    }

    protected long getTimeoutPerBinaryMs() {
        return this.mTimeoutPerBinaryMs;
    }

    public void addIncludeFilter(String filter) {
        this.mIncludeFilters.add(filter);
    }

    public void addExcludeFilter(String filter) {
        this.mExcludeFilters.add(filter);
    }

    public void addAllIncludeFilters(Set<String> filters) {
        this.mIncludeFilters.addAll(filters);
    }

    public void addAllExcludeFilters(Set<String> filters) {
        this.mExcludeFilters.addAll(filters);
    }

    public void clearIncludeFilters() {
        this.mIncludeFilters.clear();
    }

    public void clearExcludeFilters() {
        this.mExcludeFilters.clear();
    }

    public Set<String> getIncludeFilters() {
        return this.mIncludeFilters;
    }

    public Set<String> getExcludeFilters() {
        return this.mExcludeFilters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        this.mTestInfo = testInfo;
        Map<String, String> testCommands = this.getAllTestCommands();
        IInvocationContext context = testInfo.getContext();
        String moduleId = context != null ? (String)context.getAttributes().getUniqueMap().get("module-id") : this.getClass().getName();
        TestDescription[] nonSkippedTestDescriptions = (TestDescription[])testCommands.keySet().stream().map(testName -> new TestDescription(testName, testName)).filter(description -> !this.shouldSkipCurrentTest((TestDescription)description)).toArray(TestDescription[]::new);
        if (nonSkippedTestDescriptions.length == 0) {
            return;
        }
        String testRunName = nonSkippedTestDescriptions.length == 1 ? nonSkippedTestDescriptions[0].getTestName() : moduleId;
        long startTimeMs = System.currentTimeMillis();
        try {
            listener.testRunStarted(testRunName, nonSkippedTestDescriptions.length);
            for (TestDescription description2 : nonSkippedTestDescriptions) {
                String testName2 = description2.getTestName();
                String cmd = testCommands.get(testName2);
                String path = this.findBinary(cmd);
                if (path == null) {
                    listener.testFailed(description2, FailureDescription.create((String)String.format(NO_BINARY_ERROR, cmd), (TestRecordProto.FailureStatus)TestRecordProto.FailureStatus.TEST_FAILURE).setErrorIdentifier((ErrorIdentifier)InfraErrorIdentifier.CONFIGURED_ARTIFACT_NOT_FOUND));
                    continue;
                }
                try {
                    listener.testStarted(description2);
                    if (this.mCollectTestsOnly) continue;
                    this.runBinary(path, listener, description2);
                }
                catch (IOException e) {
                    listener.testFailed(description2, FailureDescription.create((String)StreamUtil.getStackTrace((Throwable)e)));
                }
                finally {
                    listener.testEnded(description2, new HashMap());
                }
            }
        }
        finally {
            listener.testRunEnded(System.currentTimeMillis() - startTimeMs, new HashMap());
        }
    }

    private boolean shouldSkipCurrentTest(TestDescription description) {
        String testName = description.getTestName();
        if (this.mExcludeFilters.contains(testName) || this.mExcludeFilters.contains(description.toString())) {
            return true;
        }
        if (!this.mIncludeFilters.isEmpty()) {
            return !this.mIncludeFilters.contains(testName) && !this.mIncludeFilters.contains(description.toString());
        }
        return false;
    }

    public abstract String findBinary(String var1) throws DeviceNotAvailableException;

    public abstract void runBinary(String var1, ITestInvocationListener var2, TestDescription var3) throws DeviceNotAvailableException, IOException;

    public final void setCollectTestsOnly(boolean shouldCollectTest) {
        this.mCollectTestsOnly = shouldCollectTest;
    }

    public final long getRuntimeHint() {
        return this.mRuntimeHintMs;
    }

    public final void setAbi(IAbi abi) {
        this.mAbi = abi;
    }

    public IAbi getAbi() {
        return this.mAbi;
    }

    TestInformation getTestInfo() {
        return this.mTestInfo;
    }

    public final Collection<IRemoteTest> split(int shardHint) {
        if (shardHint <= 1) {
            return null;
        }
        int testCount = this.mBinaryPaths.size() + this.mTestCommands.size();
        if (testCount <= 2) {
            return null;
        }
        if (this.mShardSplit == ShardSplit.PER_TEST_CMD) {
            return this.splitByTestCommand();
        }
        if (this.mShardSplit == ShardSplit.PER_SHARD) {
            return this.splitByShardCount(testCount, shardHint);
        }
        return null;
    }

    private Collection<IRemoteTest> splitByTestCommand() {
        ArrayList<IRemoteTest> tests = new ArrayList<IRemoteTest>();
        for (String path : this.mBinaryPaths) {
            tests.add(this.getTestShard(ImmutableList.of(path), null));
        }
        LinkedHashMap<String, String> testCommands = new LinkedHashMap<String, String>(this.mTestCommands);
        for (String testName : testCommands.keySet()) {
            String cmd = (String)testCommands.get(testName);
            tests.add(this.getTestShard(null, ImmutableMap.of(testName, cmd)));
        }
        return tests;
    }

    private Collection<IRemoteTest> splitByShardCount(int testCount, int shardCount) {
        int maxTestCntPerShard = (int)Math.ceil((double)testCount / (double)shardCount);
        int numFullSizeShards = testCount % maxTestCntPerShard;
        ArrayList<Map.Entry<String, String>> testCommands = new ArrayList<Map.Entry<String, String>>(this.mTestCommands.entrySet());
        int runningTestCountInShard = 0;
        ArrayList<IRemoteTest> tests = new ArrayList<IRemoteTest>();
        ArrayList<String> binaryPathsInShard = new ArrayList<String>();
        HashMap<String, String> testCommandsInShard = new HashMap<String, String>();
        for (int runningTestCount = 0; runningTestCount < testCount; ++runningTestCount) {
            if (runningTestCount < this.mBinaryPaths.size()) {
                binaryPathsInShard.add(this.mBinaryPaths.get(runningTestCount));
            } else {
                Map.Entry entry = (Map.Entry)testCommands.get(runningTestCount - this.mBinaryPaths.size());
                testCommandsInShard.put((String)entry.getKey(), (String)entry.getValue());
            }
            if ((tests.size() >= numFullSizeShards || ++runningTestCountInShard != maxTestCntPerShard) && (tests.size() < numFullSizeShards || runningTestCountInShard < maxTestCntPerShard - 1)) continue;
            tests.add(this.getTestShard(binaryPathsInShard, testCommandsInShard));
            binaryPathsInShard.clear();
            testCommandsInShard.clear();
            runningTestCountInShard = 0;
        }
        return tests;
    }

    private IRemoteTest getTestShard(List<String> binaryPaths, Map<String, String> testCmds) {
        ExecutableBaseTest shard = null;
        try {
            shard = (ExecutableBaseTest)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            OptionCopier.copyOptionsNoThrow((Object)this, (Object)shard);
            shard.mBinaryPaths.clear();
            shard.mTestCommands.clear();
            if (binaryPaths != null) {
                for (String string : binaryPaths) {
                    shard.mBinaryPaths.add(string);
                }
            }
            if (testCmds != null) {
                for (Map.Entry entry : testCmds.entrySet()) {
                    shard.mTestCommands.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            shard.mExcludeFilters.addAll(this.mExcludeFilters);
            shard.mIncludeFilters.addAll(this.mIncludeFilters);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(String.format("%s (%s) when attempting to create shard object", e.getClass().getSimpleName(), e.getMessage()));
        }
        return shard;
    }

    @VisibleForTesting
    Map<String, String> getAllTestCommands() {
        LinkedHashMap<String, String> testCommands = new LinkedHashMap<String, String>(this.mTestCommands);
        for (String binary : this.mBinaryPaths) {
            testCommands.put(new File(binary).getName(), binary);
        }
        return testCommands;
    }

    public Set<String> reportDependencies() {
        HashSet<String> deps = new HashSet<String>();
        deps.addAll(this.mBinaryPaths);
        return deps;
    }

    static enum ShardSplit {
        PER_TEST_CMD,
        PER_SHARD;

    }
}

