/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IFileEntry;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.NativeStressTestParser;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

@OptionClass(alias="native-stress")
public class NativeStressTest
implements IDeviceTest,
IRemoteTest {
    static final String DEFAULT_TEST_PATH = "data/nativestresstest";
    static final String AVG_ITERATION_TIME_KEY = "avg-iteration-time";
    static final String ITERATION_KEY = "iterations";
    private ITestDevice mDevice = null;
    @Option(name="native-stress-device-path", description="The path on the device where native stress tests are located.")
    private String mDeviceTestPath = "data/nativestresstest";
    @Option(name="stress-module-name", description="The name of the native test module to run. If not specified all tests in --native-stress-device-path will be run.")
    private String mTestModule = null;
    @Option(name="iterations", description="The number of stress test iterations per run.", importance=Option.Importance.IF_UNSET)
    private Integer mNumIterations = null;
    @Option(name="runs", description="The number of stress test runs to perform.")
    private int mNumRuns = 1;
    @Option(name="max-iteration-time", description="The maximum time to allow for one stress test iteration in ms.")
    private int mMaxIterationTime = 300000;

    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    public ITestDevice getDevice() {
        return this.mDevice;
    }

    public void setModuleName(String moduleName) {
        this.mTestModule = moduleName;
    }

    public String getModuleName() {
        return this.mTestModule;
    }

    void setNumIterations(int iterations) {
        this.mNumIterations = iterations;
    }

    void setNumRuns(int runs) {
        this.mNumRuns = runs;
    }

    private String getTestPath() {
        StringBuilder testPath = new StringBuilder(this.mDeviceTestPath);
        if (this.mTestModule != null) {
            testPath.append("/");
            testPath.append(this.mTestModule);
        }
        return testPath.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRunAllTestsInSubdirectory(IFileEntry rootEntry, ITestDevice testDevice, ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (rootEntry.isDirectory()) {
            for (IFileEntry childEntry : rootEntry.getChildren(true)) {
                this.doRunAllTestsInSubdirectory(childEntry, testDevice, listener);
            }
        } else {
            NativeStressTestParser resultParser = this.createResultParser(rootEntry.getName());
            String fullPath = rootEntry.getFullEscapedPath();
            LogUtil.CLog.i((String)"Running native stress test %s on %s", (Object[])new Object[]{fullPath, this.mDevice.getSerialNumber()});
            testDevice.executeShellCommand(String.format("chmod 755 %s", fullPath));
            int startIteration = 0;
            int endIteration = this.mNumIterations - 1;
            long startTime = System.currentTimeMillis();
            listener.testRunStarted(resultParser.getRunName(), 0);
            try {
                for (int i = 0; i < this.mNumRuns; ++i) {
                    LogUtil.CLog.i((String)"Running %s for %d iterations", (Object[])new Object[]{rootEntry.getName(), this.mNumIterations});
                    testDevice.executeShellCommand(String.format("%s -s %d -e %d", fullPath, startIteration, endIteration), (IShellOutputReceiver)resultParser, (long)this.mMaxIterationTime, TimeUnit.MILLISECONDS, 0);
                    startIteration += this.mNumIterations.intValue();
                    endIteration += this.mNumIterations.intValue();
                }
            }
            finally {
                this.reportTestCompleted(startTime, listener, resultParser);
            }
        }
    }

    private void reportTestCompleted(long startTime, ITestInvocationListener listener, NativeStressTestParser parser) {
        long elapsedTime = System.currentTimeMillis() - startTime;
        int iterationsComplete = parser.getIterationsCompleted();
        float avgIterationTime = iterationsComplete > 0 ? (float)(elapsedTime / (long)iterationsComplete) : 0.0f;
        HashMap<String, String> metricMap = new HashMap<String, String>(2);
        LogUtil.CLog.i((String)"Stress test %s is finished. Num iterations %d, avg time %f ms", (Object[])new Object[]{parser.getRunName(), iterationsComplete, Float.valueOf(avgIterationTime)});
        metricMap.put(ITERATION_KEY, Integer.toString(iterationsComplete));
        metricMap.put(AVG_ITERATION_TIME_KEY, Float.toString(avgIterationTime));
        listener.testRunEnded(elapsedTime, TfMetricProtoUtil.upgradeConvert(metricMap));
    }

    NativeStressTestParser createResultParser(String runName) {
        return new NativeStressTestParser(runName);
    }

    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (this.mDevice == null) {
            throw new IllegalArgumentException("Device has not been set");
        }
        if (this.mNumIterations == null || this.mNumIterations <= 0) {
            throw new IllegalArgumentException("number of iterations has not been set");
        }
        String testPath = this.getTestPath();
        IFileEntry nativeTestDirectory = this.mDevice.getFileEntry(testPath);
        if (nativeTestDirectory == null) {
            LogUtil.CLog.w((String)"Could not find native stress test directory %s in %s!", (Object[])new Object[]{testPath, this.mDevice.getSerialNumber()});
            return;
        }
        this.doRunAllTestsInSubdirectory(nativeTestDirectory, this.mDevice, listener);
    }
}

