/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.DynamicRemoteFileResolver;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.config.OptionCopier;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.metric.IMetricCollectorReceiver;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.error.IHarnessException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.invoker.logger.CurrentInvocation;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.ResultForwarder;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IAbiReceiver;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IInvocationContextReceiver;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.IRuntimeHintProvider;
import com.android.tradefed.testtype.ISetOptionReceiver;
import com.android.tradefed.testtype.IShardableTest;
import com.android.tradefed.testtype.ITestAnnotationFilterReceiver;
import com.android.tradefed.testtype.ITestCollector;
import com.android.tradefed.testtype.ITestFilterReceiver;
import com.android.tradefed.testtype.ITestInformationReceiver;
import com.android.tradefed.testtype.JUnitRunUtil;
import com.android.tradefed.testtype.TestTimeoutEnforcer;
import com.android.tradefed.testtype.host.PrettyTestEventLogger;
import com.android.tradefed.testtype.junit4.CarryDnaeError;
import com.android.tradefed.testtype.junit4.ExceptionThrowingRunnerWrapper;
import com.android.tradefed.testtype.junit4.JUnit4ResultForwarder;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.JUnit4TestFilter;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.TestFilterHelper;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.internal.runners.ErrorReportingRunner;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Suite;

@OptionClass(alias="host")
public class HostTest
implements IDeviceTest,
ITestFilterReceiver,
ITestAnnotationFilterReceiver,
IRemoteTest,
ITestCollector,
IBuildReceiver,
IAbiReceiver,
IShardableTest,
IRuntimeHintProvider,
IConfigurationReceiver {
    @Option(name="class", description="The JUnit test classes to run, in the format <package>.<class>. eg. \"com.android.foo.Bar\". This field can be repeated.", importance=Option.Importance.IF_UNSET)
    private Set<String> mClasses = new LinkedHashSet<String>();
    @Option(name="method", description="The name of the method in the JUnit TestCase to run. eg. \"testFooBar\"", importance=Option.Importance.IF_UNSET)
    private String mMethodName;
    @Option(name="jar", description="The jars containing the JUnit test class to run.", importance=Option.Importance.IF_UNSET)
    private Set<String> mJars = new HashSet<String>();
    public static final String SET_OPTION_NAME = "set-option";
    public static final String SET_OPTION_DESC = "Options to be passed down to the class under test, key and value should be separated by colon \":\"; for example, if class under test supports \"--iteration 1\" from a command line, it should be passed in as \"--set-option iteration:1\" or \"--set-option iteration:key=value\" for passing options to map. Values that contain \":\" or \"=\" can be escaped with a backslash. A particular class can be targeted by specifying it. \" --set-option <fully qualified class>:<option name>:<option value>\"";
    @Option(name="set-option", description="Options to be passed down to the class under test, key and value should be separated by colon \":\"; for example, if class under test supports \"--iteration 1\" from a command line, it should be passed in as \"--set-option iteration:1\" or \"--set-option iteration:key=value\" for passing options to map. Values that contain \":\" or \"=\" can be escaped with a backslash. A particular class can be targeted by specifying it. \" --set-option <fully qualified class>:<option name>:<option value>\"")
    private List<String> mKeyValueOptions = new ArrayList<String>();
    @Option(name="include-annotation", description="The set of annotations a test must have to be run.")
    private Set<String> mIncludeAnnotations = new HashSet<String>();
    @Option(name="exclude-annotation", description="The set of annotations to exclude tests from running. A test must have none of the annotations in this list to run.")
    private Set<String> mExcludeAnnotations = new HashSet<String>();
    @Option(name="collect-tests-only", description="Only invoke the instrumentation to collect list of applicable test cases. All test run callbacks will be triggered, but test execution will not be actually carried out.")
    private boolean mCollectTestsOnly = false;
    @Option(name="runtime-hint", isTimeVal=true, description="The hint about the test's runtime.")
    private long mRuntimeHint = 60000L;
    @Option(name="shard-unit", description="Shard by class or method")
    private ShardUnit mShardUnit = ShardUnit.CLASS;
    @Option(name="enable-pretty-logs", description="whether or not to enable a logging for each test start and end on both host and device side.")
    private boolean mEnableHostDeviceLogs = true;
    @Option(name="test-case-timeout", description="The timeout that will be applied to each test case of the run.")
    private Duration mTestCaseTimeout = Duration.ofSeconds(0L);
    private IConfiguration mConfig;
    private ITestDevice mDevice;
    private IBuildInfo mBuildInfo;
    private IAbi mAbi;
    private TestInformation mTestInfo;
    private TestFilterHelper mFilterHelper;
    private boolean mSkipTestClassCheck = false;
    private List<Object> mTestMethods;
    private List<Class<?>> mLoadedClasses = new ArrayList();
    private List<URLClassLoader> mOpenClassLoaders = new ArrayList<URLClassLoader>();
    private int mNumTestCases = -1;
    private List<File> mJUnit4JarFiles = new ArrayList<File>();
    private static final String EXCLUDE_NO_TEST_FAILURE = "org.junit.runner.manipulation.Filter";
    private static final String TEST_FULL_NAME_FORMAT = "%s#%s";
    private List<File> mDownloadedFiles = new ArrayList<File>();

    public HostTest() {
        this.mFilterHelper = new TestFilterHelper(new ArrayList(), new ArrayList(), this.mIncludeAnnotations, this.mExcludeAnnotations);
    }

    public void setTestInformation(TestInformation testInfo) {
        this.mTestInfo = testInfo;
    }

    public void setConfiguration(IConfiguration configuration) {
        this.mConfig = configuration;
    }

    public ITestDevice getDevice() {
        return this.mDevice;
    }

    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    public long getRuntimeHint() {
        return this.mRuntimeHint;
    }

    public void setAbi(IAbi abi) {
        this.mAbi = abi;
    }

    public IAbi getAbi() {
        return this.mAbi;
    }

    public void setBuild(IBuildInfo buildInfo) {
        this.mBuildInfo = buildInfo;
    }

    protected IBuildInfo getBuild() {
        return this.mBuildInfo;
    }

    private boolean shardUnitIsMethod() {
        return ShardUnit.METHOD.equals((Object)this.mShardUnit);
    }

    public void addIncludeFilter(String filter) {
        this.mNumTestCases = -1;
        this.mFilterHelper.addIncludeFilter(filter);
    }

    public void addAllIncludeFilters(Set<String> filters) {
        this.mNumTestCases = -1;
        this.mFilterHelper.addAllIncludeFilters(filters);
    }

    public void clearIncludeFilters() {
        this.mNumTestCases = -1;
        this.mFilterHelper.clearIncludeFilters();
    }

    public void addExcludeFilter(String filter) {
        this.mNumTestCases = -1;
        this.mFilterHelper.addExcludeFilter(filter);
    }

    public Set<String> getIncludeFilters() {
        return this.mFilterHelper.getIncludeFilters();
    }

    public Set<String> getExcludeFilters() {
        return this.mFilterHelper.getExcludeFilters();
    }

    public void addAllExcludeFilters(Set<String> filters) {
        this.mNumTestCases = -1;
        this.mFilterHelper.addAllExcludeFilters(filters);
    }

    public void clearExcludeFilters() {
        this.mNumTestCases = -1;
        this.mFilterHelper.clearExcludeFilters();
    }

    public int countTestCases() {
        if (this.mTestMethods != null) {
            return this.mTestMethods.size();
        }
        if (this.mNumTestCases >= 0) {
            return this.mNumTestCases;
        }
        this.mFilterHelper.addAllIncludeAnnotation(this.mIncludeAnnotations);
        this.mFilterHelper.addAllExcludeAnnotation(this.mExcludeAnnotations);
        int count = 0;
        for (Class<?> classObj : this.getClasses()) {
            if (IRemoteTest.class.isAssignableFrom(classObj) || junit.framework.Test.class.isAssignableFrom(classObj)) {
                TestSuite suite = this.collectTests(this.collectClasses(classObj));
                int suiteCount = suite.countTestCases();
                if (suiteCount == 0 && IRemoteTest.class.isAssignableFrom(classObj) && !junit.framework.Test.class.isAssignableFrom(classObj)) {
                    ++count;
                    continue;
                }
                count += suiteCount;
                continue;
            }
            if (this.hasJUnit4Annotation(classObj)) {
                Request req = Request.aClass(classObj);
                Runner checkRunner = (req = req.filterWith((Filter)new JUnit4TestFilter(this.mFilterHelper, this.mJUnit4JarFiles))).getRunner();
                if (checkRunner instanceof ErrorReportingRunner) {
                    if (EXCLUDE_NO_TEST_FAILURE.equals(checkRunner.getDescription().getClassName())) continue;
                    count += checkRunner.testCount();
                    continue;
                }
                count += checkRunner.testCount();
                continue;
            }
            ++count;
        }
        this.mNumTestCases = count;
        return this.mNumTestCases;
    }

    protected void setClassName(String className) {
        this.mClasses.clear();
        this.mClasses.add(className);
    }

    @VisibleForTesting
    public Set<String> getClassNames() {
        return this.mClasses;
    }

    void setMethodName(String methodName) {
        this.mMethodName = methodName;
    }

    public void addIncludeAnnotation(String annotation) {
        this.mIncludeAnnotations.add(annotation);
        this.mFilterHelper.addIncludeAnnotation(annotation);
    }

    public void addAllIncludeAnnotation(Set<String> annotations) {
        this.mIncludeAnnotations.addAll(annotations);
        this.mFilterHelper.addAllIncludeAnnotation(annotations);
    }

    public void addExcludeAnnotation(String notAnnotation) {
        this.mExcludeAnnotations.add(notAnnotation);
        this.mFilterHelper.addExcludeAnnotation(notAnnotation);
    }

    public void addAllExcludeAnnotation(Set<String> notAnnotations) {
        this.mExcludeAnnotations.addAll(notAnnotations);
        this.mFilterHelper.addAllExcludeAnnotation(notAnnotations);
    }

    public Set<String> getIncludeAnnotations() {
        return this.mIncludeAnnotations;
    }

    public Set<String> getExcludeAnnotations() {
        return this.mExcludeAnnotations;
    }

    public void clearIncludeAnnotations() {
        this.mIncludeAnnotations.clear();
        this.mFilterHelper.clearIncludeAnnotations();
    }

    public void clearExcludeAnnotations() {
        this.mExcludeAnnotations.clear();
        this.mFilterHelper.clearExcludeAnnotations();
    }

    private void setTestObjectInformation(Object testObj) {
        if (testObj instanceof IBuildReceiver) {
            if (this.mBuildInfo == null) {
                throw new IllegalArgumentException("Missing build information");
            }
            ((IBuildReceiver)testObj).setBuild(this.mBuildInfo);
        }
        if (testObj instanceof IDeviceTest) {
            if (this.mDevice == null) {
                throw new IllegalArgumentException("Missing device");
            }
            ((IDeviceTest)testObj).setDevice(this.mDevice);
        }
        if (testObj instanceof IAbiReceiver) {
            ((IAbiReceiver)testObj).setAbi(this.mAbi);
        }
        if (testObj instanceof IInvocationContextReceiver) {
            ((IInvocationContextReceiver)testObj).setInvocationContext(this.mTestInfo.getContext());
        }
        if (testObj instanceof ITestInformationReceiver) {
            ((ITestInformationReceiver)testObj).setTestInformation(this.mTestInfo);
        }
        if (testObj instanceof ISetOptionReceiver) {
            try {
                OptionSetter setter = new OptionSetter(new Object[]{testObj});
                for (String item : this.mKeyValueOptions) {
                    setter.setOptionValue(SET_OPTION_NAME, item);
                }
            }
            catch (ConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        if (testObj instanceof IConfigurationReceiver) {
            ((IConfigurationReceiver)testObj).setConfiguration(this.mConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        this.mTestInfo = testInfo;
        this.mFilterHelper.addAllIncludeAnnotation(this.mIncludeAnnotations);
        this.mFilterHelper.addAllExcludeAnnotation(this.mExcludeAnnotations);
        try {
            try {
                List<Class<?>> classes = this.getClasses();
                if (!this.mSkipTestClassCheck && classes.isEmpty()) {
                    throw new HarnessRuntimeException("No '--class' option was specified.", (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
                }
                if (this.mMethodName != null && classes.size() > 1) {
                    throw new HarnessRuntimeException(String.format("'--method' only supports one '--class' name. Multiple were given: '%s'", classes), (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
                }
            }
            catch (RuntimeException e) {
                listener.testRunStarted(this.getClass().getCanonicalName(), 0);
                listener.testRunFailed(this.createFromException(e));
                listener.testRunEnded(0L, new HashMap());
                this.mLoadedClasses.clear();
                for (URLClassLoader cl : this.mOpenClassLoaders) {
                    StreamUtil.close((Closeable)cl);
                }
                this.mOpenClassLoaders.clear();
                return;
            }
            if (this.mEnableHostDeviceLogs) {
                PrettyTestEventLogger logger = new PrettyTestEventLogger(this.mTestInfo.getDevices());
                listener = new ResultForwarder(new ITestInvocationListener[]{logger, listener});
            }
            if (this.mTestMethods != null) {
                this.runTestCases(listener);
            } else {
                this.runTestClasses(listener);
            }
        }
        finally {
            this.mLoadedClasses.clear();
            for (URLClassLoader cl : this.mOpenClassLoaders) {
                StreamUtil.close((Closeable)cl);
            }
            this.mOpenClassLoaders.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestClasses(ITestInvocationListener listener) throws DeviceNotAvailableException {
        for (Class<?> classObj : this.getClasses()) {
            if (IRemoteTest.class.isAssignableFrom(classObj)) {
                IRemoteTest test = (IRemoteTest)this.loadObject(classObj);
                this.applyFilters(classObj, test);
                this.runRemoteTest(listener, test);
                continue;
            }
            if (junit.framework.Test.class.isAssignableFrom(classObj)) {
                TestSuite junitTest = this.collectTests(this.collectClasses(classObj));
                Enumeration allTest = junitTest.tests();
                while (allTest.hasMoreElements()) {
                    junit.framework.Test testObj = (junit.framework.Test)allTest.nextElement();
                    this.mDownloadedFiles.addAll(this.resolveRemoteFileForObject(testObj));
                }
                try {
                    this.runJUnit3Tests(listener, junitTest, classObj.getName());
                }
                catch (Throwable throwable) {
                    for (File f : this.mDownloadedFiles) {
                        FileUtil.recursiveDelete((File)f);
                    }
                    throw throwable;
                }
                for (File f : this.mDownloadedFiles) {
                    FileUtil.recursiveDelete((File)f);
                }
                continue;
            }
            if (this.hasJUnit4Annotation(classObj)) {
                Set includes = this.mFilterHelper.getIncludeFilters();
                if (this.mMethodName != null) {
                    includes.add(String.format(TEST_FULL_NAME_FORMAT, classObj.getName(), this.mMethodName));
                }
                Request req = Request.aClass(classObj);
                Runner checkRunner = null;
                try {
                    req = req.filterWith((Filter)new JUnit4TestFilter(this.mFilterHelper, this.mJUnit4JarFiles));
                    checkRunner = req.getRunner();
                }
                catch (RuntimeException e) {
                    listener.testRunStarted(classObj.getName(), 0);
                    listener.testRunFailed(this.createFromException(e));
                    listener.testRunEnded(0L, new HashMap());
                    return;
                }
                this.runJUnit4Tests(listener, checkRunner, classObj.getName());
                continue;
            }
            throw new IllegalArgumentException(String.format("%s is not a supported test", classObj.getName()));
        }
    }

    private void runTestCases(ITestInvocationListener listener) throws DeviceNotAvailableException {
        LinkedHashSet<String> skippedTests = new LinkedHashSet<String>();
        for (Object obj : this.getTestMethods()) {
            if (IRemoteTest.class.isInstance(obj)) {
                IRemoteTest test = (IRemoteTest)obj;
                this.runRemoteTest(listener, test);
                continue;
            }
            if (TestSuite.class.isInstance(obj)) {
                TestSuite junitTest = (TestSuite)obj;
                if (this.runJUnit3Tests(listener, junitTest, junitTest.getName())) continue;
                skippedTests.add(junitTest.getName());
                continue;
            }
            if (Description.class.isInstance(obj)) {
                Description desc = (Description)obj;
                Request req = Request.aClass((Class)desc.getTestClass());
                Runner checkRunner = req.filterWith(desc).getRunner();
                try {
                    this.runJUnit4Tests(listener, checkRunner, desc.getClassName());
                    continue;
                }
                catch (RuntimeException e) {
                    listener.testRunStarted(desc.getClassName(), 0);
                    listener.testRunFailed(this.createFromException(e));
                    listener.testRunEnded(0L, new HashMap());
                    throw e;
                }
            }
            throw new IllegalArgumentException(String.format("%s is not a supported test", obj));
        }
        LogUtil.CLog.v((String)"The following classes were skipped due to no test cases found: %s", (Object[])new Object[]{skippedTests});
    }

    private void runRemoteTest(ITestInvocationListener listener, IRemoteTest test) throws DeviceNotAvailableException {
        if (this.mCollectTestsOnly) {
            if (test instanceof ITestCollector) {
                ((ITestCollector)test).setCollectTestsOnly(true);
            } else {
                throw new IllegalArgumentException(String.format("%s does not implement ITestCollector", test.getClass()));
            }
        }
        if (test instanceof IMetricCollectorReceiver) {
            ((IMetricCollectorReceiver)test).setMetricCollectors(new ArrayList());
        }
        test.run(this.mTestInfo, listener);
    }

    private boolean runJUnit3Tests(ITestInvocationListener listener, TestSuite junitTest, String className) throws DeviceNotAvailableException {
        if (this.mCollectTestsOnly) {
            int testCount = junitTest.countTestCases();
            listener.testRunStarted(className, testCount);
            HashMap empty = new HashMap();
            for (int i = 0; i < testCount; ++i) {
                junit.framework.Test t = junitTest.testAt(i);
                String testName = t.toString().split("\\(")[0];
                TestDescription testId = new TestDescription(t.getClass().getName(), testName);
                listener.testStarted(testId);
                listener.testEnded(testId, empty);
            }
            HashMap emptyMap = new HashMap();
            listener.testRunEnded(0L, emptyMap);
            return testCount > 0;
        }
        if (this.mTestCaseTimeout.toMillis() > 0L) {
            listener = new TestTimeoutEnforcer(this.mTestCaseTimeout.toMillis(), TimeUnit.MILLISECONDS, new ITestInvocationListener[]{listener});
        }
        try (CloseableTraceScope ignored = new CloseableTraceScope(className);){
            boolean bl = JUnitRunUtil.runTest(listener, (junit.framework.Test)junitTest, className, this.mTestInfo);
            return bl;
        }
    }

    private void runJUnit4Tests(ITestInvocationListener listener, Runner checkRunner, String className) throws DeviceNotAvailableException {
        block18: {
            JUnit4ResultForwarder list;
            block17: {
                JUnitCore runnerCore = new JUnitCore();
                if (this.mTestCaseTimeout.toMillis() > 0L) {
                    listener = new TestTimeoutEnforcer(this.mTestCaseTimeout.toMillis(), TimeUnit.MILLISECONDS, new ITestInvocationListener[]{listener});
                }
                list = new JUnit4ResultForwarder((ITestInvocationListener)listener);
                runnerCore.addListener((RunListener)list);
                if (checkRunner instanceof ErrorReportingRunner) break block17;
                long startTime = System.currentTimeMillis();
                listener.testRunStarted(className, checkRunner.testCount());
                try (CloseableTraceScope ignore = new CloseableTraceScope(className);){
                    if (this.mCollectTestsOnly) {
                        this.fakeDescriptionExecution(checkRunner.getDescription(), list);
                    } else {
                        this.setTestObjectInformation(checkRunner);
                        ExceptionThrowingRunnerWrapper runnerWrapper = new ExceptionThrowingRunnerWrapper(checkRunner, this.mTestInfo);
                        runnerCore.run((Runner)runnerWrapper);
                    }
                }
                catch (CarryDnaeError e) {
                    try {
                        throw e.getDeviceNotAvailableException();
                    }
                    catch (Throwable throwable) {
                        for (Description d : this.findIgnoredClass(checkRunner.getDescription())) {
                            TestDescription testDescription = new TestDescription(d.getClassName(), "No Tests");
                            listener.testStarted(testDescription);
                            listener.testIgnored(testDescription);
                            listener.testEnded(testDescription, new HashMap());
                        }
                        listener.testRunEnded(System.currentTimeMillis() - startTime, new HashMap());
                        throw throwable;
                    }
                }
                for (Description d : this.findIgnoredClass(checkRunner.getDescription())) {
                    TestDescription testDescription = new TestDescription(d.getClassName(), "No Tests");
                    listener.testStarted(testDescription);
                    listener.testIgnored(testDescription);
                    listener.testEnded(testDescription, new HashMap());
                }
                listener.testRunEnded(System.currentTimeMillis() - startTime, new HashMap());
                break block18;
            }
            if (EXCLUDE_NO_TEST_FAILURE.equals(checkRunner.getDescription().getClassName())) {
                listener.testRunStarted(className, 0);
                listener.testRunEnded(0L, new HashMap());
            } else {
                listener.testRunStarted(className, checkRunner.testCount());
                RunNotifier failureNotifier = new RunNotifier();
                failureNotifier.addListener((RunListener)list);
                checkRunner.run(failureNotifier);
                listener.testRunEnded(0L, new HashMap());
            }
        }
    }

    private List<Description> findIgnoredClass(Description description) {
        ArrayList<Description> ignoredClass;
        block2: {
            block3: {
                ignoredClass = new ArrayList<Description>();
                if (!description.isSuite()) break block3;
                for (Description childDescription : description.getChildren()) {
                    ignoredClass.addAll(this.findIgnoredClass(childDescription));
                }
                break block2;
            }
            if (description.getMethodName() != null) break block2;
            for (Annotation a : description.getAnnotations()) {
                if (a.annotationType() == null || !a.annotationType().equals(Ignore.class)) continue;
                ignoredClass.add(description);
                break;
            }
        }
        return ignoredClass;
    }

    private void fakeDescriptionExecution(Description desc, JUnit4ResultForwarder listener) {
        if (desc.getMethodName() == null || !desc.getChildren().isEmpty()) {
            for (Description child : desc.getChildren()) {
                this.fakeDescriptionExecution(child, listener);
            }
        } else {
            try {
                listener.testStarted(desc);
                listener.testFinished(desc);
            }
            catch (Exception e) {
                LogUtil.CLog.e((Throwable)e);
            }
        }
    }

    private Set<Class<?>> collectClasses(Class<?> classObj) {
        HashSet classes = new HashSet();
        if (TestSuite.class.isAssignableFrom(classObj)) {
            TestSuite testObj = (TestSuite)this.loadObject(classObj);
            classes.addAll(this.getClassesFromSuite(testObj));
        } else {
            classes.add(classObj);
        }
        return classes;
    }

    private Set<Class<?>> getClassesFromSuite(TestSuite suite) {
        HashSet classes = new HashSet();
        Enumeration tests = suite.tests();
        while (tests.hasMoreElements()) {
            junit.framework.Test test = (junit.framework.Test)tests.nextElement();
            if (test instanceof TestSuite) {
                classes.addAll(this.getClassesFromSuite((TestSuite)test));
                continue;
            }
            classes.addAll(this.collectClasses(test.getClass()));
        }
        return classes;
    }

    private TestSuite collectTests(Set<Class<?>> classes) {
        TestSuite suite = new TestSuite();
        for (Class<?> classObj : classes) {
            String packageName = classObj.getPackage().getName();
            String className = classObj.getName();
            Method[] methods = null;
            if (this.mMethodName == null) {
                methods = classObj.getMethods();
            } else {
                try {
                    methods = new Method[]{classObj.getMethod(this.mMethodName, null)};
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException(String.format("Cannot find %s#%s", className, this.mMethodName), e);
                }
            }
            for (Method method : methods) {
                if (!Modifier.isPublic(method.getModifiers()) || !method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length > 0 || !method.getName().startsWith("test") || !this.mFilterHelper.shouldRun(packageName, classObj, method)) continue;
                junit.framework.Test testObj = (junit.framework.Test)this.loadObject(classObj, false);
                if (testObj instanceof TestCase) {
                    ((TestCase)testObj).setName(method.getName());
                }
                suite.addTest(testObj);
            }
        }
        return suite;
    }

    private List<Object> getTestMethods() throws IllegalArgumentException {
        if (this.mTestMethods != null) {
            return this.mTestMethods;
        }
        this.mTestMethods = new ArrayList<Object>();
        this.mFilterHelper.addAllIncludeAnnotation(this.mIncludeAnnotations);
        this.mFilterHelper.addAllExcludeAnnotation(this.mExcludeAnnotations);
        List<Class<?>> classes = this.getClasses();
        for (Class<?> classObj : classes) {
            if (junit.framework.Test.class.isAssignableFrom(classObj)) {
                TestSuite suite = this.collectTests(this.collectClasses(classObj));
                for (int i = 0; i < suite.testCount(); ++i) {
                    TestSuite singletonSuite = new TestSuite();
                    singletonSuite.setName(classObj.getName());
                    junit.framework.Test testObj = suite.testAt(i);
                    singletonSuite.addTest(testObj);
                    if (IRemoteTest.class.isInstance(testObj)) {
                        this.setTestObjectInformation(testObj);
                    }
                    this.mTestMethods.add(singletonSuite);
                }
                continue;
            }
            if (IRemoteTest.class.isAssignableFrom(classObj)) {
                IRemoteTest test = (IRemoteTest)this.loadObject(classObj);
                this.applyFilters(classObj, test);
                this.mTestMethods.add(test);
                continue;
            }
            if (this.hasJUnit4Annotation(classObj)) {
                Request req = Request.aClass(classObj);
                Set includes = this.mFilterHelper.getIncludeFilters();
                if (this.mMethodName != null) {
                    includes.add(String.format(TEST_FULL_NAME_FORMAT, classObj.getName(), this.mMethodName));
                }
                req = req.filterWith((Filter)new JUnit4TestFilter(this.mFilterHelper, this.mJUnit4JarFiles));
                Runner checkRunner = req.getRunner();
                ArrayDeque<Description> descriptions = new ArrayDeque<Description>();
                descriptions.push(checkRunner.getDescription());
                while (!descriptions.isEmpty()) {
                    Description desc = (Description)descriptions.pop();
                    if (desc.isTest()) {
                        this.mTestMethods.add(desc);
                    }
                    ArrayList children = desc.getChildren();
                    Collections.reverse(children);
                    for (Description child : children) {
                        descriptions.push(child);
                    }
                }
                continue;
            }
            throw new IllegalArgumentException(String.format("%s is not a supported test", classObj.getName()));
        }
        return this.mTestMethods;
    }

    protected final List<Class<?>> getClasses() throws IllegalArgumentException {
        URL[] urls;
        if (!this.mLoadedClasses.isEmpty()) {
            return this.mLoadedClasses;
        }
        HashSet<String> classNames = new HashSet<String>();
        List<Class<?>> classes = this.mLoadedClasses;
        for (String className : this.mClasses) {
            String moduleName;
            if (classNames.contains(className)) continue;
            IllegalArgumentException initialError = null;
            try {
                classes.add(Class.forName(className, true, this.getClassLoader()));
                classNames.add(className);
            }
            catch (ClassNotFoundException e) {
                initialError = new IllegalArgumentException(String.format("Could not load Test class %s", className), e);
            }
            if (initialError != null && (moduleName = (String)this.mTestInfo.getContext().getAttributes().getUniqueMap().get("module-name")) != null) {
                URLClassLoader cl = null;
                try {
                    File f = this.getJarFile(moduleName + ".jar", this.mTestInfo);
                    urls = new URL[]{f.toURI().toURL()};
                    cl = URLClassLoader.newInstance(urls);
                    this.mJUnit4JarFiles.add(f);
                    Class<?> cls = cl.loadClass(className);
                    classes.add(cls);
                    classNames.add(className);
                    initialError = null;
                    this.mOpenClassLoaders.add(cl);
                }
                catch (FileNotFoundException | ClassNotFoundException | MalformedURLException fallbackSearch) {
                    StreamUtil.close(cl);
                    LogUtil.CLog.e((String)"Fallback search for a jar containing '%s' didn't work.Consider using --jar option directly instead of using --class", (Object[])new Object[]{className});
                }
            }
            if (initialError == null) continue;
            throw initialError;
        }
        URLClassLoader cl = null;
        for (String jarName : this.mJars) {
            JarFile jarFile = null;
            try {
                File file = this.getJarFile(jarName, this.mTestInfo);
                jarFile = new JarFile(file);
                Enumeration<JarEntry> e = jarFile.entries();
                urls = new URL[]{file.toURI().toURL()};
                cl = URLClassLoader.newInstance(urls);
                this.mJUnit4JarFiles.add(file);
                this.mOpenClassLoaders.add(cl);
                while (e.hasMoreElements()) {
                    String className;
                    JarEntry je = e.nextElement();
                    if (je.isDirectory() || !je.getName().endsWith(".class") || je.getName().contains("$") || classNames.contains(className = this.getClassName(je.getName()))) continue;
                    try {
                        Class<?> cls = cl.loadClass(className);
                        int modifiers = cls.getModifiers();
                        if (!IRemoteTest.class.isAssignableFrom(cls) && !junit.framework.Test.class.isAssignableFrom(cls) && !this.hasJUnit4Annotation(cls) || Modifier.isStatic(modifiers) || Modifier.isPrivate(modifiers) || Modifier.isProtected(modifiers) || Modifier.isInterface(modifiers) || Modifier.isAbstract(modifiers) || !this.mClasses.isEmpty() && !this.mClasses.contains(className)) continue;
                        classes.add(cls);
                        classNames.add(className);
                    }
                    catch (UnsupportedClassVersionError ucve) {
                        throw new IllegalArgumentException(String.format("Could not load class %s from jar %s. Reason:\n%s", className, jarName, StreamUtil.getStackTrace((Throwable)ucve)));
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new IllegalArgumentException(String.format("Cannot find test class %s", className));
                    }
                    catch (IllegalAccessError | NoClassDefFoundError err) {
                    }
                }
            }
            catch (IOException e) {
                try {
                    LogUtil.CLog.e((Throwable)e);
                    throw new IllegalArgumentException(e);
                }
                catch (Throwable throwable) {
                    StreamUtil.close(jarFile);
                    throw throwable;
                }
            }
            StreamUtil.close((Closeable)jarFile);
        }
        return classes;
    }

    @VisibleForTesting
    protected ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    protected Object loadObject(Class<?> classObj) {
        return this.loadObject(classObj, true);
    }

    private Object loadObject(Class<?> classObj, boolean setInfo) throws IllegalArgumentException {
        String className = classObj.getName();
        try {
            Object testObj = classObj.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            HostTest.setOptionToLoadedObject(testObj, this.mKeyValueOptions);
            if (setInfo) {
                this.setTestObjectInformation(testObj);
            }
            return testObj;
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(String.format("Could not load Test class %s", className), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(String.format("Could not load Test class %s", className), e);
        }
        catch (NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(String.format("Could not load Test class %s", className), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setOptionToLoadedObject(Object testObj, List<String> keyValueOptions) {
        if (!keyValueOptions.isEmpty()) {
            OptionSetter setter;
            try {
                setter = new OptionSetter(new Object[]{testObj});
            }
            catch (ConfigurationException ce) {
                LogUtil.CLog.e((Throwable)ce);
                throw new RuntimeException("error creating option setter", ce);
            }
            for (String item : keyValueOptions) {
                String value;
                String key;
                block10: {
                    String delim = ":";
                    String esc = "\\";
                    String regex = "(?<!" + Pattern.quote(esc) + ")" + Pattern.quote(delim);
                    String[] fields = item.split(regex);
                    if (fields.length == 3) {
                        String target = fields[0];
                        if (testObj.getClass().getName().equals(target)) {
                            key = fields[1];
                            value = fields[2].replaceAll(Pattern.quote(esc) + Pattern.quote(delim), delim);
                            break block10;
                        } else {
                            LogUtil.CLog.d((String)"Targeted option %s is not applicable to %s", (Object[])new Object[]{item, testObj.getClass().getName()});
                            continue;
                        }
                    }
                    if (fields.length != 2) {
                        throw new RuntimeException(String.format("invalid option spec \"%s\"", item));
                    }
                    key = fields[0];
                    value = fields[1].replaceAll(Pattern.quote(esc) + Pattern.quote(delim), delim);
                }
                try {
                    HostTest.injectOption(setter, item, key, value);
                }
                catch (ConfigurationException ce) {
                    LogUtil.CLog.e((Throwable)ce);
                    throw new RuntimeException("error passing option '" + item + "' down to test class as key=" + key + " value=" + value, ce);
                }
            }
        }
    }

    private static void injectOption(OptionSetter setter, String origItem, String key, String value) throws ConfigurationException {
        String esc = "\\";
        String delim = "=";
        String regex = "(?<!" + Pattern.quote(esc) + ")" + Pattern.quote(delim);
        String escDelim = Pattern.quote(esc) + Pattern.quote(delim);
        String[] values = value.split(regex);
        if (values.length == 1) {
            setter.setOptionValue(key, values[0].replaceAll(escDelim, delim));
        } else if (values.length == 2) {
            setter.setOptionValue(key, values[0].replaceAll(escDelim, delim), values[1].replaceAll(escDelim, delim));
        } else {
            throw new RuntimeException(String.format("set-option provided '%s' format is invalid. Only one '=' is allowed", origItem));
        }
    }

    protected boolean shouldTestRun(AnnotatedElement annotatedElement) {
        return this.mFilterHelper.shouldTestRun(annotatedElement);
    }

    public void setCollectTestsOnly(boolean shouldCollectTest) {
        this.mCollectTestsOnly = shouldCollectTest;
    }

    protected boolean hasJUnit4Annotation(Class<?> classObj) {
        if (classObj.isAnnotationPresent(Suite.SuiteClasses.class)) {
            return true;
        }
        if (classObj.isAnnotationPresent(RunWith.class)) {
            return true;
        }
        for (Method m : classObj.getMethods()) {
            if (!m.isAnnotationPresent(Test.class)) continue;
            return true;
        }
        return false;
    }

    private void applyFilters(Class<?> classObj, IRemoteTest test) {
        Set includes = this.mFilterHelper.getIncludeFilters();
        if (this.mMethodName != null) {
            includes.add(String.format(TEST_FULL_NAME_FORMAT, classObj.getName(), this.mMethodName));
        }
        Set excludes = this.mFilterHelper.getExcludeFilters();
        if (test instanceof ITestFilterReceiver) {
            ((ITestFilterReceiver)test).addAllIncludeFilters(includes);
            ((ITestFilterReceiver)test).addAllExcludeFilters(excludes);
        } else if (!includes.isEmpty() || !excludes.isEmpty()) {
            throw new IllegalArgumentException(String.format("%s does not implement ITestFilterReceiver", classObj.getName()));
        }
        if (test instanceof ITestAnnotationFilterReceiver) {
            ((ITestAnnotationFilterReceiver)test).addAllIncludeAnnotation(this.mIncludeAnnotations);
            ((ITestAnnotationFilterReceiver)test).addAllExcludeAnnotation(this.mExcludeAnnotations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<IRemoteTest> split(Integer shardCount, TestInformation testInfo) {
        if (shardCount == null) {
            return null;
        }
        if (shardCount < 1) {
            throw new IllegalArgumentException("Must have at least 1 shard");
        }
        this.mTestInfo = testInfo;
        ArrayList<IRemoteTest> listTests = new ArrayList<IRemoteTest>();
        try {
            List<Object> testObjects;
            List<Class<?>> classes = this.getClasses();
            if (classes.isEmpty()) {
                throw new IllegalArgumentException("Missing Test class name");
            }
            if (this.mMethodName != null && classes.size() > 1) {
                throw new IllegalArgumentException("Method name given with multiple test classes");
            }
            if (this.shardUnitIsMethod()) {
                testObjects = this.getTestMethods();
            } else {
                testObjects = classes;
                shardCount = testObjects.size();
            }
            if (testObjects.size() == 1) {
                Collection<IRemoteTest> collection = null;
                return collection;
            }
            int i = 0;
            int numTotalTestCases = this.countTestCases();
            for (Object testObj : testObjects) {
                Collection<Object> subTests;
                HostTest test;
                Class classObj;
                Class clazz = classObj = Class.class.isInstance(testObj) ? (Class)testObj : null;
                if (i >= listTests.size()) {
                    test = this.createHostTest(classObj);
                    test.mRuntimeHint = 0L;
                    test.addAllExcludeFilters(this.mFilterHelper.getExcludeFilters());
                    test.addAllIncludeFilters(this.mFilterHelper.getIncludeFilters());
                    listTests.add(test);
                }
                test = (HostTest)listTests.get(i);
                if (classObj != null) {
                    test.addClassName(classObj.getName());
                    test.mJars = this.mJars;
                    subTests = test.mClasses;
                } else {
                    test.addTestMethod(testObj);
                    subTests = test.mTestMethods;
                }
                test.mRuntimeHint = numTotalTestCases == 0 ? 0L : this.mRuntimeHint * (long)subTests.size() / (long)numTotalTestCases;
                i = (i + 1) % shardCount;
            }
        }
        finally {
            this.mLoadedClasses.clear();
            for (URLClassLoader cl : this.mOpenClassLoaders) {
                StreamUtil.close((Closeable)cl);
            }
            this.mOpenClassLoaders.clear();
        }
        return listTests;
    }

    private void addTestMethod(Object testObject) {
        if (this.mTestMethods == null) {
            this.mTestMethods = new ArrayList<Object>();
            this.mClasses.clear();
        }
        this.mTestMethods.add(testObject);
        if (IRemoteTest.class.isInstance(testObject)) {
            this.addClassName(testObject.getClass().getName());
        } else if (TestSuite.class.isInstance(testObject)) {
            this.addClassName(((TestSuite)testObject).getName());
        } else if (Description.class.isInstance(testObject)) {
            this.addClassName(((Description)testObject).getTestClass().getName());
        }
    }

    private void addClassName(String className) {
        this.mClasses.add(className);
    }

    protected HostTest createHostTest(Class<?> classObj) {
        HostTest test;
        try {
            test = (HostTest)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        OptionCopier.copyOptionsNoThrow((Object)this, (Object)test);
        if (classObj != null) {
            test.setClassName(classObj.getName());
        }
        test.mJars = new HashSet<String>();
        test.setAbi(this.mAbi);
        return test;
    }

    private String getClassName(String name) {
        return name.substring(0, name.length() - 6).replace('/', '.');
    }

    @VisibleForTesting
    protected File getJarFile(String jarName, TestInformation testInfo) throws FileNotFoundException {
        return testInfo.getDependencyFile(jarName, false);
    }

    @VisibleForTesting
    DynamicRemoteFileResolver createResolver() {
        DynamicRemoteFileResolver resolver = new DynamicRemoteFileResolver();
        resolver.setDevice(this.mDevice);
        resolver.addExtraArgs(this.mConfig.getCommandOptions().getDynamicDownloadArgs());
        return resolver;
    }

    private Set<File> resolveRemoteFileForObject(Object obj) {
        Set set;
        CloseableTraceScope ignore = new CloseableTraceScope("infra:resolveRemoteFiles");
        try {
            OptionSetter setter = new OptionSetter(new Object[]{obj});
            set = setter.validateRemoteFilePath(this.createResolver());
        }
        catch (Throwable throwable) {
            try {
                try {
                    ignore.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (BuildRetrievalError | ConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        ignore.close();
        return set;
    }

    private FailureDescription createFromException(Throwable exception) {
        FailureDescription failure = CurrentInvocation.createFailure((String)StreamUtil.getStackTrace((Throwable)exception), null).setCause(exception);
        if (exception instanceof IHarnessException) {
            ErrorIdentifier id = ((IHarnessException)exception).getErrorId();
            failure.setErrorIdentifier(id);
            if (id != null) {
                failure.setFailureStatus(id.status());
            }
            failure.setOrigin(((IHarnessException)exception).getOrigin());
        }
        return failure;
    }

    static enum ShardUnit {
        CLASS,
        METHOD;

    }
}

