/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.ITestAnnotationFilterReceiver;
import com.android.tradefed.testtype.ITestCollector;
import com.android.tradefed.testtype.ITestFilterReceiver;
import com.android.tradefed.testtype.JUnitRunUtil;
import com.android.tradefed.testtype.MetricTestCase;
import com.android.tradefed.util.TestFilterHelper;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestResult;

public class DeviceTestCase
extends MetricTestCase
implements IDeviceTest,
IRemoteTest,
ITestCollector,
ITestFilterReceiver,
ITestAnnotationFilterReceiver {
    private ITestDevice mDevice;
    private TestFilterHelper mFilterHelper;
    @Option(name="include-filter", description="The include filters of the test name to run.")
    protected Set<String> mIncludeFilters = new HashSet<String>();
    @Option(name="exclude-filter", description="The exclude filters of the test name to run.")
    protected Set<String> mExcludeFilters = new HashSet<String>();
    @Option(name="include-annotation", description="The set of annotations a test must have to be run.")
    protected Set<String> mIncludeAnnotation = new HashSet<String>();
    @Option(name="exclude-annotation", description="The name of class for the notAnnotation filter to be used.")
    protected Set<String> mExcludeAnnotation = new HashSet<String>();
    @Option(name="method", description="run a specific test method.")
    private String mMethodName = null;
    @Option(name="collect-tests-only", description="Only invoke the instrumentation to collect list of applicable test cases. All test run callbacks will be triggered, but test execution will not be actually carried out.")
    private boolean mCollectTestsOnly = false;
    private Vector<String> mMethodNames = null;

    public DeviceTestCase() {
        this.mFilterHelper = new TestFilterHelper(this.mIncludeFilters, this.mExcludeFilters, this.mIncludeAnnotation, this.mExcludeAnnotation);
    }

    public DeviceTestCase(String name) {
        super(name);
        this.mFilterHelper = new TestFilterHelper(this.mIncludeFilters, this.mExcludeFilters, this.mIncludeAnnotation, this.mExcludeAnnotation);
    }

    public ITestDevice getDevice() {
        return this.mDevice;
    }

    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (this.getName() == null && this.mMethodName != null) {
            this.setName(this.mMethodName);
        }
        if (this.mCollectTestsOnly) {
            HashMap empty = new HashMap();
            String runName = ((Object)((Object)this)).getClass().getName();
            if (this.getName() == null) {
                Collection<String> testMethodNames = this.getTestMethodNames();
                if (testMethodNames.isEmpty()) {
                    LogUtil.CLog.v((String)"Skipping empty test case %s", (Object[])new Object[]{runName});
                    return;
                }
                listener.testRunStarted(runName, testMethodNames.size());
                for (String methodName : testMethodNames) {
                    TestDescription testId = new TestDescription(runName, methodName);
                    listener.testStarted(testId);
                    listener.testEnded(testId, empty);
                }
                listener.testRunEnded(0L, new HashMap());
            } else {
                listener.testRunStarted(runName, 1);
                TestDescription testId = new TestDescription(runName, this.getName());
                listener.testStarted(testId);
                listener.testEnded(testId, empty);
                listener.testRunEnded(0L, new HashMap());
            }
        } else {
            JUnitRunUtil.runTest(listener, (Test)this);
        }
    }

    public void run(TestResult result) {
        this.mFilterHelper.addAllExcludeAnnotation(this.mExcludeAnnotation);
        this.mFilterHelper.addAllIncludeAnnotation(this.mIncludeAnnotation);
        this.mFilterHelper.addAllExcludeFilters(this.mExcludeFilters);
        this.mFilterHelper.addAllIncludeFilters(this.mIncludeFilters);
        if (this.getName() == null) {
            Collection<String> testMethodNames = this.getTestMethodNames();
            for (String methodName : testMethodNames) {
                this.setName(methodName);
                LogUtil.CLog.d((String)"Running %s#%s()", (Object[])new Object[]{((Object)((Object)this)).getClass().getName(), methodName});
                super.run(result);
            }
        } else {
            LogUtil.CLog.d((String)"Running %s#%s()", (Object[])new Object[]{((Object)((Object)this)).getClass().getName(), this.getName()});
            super.run(result);
        }
    }

    public int countTestCases() {
        if (this.getName() != null || this.mMethodName != null) {
            return 1;
        }
        return this.getTestMethodNames().size();
    }

    public void addIncludeFilter(String filter) {
        this.mIncludeFilters.add(filter);
        this.mFilterHelper.addIncludeFilter(filter);
    }

    public void addAllIncludeFilters(Set<String> filters) {
        this.mIncludeFilters.addAll(filters);
        this.mFilterHelper.addAllIncludeFilters(filters);
    }

    public void addExcludeFilter(String filter) {
        this.mExcludeFilters.add(filter);
        this.mFilterHelper.addExcludeFilter(filter);
    }

    public void addAllExcludeFilters(Set<String> filters) {
        this.mExcludeFilters.addAll(filters);
        this.mFilterHelper.addAllExcludeFilters(filters);
    }

    public void clearIncludeFilters() {
        this.mIncludeFilters.clear();
        this.mFilterHelper.clearIncludeFilters();
    }

    public Set<String> getIncludeFilters() {
        return this.mIncludeFilters;
    }

    public Set<String> getExcludeFilters() {
        return this.mExcludeFilters;
    }

    public void clearExcludeFilters() {
        this.mExcludeFilters.clear();
        this.mFilterHelper.clearExcludeFilters();
    }

    public void addIncludeAnnotation(String annotation) {
        this.mIncludeAnnotation.add(annotation);
        this.mFilterHelper.addIncludeAnnotation(annotation);
    }

    public void addAllIncludeAnnotation(Set<String> annotations) {
        this.mIncludeAnnotation.addAll(annotations);
        this.mFilterHelper.addAllIncludeAnnotation(annotations);
    }

    public void addExcludeAnnotation(String notAnnotation) {
        this.mExcludeAnnotation.add(notAnnotation);
        this.mFilterHelper.addExcludeAnnotation(notAnnotation);
    }

    public void addAllExcludeAnnotation(Set<String> notAnnotations) {
        this.mExcludeAnnotation.addAll(notAnnotations);
        this.mFilterHelper.addAllExcludeAnnotation(notAnnotations);
    }

    public Set<String> getIncludeAnnotations() {
        return this.mIncludeAnnotation;
    }

    public Set<String> getExcludeAnnotations() {
        return this.mExcludeAnnotation;
    }

    public void clearIncludeAnnotations() {
        this.mIncludeAnnotation.clear();
        this.mFilterHelper.clearIncludeAnnotations();
    }

    public void clearExcludeAnnotations() {
        this.mExcludeAnnotation.clear();
        this.mFilterHelper.clearExcludeAnnotations();
    }

    private Collection<String> getTestMethodNames() {
        if (this.mMethodNames == null) {
            Class<?> theClass;
            this.mMethodNames = new Vector();
            Class<?> superClass = theClass = ((Object)((Object)this)).getClass();
            HashSet<String> overridenMethod = new HashSet<String>();
            while (Test.class.isAssignableFrom(superClass)) {
                Method[] methods;
                for (Method method : methods = superClass.getDeclaredMethods()) {
                    if (overridenMethod.contains(method.getName()) || !Modifier.isPublic(method.getModifiers()) || !method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 0 || !method.getName().startsWith("test")) continue;
                    if (theClass.equals(method.getDeclaringClass())) {
                        overridenMethod.add(method.getName());
                    }
                    if (!this.mFilterHelper.shouldRun(theClass.getPackage().getName(), theClass, method)) continue;
                    this.mMethodNames.addElement(method.getName());
                }
                superClass = superClass.getSuperclass();
            }
        }
        return this.mMethodNames;
    }

    public void setCollectTestsOnly(boolean shouldCollectTest) {
        this.mCollectTestsOnly = shouldCollectTest;
    }
}

