/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IAbiReceiver;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.ISetOptionReceiver;
import com.android.tradefed.testtype.ITestInformationReceiver;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.junit.internal.runners.JUnit38ClassRunner;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class DeviceSuite
extends Suite
implements IAbiReceiver,
ISetOptionReceiver,
ITestInformationReceiver {
    private TestInformation mTestInfo;
    private IAbi mAbi;
    @Option(name="set-option", description="Options to be passed down to the class under test, key and value should be separated by colon \":\"; for example, if class under test supports \"--iteration 1\" from a command line, it should be passed in as \"--set-option iteration:1\" or \"--set-option iteration:key=value\" for passing options to map. Values that contain \":\" or \"=\" can be escaped with a backslash. A particular class can be targeted by specifying it. \" --set-option <fully qualified class>:<option name>:<option value>\"")
    private Set<String> mKeyValueOptions = new HashSet<String>();

    public DeviceSuite(Class<?> klass, RunnerBuilder builder) throws InitializationError {
        super(klass, builder);
    }

    public void setTestInformation(TestInformation testInformation) {
        this.mTestInfo = testInformation;
        for (Runner r : this.getChildren()) {
            if (r instanceof IDeviceTest) {
                ((IDeviceTest)r).setDevice(this.mTestInfo.getDevice());
            }
            if (r instanceof IBuildReceiver) {
                ((IBuildReceiver)r).setBuild(this.mTestInfo.getBuildInfo());
            }
            if (!(r instanceof ITestInformationReceiver)) continue;
            ((ITestInformationReceiver)r).setTestInformation(this.mTestInfo);
        }
    }

    public TestInformation getTestInformation() {
        return this.mTestInfo;
    }

    public void setAbi(IAbi abi) {
        this.mAbi = abi;
        for (Runner r : this.getChildren()) {
            if (!(r instanceof IAbiReceiver)) continue;
            ((IAbiReceiver)r).setAbi(this.mAbi);
        }
    }

    public IAbi getAbi() {
        return this.mAbi;
    }

    protected void runChild(Runner runner, RunNotifier notifier) {
        if (runner instanceof JUnit38ClassRunner) {
            JUnit38ClassRunner junit3Runner = (JUnit38ClassRunner)runner;
            try {
                Method getTest = junit3Runner.getClass().getDeclaredMethod("getTest", new Class[0]);
                getTest.setAccessible(true);
                Test test = (Test)getTest.invoke((Object)junit3Runner, new Object[0]);
                if (test instanceof TestSuite) {
                    TestSuite testSuite = (TestSuite)test;
                    Enumeration testEnum = testSuite.tests();
                    while (testEnum.hasMoreElements()) {
                        Test t = (Test)testEnum.nextElement();
                        this.injectValues(t);
                    }
                } else {
                    this.injectValues(test);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(String.format("Failed to invoke junit3 runner: %s", junit3Runner.getClass().getName()), e);
            }
        }
        try {
            OptionSetter setter = new OptionSetter(new Object[]{runner});
            for (String kv : this.mKeyValueOptions) {
                setter.setOptionValue("set-option", kv);
            }
        }
        catch (ConfigurationException e) {
            LogUtil.CLog.d((String)"Could not set option set-option on '%s', reason: '%s'", (Object[])new Object[]{runner, e.getMessage()});
        }
        super.runChild(runner, notifier);
    }

    private void injectValues(Object testObj) {
        if (testObj instanceof IDeviceTest) {
            ((IDeviceTest)testObj).setDevice(this.mTestInfo.getDevice());
        }
        if (testObj instanceof IBuildReceiver) {
            ((IBuildReceiver)testObj).setBuild(this.mTestInfo.getBuildInfo());
        }
        if (testObj instanceof ITestInformationReceiver) {
            ((ITestInformationReceiver)testObj).setTestInformation(this.mTestInfo);
        }
        if (testObj instanceof IAbiReceiver) {
            ((IAbiReceiver)testObj).setAbi(this.mAbi);
        }
    }
}

