/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep.companion;

import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.device.DeviceSelectionOptions;
import com.android.tradefed.device.FreeDeviceState;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.device.IDeviceSelection;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.log.LogUtil;
import java.util.HashMap;
import java.util.Map;

public class CompanionDeviceTracker {
    private static CompanionDeviceTracker sInst = null;
    private Map<ITestDevice, ITestDevice> mDeviceMapping = new HashMap<ITestDevice, ITestDevice>();

    private CompanionDeviceTracker() {
    }

    public static CompanionDeviceTracker getInstance() {
        if (sInst == null) {
            sInst = new CompanionDeviceTracker();
        }
        return sInst;
    }

    public ITestDevice allocateCompanionDevice(ITestDevice device, DeviceSelectionOptions opt) {
        ITestDevice companion = this.getDeviceManager().allocateDevice((IDeviceSelection)opt, false);
        if (companion != null) {
            if (this.mDeviceMapping.containsKey(device)) {
                LogUtil.CLog.w((String)"device %s already has an allocated companion %s", (Object[])new Object[]{device.getSerialNumber(), this.mDeviceMapping.get(companion).getSerialNumber()});
            }
            LogUtil.CLog.i((String)"allocated companion device %s for primary device %s", (Object[])new Object[]{companion.getSerialNumber(), device.getSerialNumber()});
            this.mDeviceMapping.put(device, companion);
        }
        return companion;
    }

    public void freeCompanionDevice(ITestDevice device) {
        if (!this.mDeviceMapping.containsKey(device)) {
            LogUtil.CLog.w((String)"primary device %s has no tracked companion device", (Object[])new Object[]{device.getSerialNumber()});
            return;
        }
        ITestDevice companion = this.mDeviceMapping.remove(device);
        FreeDeviceState deviceState = FreeDeviceState.AVAILABLE;
        if (!TestDeviceState.ONLINE.equals((Object)companion.getDeviceState())) {
            deviceState = FreeDeviceState.UNAVAILABLE;
        }
        this.getDeviceManager().freeDevice(companion, deviceState);
        LogUtil.CLog.i((String)"freed companion device %s for primary device %s", (Object[])new Object[]{companion.getSerialNumber(), device.getSerialNumber()});
    }

    public ITestDevice getCompanionDevice(ITestDevice device) {
        return this.mDeviceMapping.get(device);
    }

    private IDeviceManager getDeviceManager() {
        return GlobalConfiguration.getDeviceManagerInstance();
    }
}

