/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep.adb;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.invoker.ExecutionFiles;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.io.File;
import java.io.IOException;

@OptionClass(alias="adb-stop-server-preparer")
public class AdbStopServerPreparer
extends BaseTargetPreparer {
    public static final String ADB_BINARY_KEY = "adb_path";
    @Option(name="restart-new-adb-version", description="Whether or not to restart adb with the new version after stopping it.")
    private boolean mRestartNewVersion = true;
    private static final long CMD_TIMEOUT = 60000L;
    private static final String ANDROID_HOST_OUT = "ANDROID_HOST_OUT";
    private IRunUtil mRunUtil;
    private File mTmpDir;

    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        IBuildInfo buildInfo = testInfo.getBuildInfo();
        this.getDeviceManager().stopAdbBridge();
        this.callAdbServerAndLog("kill-server", "Tradefed: AdbStopServerPreparer called kill-server\n");
        this.getRunUtil().sleep(2000L);
        if (!this.mRestartNewVersion) {
            LogUtil.CLog.d((String)"Skipping restarting of new adb version.");
            return;
        }
        File adb = null;
        if (this.getEnvironment(ANDROID_HOST_OUT) != null) {
            String hostOut = this.getEnvironment(ANDROID_HOST_OUT);
            adb = new File(hostOut, "bin/adb");
            if (adb.exists()) {
                adb.setExecutable(true);
            } else {
                adb = null;
            }
        }
        if (adb == null && buildInfo.getFile("adb") != null) {
            adb = buildInfo.getFile("adb");
            adb = this.renameAdbBinary(adb);
            testInfo.executionFiles().put(ExecutionFiles.FilesKey.ADB_BINARY, adb);
        }
        if (adb != null) {
            LogUtil.CLog.d((String)"Restarting adb from %s", (Object[])new Object[]{adb.getAbsolutePath()});
            IRunUtil restartAdb = this.createRunUtil();
            CommandResult result = restartAdb.runTimedCmd(60000L, new String[]{adb.getAbsolutePath(), "start-server"});
            if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
                throw new TargetSetupError(String.format("Failed to restart adb with the build info one. stdout: %s.\nsterr: %s", result.getStdout(), result.getStderr()), testInfo.getDevice().getDeviceDescriptor());
            }
        } else {
            this.callAdbServerAndLog("start-server", "Tradefed: AdbStopServerPreparer called start-server\n");
            throw new TargetSetupError("Could not find a new version of adb to tests.", testInfo.getDevice().getDeviceDescriptor());
        }
    }

    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        FileUtil.recursiveDelete((File)this.mTmpDir);
        this.callAdbServerAndLog("kill-server", "Tradefed: AdbStopServerPreparer called kill-server\n");
        CommandResult restart = this.getRunUtil().runTimedCmd(60000L, new String[]{"adb", "start-server"});
        LogUtil.CLog.d((String)"Restart adb -  stdout: %s\nstderr: %s", (Object[])new Object[]{restart.getStdout(), restart.getStderr()});
        this.getDeviceManager().restartAdbBridge();
    }

    IDeviceManager getDeviceManager() {
        return GlobalConfiguration.getDeviceManagerInstance();
    }

    IRunUtil createRunUtil() {
        return new RunUtil();
    }

    String getEnvironment(String key) {
        return System.getenv(key);
    }

    private IRunUtil getRunUtil() {
        if (this.mRunUtil == null) {
            this.mRunUtil = this.createRunUtil();
        }
        return this.mRunUtil;
    }

    private void callAdbServerAndLog(String command, String message) {
        this.getRunUtil().runTimedCmd(60000L, new String[]{"adb", command});
        File adbLog = this.findAdbLog();
        if (adbLog != null) {
            try {
                FileUtil.writeToFile((String)message, (File)adbLog, (boolean)true);
            }
            catch (IOException e) {
                LogUtil.CLog.e((Throwable)e);
            }
        }
    }

    private File renameAdbBinary(File originalAdb) {
        try {
            this.mTmpDir = FileUtil.createTempDir((String)"adb");
        }
        catch (IOException e) {
            LogUtil.CLog.e((String)"Cannot create temp directory");
            FileUtil.recursiveDelete((File)this.mTmpDir);
            return null;
        }
        File renamedAdbBinary = new File(this.mTmpDir, "adb");
        if (!originalAdb.renameTo(renamedAdbBinary)) {
            LogUtil.CLog.e((String)"Cannot rename adb binary");
            return null;
        }
        if (!renamedAdbBinary.setExecutable(true)) {
            LogUtil.CLog.e((String)"Cannot set adb binary executable");
            return null;
        }
        return renamedAdbBinary;
    }

    protected File findAdbLog() {
        CommandResult uidRes;
        String tmpDir = "/tmp";
        if (System.getenv("TMPDIR") != null) {
            tmpDir = System.getenv("TMPDIR");
        }
        if (!CommandStatus.SUCCESS.equals((Object)(uidRes = RunUtil.getDefault().runTimedCmd(60000L, new String[]{"id", "-u", System.getProperty("user.name")})).getStatus())) {
            LogUtil.CLog.e((String)"Failed to collect UID for adb logs: %s", (Object[])new Object[]{uidRes.getStderr()});
            return null;
        }
        String uid = uidRes.getStdout().trim();
        File adbLog = new File(tmpDir, String.format("adb.%s.log", uid));
        if (!adbLog.exists()) {
            LogUtil.CLog.i((String)"Did not find adb log file: %s, upload skipped.", (Object[])new Object[]{adbLog});
            return null;
        }
        return adbLog;
    }
}

