/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.TimeUtil;

@OptionClass(alias="wait-for-datetime")
public class WaitForDeviceDatetimePreparer
extends BaseTargetPreparer {
    private static final long DATETIME_WAIT_TIMEOUT = 30000L;
    private static final long DATETIME_CHECK_INTERVAL = 5000L;
    private static final long DATETIME_MARGIN = 10L;
    @Option(name="force-datetime", description="Force sync host datetime to device if device fails to set datetime automatically.")
    private boolean mForceDatetime = false;
    @Option(name="datetime-wait-timeout", description="Timeout in ms to wait for correct datetime on device.")
    private long mDatetimeWaitTimeout = 30000L;
    @Option(name="force-setup-error", description="Throw an TargetSetupError if correct datetime was not set. Only meaningful if \"force-datetime\" is not used.")
    private boolean mForceSetupError = false;

    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        if (!this.waitForDeviceDatetime(device, this.mForceDatetime)) {
            if (this.mForceSetupError) {
                throw new TargetSetupError(String.format("datetime on device is incorrect after wait timeout of '%s'", TimeUtil.formatElapsedTime((long)this.mDatetimeWaitTimeout)), device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
            }
            LogUtil.CLog.w((String)"datetime on device is incorrect after wait timeout.");
        }
    }

    public void setDatetimeWaitTimeout(long datetimeWaitTimeout) {
        this.mDatetimeWaitTimeout = datetimeWaitTimeout;
    }

    public void setForceDatetime(boolean forceDatetime) {
        this.mForceDatetime = forceDatetime;
    }

    public void setForceSetupError(boolean forceSetupError) {
        this.mForceSetupError = forceSetupError;
    }

    boolean waitForDeviceDatetime(ITestDevice device, boolean forceDatetime) throws DeviceNotAvailableException {
        return this.waitForDeviceDatetime(device, forceDatetime, this.mDatetimeWaitTimeout, 5000L);
    }

    boolean waitForDeviceDatetime(ITestDevice device, boolean forceDatetime, long datetimeWaitTimeout, long datetimeCheckInterval) throws DeviceNotAvailableException {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < datetimeWaitTimeout) {
            long datetime = this.getDeviceDatetimeEpoch(device);
            long now = System.currentTimeMillis() / 1000L;
            if (datetime == -1L) {
                if (forceDatetime) {
                    throw new UnsupportedOperationException("unexpected return from \"date\" command on device");
                }
                return false;
            }
            if (Math.abs(now - datetime) < 10L) {
                return true;
            }
            LogUtil.CLog.d((String)"device time: %s, host time: %s", (Object[])new Object[]{datetime, now});
            this.getRunUtil().sleep(datetimeCheckInterval);
        }
        if (forceDatetime) {
            device.setDate(null);
            return true;
        }
        return false;
    }

    long getDeviceDatetimeEpoch(ITestDevice device) throws DeviceNotAvailableException {
        String datetime = device.executeShellCommand("date '+%s'").trim();
        try {
            return Long.parseLong(datetime);
        }
        catch (NumberFormatException nfe) {
            LogUtil.CLog.v((String)"returned datetime from device is not a number: '%s'", (Object[])new Object[]{datetime});
            return -1L;
        }
    }

    protected IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }
}

