/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.IHostCleaner;
import com.android.tradefed.targetprep.ITargetPreparer;
import java.util.ArrayList;
import java.util.Collection;

public class TearDownPassThroughPreparer
extends BaseTargetPreparer
implements IConfigurationReceiver {
    private IConfiguration mConfiguration;
    @Option(name="preparer", description="names of preparers to tearDown")
    private Collection<String> mPreparers = new ArrayList<String>();

    public void setConfiguration(IConfiguration configuration) {
        this.mConfiguration = configuration;
    }

    public void setUp(TestInformation testInfo) {
    }

    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        for (String preparer : this.mPreparers) {
            ITargetPreparer cleaner;
            Object configObject = this.mConfiguration.getConfigurationObject(preparer);
            if (configObject instanceof ITargetPreparer) {
                cleaner = (ITargetPreparer)configObject;
                cleaner.tearDown(testInfo, e);
            }
            if (!(configObject instanceof IHostCleaner)) continue;
            cleaner = (IHostCleaner)configObject;
            cleaner.cleanUp(testInfo.getBuildInfo(), e);
        }
    }
}

