/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.host.IHostOptions;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestLoggerReceiver;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.TestErrorIdentifier;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.PythonVirtualenvHelper;
import com.android.tradefed.util.QuotationAwareTokenizer;
import com.android.tradefed.util.RunUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@OptionClass(alias="run-host-command")
public class RunHostCommandTargetPreparer
extends BaseTargetPreparer
implements ITestLoggerReceiver {
    private static final String DEVICE_SERIAL_PLACEHOLDER = "$SERIAL";
    private static final String EXTRA_FILE_PATTERSTRING = "\\$EXTRA_FILE\\(([^()]+)\\)";
    private static final String BG_COMMAND_LOG_PREFIX = "bg_command_log_";
    @Option(name="work-dir", description="Working directory to be used when running commands.")
    private File mWorkDir = null;
    @Option(name="host-setup-command", description="Command to be run before the test. Can be repeated. $SERIAL can be used as placeholder to be replaced with real device serial number at runtime.")
    private List<String> mSetUpCommands = new ArrayList<String>();
    @Option(name="host-teardown-command", description="Command to be run after the test. Can be repeated.")
    private List<String> mTearDownCommands = new ArrayList<String>();
    @Option(name="host-background-command", description="Background command to be run before the test. Can be repeated. They will be forced to terminate after the test. $SERIAL can be used as placeholder to be replaced with real device serial number at runtime.")
    private List<String> mBgCommands = new ArrayList<String>();
    @Option(name="host-cmd-timeout", description="Timeout for each command specified.")
    private Duration mTimeout = Duration.ofMinutes(1L);
    @Option(name="use-flashing-permit", description="Acquire a flashing permit before running commands.")
    private boolean mUseFlashingPermit = false;
    @Option(name="python-virtualenv", description="Activate existing python virtualenv created byPythonVirtualenvPreparer if set to True.Do not activate otherwise")
    private boolean mUseVenv = false;
    private List<Process> mBgProcesses = new ArrayList<Process>();
    private List<BgCommandLog> mBgCommandLogs = new ArrayList<BgCommandLog>();
    private ITestLogger mLogger;
    private IRunUtil mRunUtil;

    public void setTestLogger(ITestLogger testLogger) {
        this.mLogger = testLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        if (this.mWorkDir != null) {
            this.getRunUtil().setWorkingDir(this.mWorkDir);
        }
        ITestDevice device = testInfo.getDevice();
        IBuildInfo buildInfo = testInfo.getBuildInfo();
        if (this.mUseVenv) {
            File venvDir = buildInfo.getFile("VIRTUAL_ENV");
            if (venvDir != null && venvDir.exists()) {
                PythonVirtualenvHelper.activate(this.getRunUtil(), venvDir);
            } else {
                LogUtil.CLog.d((String)"No virtualenv configured.");
            }
        }
        this.replaceSerialNumber(this.mSetUpCommands, device);
        this.replaceExtraFile(this.mSetUpCommands, buildInfo);
        try {
            if (this.mUseFlashingPermit) {
                this.getHostOptions().takePermit(IHostOptions.PermitLimitType.CONCURRENT_FLASHER);
            }
            this.runCommandList(this.mSetUpCommands, device);
        }
        finally {
            if (this.mUseFlashingPermit) {
                this.getHostOptions().returnPermit(IHostOptions.PermitLimitType.CONCURRENT_FLASHER);
            }
        }
        try {
            this.mBgCommandLogs = this.createBgCommandLogs();
            this.replaceSerialNumber(this.mBgCommands, device);
            this.replaceExtraFile(this.mBgCommands, buildInfo);
            this.runBgCommandList(this.mBgCommands, this.mBgCommandLogs);
        }
        catch (IOException e) {
            throw new TargetSetupError(e.toString(), device.getDeviceDescriptor(), (ErrorIdentifier)TestErrorIdentifier.HOST_COMMAND_FAILED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        this.replaceSerialNumber(this.mTearDownCommands, device);
        this.replaceExtraFile(this.mTearDownCommands, testInfo.getBuildInfo());
        try {
            if (this.mUseFlashingPermit) {
                this.getHostOptions().takePermit(IHostOptions.PermitLimitType.CONCURRENT_FLASHER);
            }
            this.runCommandList(this.mTearDownCommands, device);
        }
        catch (TargetSetupError tse) {
            LogUtil.CLog.e((Throwable)tse);
        }
        finally {
            if (this.mUseFlashingPermit) {
                this.getHostOptions().returnPermit(IHostOptions.PermitLimitType.CONCURRENT_FLASHER);
            }
        }
        for (Process process : this.mBgProcesses) {
            process.destroy();
        }
        for (BgCommandLog log : this.mBgCommandLogs) {
            try {
                log.getOutputStream().close();
                this.mLogger.testLog(log.getName(), LogDataType.TEXT, log.getInputStreamSource());
                log.getInputStreamSource().close();
            }
            catch (IOException exception) {
                LogUtil.CLog.e((String)"Failed to close background command log output stream.", (Object[])new Object[]{exception});
            }
        }
    }

    private void runCommandList(List<String> commands, ITestDevice device) throws TargetSetupError {
        for (String command : commands) {
            CommandResult result = this.getRunUtil().runTimedCmd(this.mTimeout.toMillis(), QuotationAwareTokenizer.tokenizeLine((String)command));
            switch (result.getStatus()) {
                case SUCCESS: {
                    LogUtil.CLog.i((String)"Command %s finished successfully, stdout = [%s], stderr = [%s].", (Object[])new Object[]{command, result.getStdout(), result.getStderr()});
                    break;
                }
                case FAILED: {
                    throw new TargetSetupError(String.format("Command %s failed, stdout = [%s], stderr = [%s].", command, result.getStdout(), result.getStderr()), device.getDeviceDescriptor(), (ErrorIdentifier)TestErrorIdentifier.HOST_COMMAND_FAILED);
                }
                case TIMED_OUT: {
                    throw new TargetSetupError(String.format("Command %s timed out, stdout = [%s], stderr = [%s].", command, result.getStdout(), result.getStderr()), device.getDeviceDescriptor(), (ErrorIdentifier)TestErrorIdentifier.HOST_COMMAND_FAILED);
                }
                case EXCEPTION: {
                    throw new TargetSetupError(String.format("Exception occurred when running command %s, stdout = [%s], stderr = [%s].", command, result.getStdout(), result.getStderr()), device.getDeviceDescriptor(), (ErrorIdentifier)TestErrorIdentifier.HOST_COMMAND_FAILED);
                }
            }
        }
    }

    private void runBgCommandList(List<String> bgCommands, List<BgCommandLog> bgCommandLogs) throws IOException {
        for (int i = 0; i < bgCommands.size(); ++i) {
            String command = bgCommands.get(i);
            LogUtil.CLog.d((String)"About to run host background command: %s", (Object[])new Object[]{command});
            Process process = this.getRunUtil().runCmdInBackground(List.of(QuotationAwareTokenizer.tokenizeLine((String)command)), bgCommandLogs.get(i).getOutputStream());
            if (process == null) {
                LogUtil.CLog.e((String)"Failed to run command: %s", (Object[])new Object[]{command});
                continue;
            }
            this.mBgProcesses.add(process);
        }
    }

    private void replaceSerialNumber(List<String> commands, ITestDevice device) {
        for (int i = 0; i < commands.size(); ++i) {
            String command = commands.get(i).replace(DEVICE_SERIAL_PLACEHOLDER, device.getSerialNumber());
            commands.set(i, command);
        }
    }

    private void replaceExtraFile(List<String> commands, IBuildInfo buildInfo) {
        Pattern pattern = Pattern.compile(EXTRA_FILE_PATTERSTRING);
        for (int i = 0; i < commands.size(); ++i) {
            Matcher matcher = pattern.matcher(commands.get(i));
            StringBuffer command = new StringBuffer();
            while (matcher.find()) {
                String fileName = matcher.group(1);
                File file = buildInfo.getFile(fileName);
                if (file == null || !file.exists()) continue;
                matcher.appendReplacement(command, file.getPath());
            }
            matcher.appendTail(command);
            commands.set(i, command.toString());
        }
    }

    @VisibleForTesting
    IRunUtil getRunUtil() {
        if (this.mRunUtil == null) {
            this.mRunUtil = new RunUtil();
        }
        return this.mRunUtil;
    }

    @VisibleForTesting
    IHostOptions getHostOptions() {
        return GlobalConfiguration.getInstance().getHostOptions();
    }

    @VisibleForTesting
    List<BgCommandLog> createBgCommandLogs() throws IOException {
        ArrayList<BgCommandLog> bgCommandLogs = new ArrayList<BgCommandLog>();
        for (String command : this.mBgCommands) {
            File file = FileUtil.createTempFile((String)BG_COMMAND_LOG_PREFIX, (String)".txt");
            LogUtil.CLog.d((String)"Redirect output to %s for command: %s", (Object[])new Object[]{file.getAbsolutePath(), command});
            bgCommandLogs.add(new BgCommandFileLog(file));
        }
        return bgCommandLogs;
    }

    @VisibleForTesting
    static interface BgCommandLog {
        public OutputStream getOutputStream();

        public InputStreamSource getInputStreamSource();

        public String getName();
    }

    private static class BgCommandFileLog
    implements BgCommandLog {
        private File mFile;
        private OutputStream mOutputStream;
        private InputStreamSource mInputStreamSource;

        public BgCommandFileLog(File file) throws IOException {
            this.mFile = file;
            this.mOutputStream = new FileOutputStream(this.mFile);
            this.mInputStreamSource = new FileInputStreamSource(file, true);
        }

        @Override
        public OutputStream getOutputStream() {
            return this.mOutputStream;
        }

        @Override
        public InputStreamSource getInputStreamSource() {
            return this.mInputStreamSource;
        }

        @Override
        public String getName() {
            return this.mFile.getName();
        }
    }
}

