/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;

@OptionClass(alias="rootcanal")
public class RootcanalForwarderPreparer
extends BaseTargetPreparer {
    @Option(name="hci-port", description="Rootcanal HCI port")
    private String mHciPort = "vsock:2:7300";
    @Option(name="control-port", description="Rootcanal control port")
    private String mControlPort = "vsock:2:7500";
    private static final String ROOTCANAL_HCI_ADDRESS = "ROOTCANAL_HCI_ADDRESS";
    private static final String ROOTCANAL_CONTROL_ADDRESS = "ROOTCANAL_CONTROL_ADDRESS";
    private String mHostHciRootcanalPort = "";
    private String mHostControlRootcanalPort = "";

    public void setUp(TestInformation testInformation) throws TargetSetupError {
        testInformation.properties().put(ROOTCANAL_HCI_ADDRESS, "");
        testInformation.properties().put(ROOTCANAL_CONTROL_ADDRESS, "");
        if (this.isDisabled()) {
            LogUtil.CLog.i((String)"Skipping RootcanalForwarderPreparer setup");
            return;
        }
        try {
            ITestDevice testDevice = testInformation.getDevice();
            this.mHostHciRootcanalPort = this.adbForward(testDevice, this.mHciPort);
            this.mHostControlRootcanalPort = this.adbForward(testDevice, this.mControlPort);
            testInformation.properties().put(ROOTCANAL_HCI_ADDRESS, "localhost:" + this.mHostHciRootcanalPort);
            testInformation.properties().put(ROOTCANAL_CONTROL_ADDRESS, "localhost:" + this.mHostControlRootcanalPort);
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.e((String)"Unable to forward Rootcanal ports: %s", (Object[])new Object[]{e.getMessage()});
        }
    }

    public void tearDown(TestInformation testInformation, Throwable t) {
        testInformation.properties().remove(ROOTCANAL_HCI_ADDRESS);
        testInformation.properties().remove(ROOTCANAL_CONTROL_ADDRESS);
        if (this.isTearDownDisabled()) {
            LogUtil.CLog.i((String)"Skipping RootcanalForwarderPreparer teardown");
            return;
        }
        try {
            ITestDevice testDevice = testInformation.getDevice();
            if (!this.mHostHciRootcanalPort.isEmpty()) {
                this.adbForwardRemove(testDevice, this.mHostHciRootcanalPort);
            }
            if (!this.mHostControlRootcanalPort.isEmpty()) {
                this.adbForwardRemove(testDevice, this.mHostControlRootcanalPort);
            }
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.e((String)"Unable to remove Rootcanal ports forwarding: %s", (Object[])new Object[]{e.getMessage()});
        }
    }

    private String adbForward(ITestDevice testDevice, String port) throws DeviceNotAvailableException {
        String hostPort = testDevice.executeAdbCommand(new String[]{"forward", "tcp:0", port}).trim();
        LogUtil.CLog.i((String)"Forwarded %s to host tcp:%s", (Object[])new Object[]{port, hostPort});
        return hostPort;
    }

    private void adbForwardRemove(ITestDevice testDevice, String hostPort) throws DeviceNotAvailableException {
        LogUtil.CLog.i((String)"Removing host tcp:%s forwarding", (Object[])new Object[]{hostPort});
        testDevice.executeAdbCommand(new String[]{"forward", "--remove", String.format("tcp:%s", hostPort)});
    }
}

