/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;

@OptionClass(alias="restart-system-server")
public class RestartSystemServerTargetPreparer
extends BaseTargetPreparer {
    @Option(name="restart-setup", description="Restart system server on setup.")
    private boolean mRestartBefore = true;
    @Option(name="restart-teardown", description="Restart system server on tear down.")
    private boolean mRestartAfter = false;
    static final String KILL_SERVER_COMMAND = "pkill system_server";

    private void restartSystemServer(ITestDevice device) throws DeviceNotAvailableException {
        device.enableAdbRoot();
        device.executeShellCommand("setprop dev.bootcomplete 0");
        device.executeShellCommand(KILL_SERVER_COMMAND);
        device.waitForDeviceAvailable();
    }

    public void setUp(TestInformation testInformation) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        if (!this.mRestartBefore) {
            return;
        }
        this.restartSystemServer(testInformation.getDevice());
    }

    public void tearDown(TestInformation testInformation, Throwable e) throws DeviceNotAvailableException {
        if (!this.mRestartAfter) {
            return;
        }
        this.restartSystemServer(testInformation.getDevice());
    }
}

