/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.BuildInfoKey;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.command.remote.DeviceDescriptor;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.observatory.IDiscoverDependencies;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IAbiReceiver;
import com.android.tradefed.testtype.IInvocationContextReceiver;
import com.android.tradefed.util.AbiUtils;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.MultiMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

@OptionClass(alias="push-file")
public class PushFilePreparer
extends BaseTargetPreparer
implements IAbiReceiver,
IInvocationContextReceiver,
IDiscoverDependencies {
    private static final String MEDIA_SCAN_INTENT = "am broadcast -a android.intent.action.MEDIA_MOUNTED -d file://%s --receiver-include-background";
    private IAbi mAbi;
    @Deprecated
    @Option(name="push", description="Deprecated. Please use push-file instead. A push-spec, formatted as '/localpath/to/srcfile.txt->/devicepath/to/destfile.txt' or '/localpath/to/srcfile.txt->/devicepath/to/destdir/'. May be repeated. The local path may be relative to the test cases build out directories ($ANDROID_HOST_OUT_TESTCASES / $ANDROID_TARGET_OUT_TESTCASES).")
    private Collection<String> mPushSpecs = new ArrayList<String>();
    @Option(name="push-file", description="A push-spec, specifying the local file to the path where it should be pushed on device. May be repeated. If multiple files are configured to be pushed to the same remote path, the latest one will be pushed.")
    private MultiMap<File, String> mPushFileSpecs = new MultiMap();
    @Option(name="skip-abi-filtering", description="A bool to indicate we should or shouldn't skip files that match the architecture string name, e.g. x86, x86_64, arm64-v8. This is necessary when file or folder names match an architecture version but still need to be pushed to the device.")
    private boolean mSkipAbiFiltering = false;
    @Option(name="backup-file", description="A key/value pair, the with key specifying a device file path to be backed up, and the value a device file path indicating where to save the file. During tear-down, the values will be executed in reverse, restoring the backup file location to the initial location. May be repeated.")
    private Map<String, String> mBackupFileSpecs = new LinkedHashMap<String, String>();
    @Option(name="post-push", description="A command to run on the device (with `adb shell (yourcommand)`) after all pushes have been attempted.  Will not be run if a push fails with abort-on-push-failure enabled.  May be repeated.")
    private Collection<String> mPostPushCommands = new ArrayList<String>();
    @Option(name="abort-on-push-failure", description="If false, continue if pushes fail.  If true, abort the Invocation on any failure.")
    private boolean mAbortOnFailure = true;
    @Option(name="trigger-media-scan", description="After pushing files, trigger a media scan of external storage on device.")
    private boolean mTriggerMediaScan = false;
    @Option(name="cleanup", description="Whether files pushed onto device should be cleaned up after test. Note that the preparer does not verify that files/directories have been deleted.")
    private boolean mCleanup = true;
    @Option(name="remount-system", description="Remounts system partition to be writable so that files could be pushed there too")
    private boolean mRemountSystem = false;
    @Option(name="remount-vendor", description="Remounts vendor partition to be writable so that files could be pushed there too")
    private boolean mRemountVendor = false;
    private Set<String> mFilesPushed = null;
    private String mModuleName = null;

    private void fail(String message, DeviceDescriptor descriptor, ErrorIdentifier identifier) throws TargetSetupError {
        if (this.shouldAbortOnFailure()) {
            throw new TargetSetupError(message, descriptor, identifier);
        }
        LogUtil.CLog.w((String)message);
    }

    public final Map<String, File> getPushSpecs(ITestDevice device) throws TargetSetupError {
        LinkedHashMap<String, File> remoteToLocalMapping = new LinkedHashMap<String, File>();
        for (String pushspec : this.mPushSpecs) {
            String[] pair = pushspec.split("->");
            if (pair.length != 2) {
                this.fail(String.format("Invalid pushspec: '%s'", Arrays.asList(pair)), device.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
                continue;
            }
            remoteToLocalMapping.put(pair[1], new File(pair[0]));
        }
        for (File local : this.mPushFileSpecs.keySet()) {
            for (String remoteLocation : this.mPushFileSpecs.get((Object)local)) {
                remoteToLocalMapping.put(remoteLocation, local);
            }
        }
        return remoteToLocalMapping;
    }

    public boolean shouldAbortOnFailure() {
        return this.mAbortOnFailure;
    }

    public void setAbi(IAbi abi) {
        this.mAbi = abi;
    }

    public IAbi getAbi() {
        return this.mAbi;
    }

    public void setInvocationContext(IInvocationContext invocationContext) {
        if (invocationContext.getAttributes().get((Object)"module-name") != null) {
            this.mModuleName = (String)invocationContext.getAttributes().get((Object)"module-name").get(0);
        }
    }

    public File resolveRelativeFilePath(IBuildInfo buildInfo, String fileName) {
        File src = null;
        if (buildInfo != null && (src = buildInfo.getFile(fileName)) != null && src.exists()) {
            return src;
        }
        if (buildInfo instanceof IDeviceBuildInfo) {
            File srcWithAbi;
            IDeviceBuildInfo deviceBuild = (IDeviceBuildInfo)buildInfo;
            File testDir = deviceBuild.getTestsDir();
            ArrayList<File> scanDirs = new ArrayList<File>();
            File targetTestCases = deviceBuild.getFile(BuildInfoKey.BuildInfoFileKey.TARGET_LINKED_DIR);
            if (targetTestCases != null) {
                scanDirs.add(targetTestCases);
            }
            if (testDir != null) {
                scanDirs.add(testDir);
            }
            if (this.mModuleName != null && testDir != null) {
                try {
                    File moduleDir = FileUtil.findDirectory((String)this.mModuleName, (File[])scanDirs.toArray(new File[0]));
                    if (moduleDir != null) {
                        if (this.mModuleName.equals(fileName)) {
                            return moduleDir;
                        }
                        src = FileUtil.findFile((String)fileName, null, (File[])new File[]{moduleDir});
                        if (src != null) {
                            File srcWithAbi2 = FileUtil.findFile((String)fileName, (IAbi)this.mAbi, (File[])new File[]{moduleDir});
                            if (srcWithAbi2 != null && !srcWithAbi2.getAbsolutePath().startsWith(src.getAbsolutePath())) {
                                return srcWithAbi2;
                            }
                            return src;
                        }
                    } else {
                        LogUtil.CLog.d((String)"Did not find any module directory for '%s'", (Object[])new Object[]{this.mModuleName});
                    }
                }
                catch (IOException e) {
                    LogUtil.CLog.w((String)"Something went wrong while searching for the module '%s' directory.", (Object[])new Object[]{this.mModuleName});
                }
            }
            for (File searchDir : scanDirs) {
                try {
                    Set allMatch = FileUtil.findFilesObject((File)searchDir, (String)fileName);
                    if (allMatch.size() > 1) {
                        LogUtil.CLog.d((String)"Several match for filename '%s', searching for top-level match.", (Object[])new Object[]{fileName});
                        for (File f : allMatch) {
                            if (!f.getParent().equals(searchDir.getAbsolutePath())) continue;
                            return f;
                        }
                        continue;
                    }
                    if (allMatch.size() != 1) continue;
                    return (File)allMatch.iterator().next();
                }
                catch (IOException e) {
                    LogUtil.CLog.w((String)"Failed to find test files from directory.");
                }
            }
            try {
                src = FileUtil.findFile((String)fileName, null, (File[])scanDirs.toArray(new File[0]));
                if (src != null) {
                    srcWithAbi = FileUtil.findFile((String)fileName, (IAbi)this.mAbi, (File[])scanDirs.toArray(new File[0]));
                    if (srcWithAbi != null && !srcWithAbi.getAbsolutePath().startsWith(src.getAbsolutePath())) {
                        return srcWithAbi;
                    }
                    return src;
                }
            }
            catch (IOException e) {
                LogUtil.CLog.w((String)"Failed to find test files from directory.");
                src = null;
            }
            if (src == null && testDir != null && (src = buildInfo.stageRemoteFile(fileName, testDir)) != null) {
                InvocationMetricLogger.addInvocationMetrics((InvocationMetricLogger.InvocationMetricKey)InvocationMetricLogger.InvocationMetricKey.STAGE_UNDEFINED_DEPENDENCY, (String)fileName);
                try {
                    srcWithAbi = FileUtil.findFile((String)fileName, (IAbi)this.mAbi, (File[])new File[]{testDir});
                    if (srcWithAbi != null && !srcWithAbi.getAbsolutePath().startsWith(src.getAbsolutePath())) {
                        return srcWithAbi;
                    }
                }
                catch (IOException e) {
                    LogUtil.CLog.w((String)"Failed to find test files with matching ABI from directory.");
                }
            }
        }
        return src;
    }

    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        this.mFilesPushed = new HashSet<String>();
        ITestDevice device = testInfo.getDevice();
        if (this.mRemountSystem) {
            device.remountSystemWritable();
        }
        if (this.mRemountVendor) {
            device.remountVendorWritable();
        }
        for (Map.Entry<String, String> entry : this.mBackupFileSpecs.entrySet()) {
            device.executeShellCommand("mv \"" + entry.getKey() + "\" \"" + entry.getValue() + "\"");
        }
        Map<String, File> remoteToLocalMapping = this.getPushSpecs(device);
        for (String remotePath : remoteToLocalMapping.keySet()) {
            File local = remoteToLocalMapping.get(remotePath);
            LogUtil.CLog.d((String)"Trying to push local '%s' to remote '%s'", (Object[])new Object[]{local.getPath(), remotePath});
            this.evaluatePushingPair(device, testInfo.getBuildInfo(), local, remotePath);
        }
        for (String command : this.mPostPushCommands) {
            device.executeShellCommand(command);
        }
        if (this.mTriggerMediaScan) {
            String string = device.getMountPoint("EXTERNAL_STORAGE");
            device.executeShellCommand(String.format(MEDIA_SCAN_INTENT, string));
        }
    }

    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        if (!(e instanceof DeviceNotAvailableException) && this.mCleanup && this.mFilesPushed != null) {
            if (this.mRemountSystem) {
                device.remountSystemReadOnly();
            }
            if (this.mRemountVendor) {
                device.remountVendorReadOnly();
            }
            for (String string : this.mFilesPushed) {
                device.deleteFile(string);
            }
            for (Map.Entry entry : this.mBackupFileSpecs.entrySet()) {
                device.executeShellCommand("mv \"" + (String)entry.getValue() + "\" \"" + (String)entry.getKey() + "\"");
            }
        }
    }

    private void evaluatePushingPair(ITestDevice device, IBuildInfo buildInfo, File src, String remotePath) throws TargetSetupError, DeviceNotAvailableException {
        String localPath = src.getPath();
        if (!src.isAbsolute()) {
            src = this.resolveRelativeFilePath(buildInfo, localPath);
        }
        if (src == null || !src.exists()) {
            this.fail(String.format("Local source file '%s' does not exist", localPath), device.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.CONFIGURED_ARTIFACT_NOT_FOUND);
            return;
        }
        if (src.isDirectory()) {
            boolean deleteContentOnly = true;
            if (!device.doesFileExist(remotePath)) {
                device.executeShellCommand(String.format("mkdir -p \"%s\"", remotePath));
                deleteContentOnly = false;
            } else if (!device.isDirectory(remotePath)) {
                throw new TargetSetupError(String.format("Attempting to push dir '%s' to an existing device file '%s'", src.getAbsolutePath(), remotePath), device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.FAIL_PUSH_FILE);
            }
            HashSet filter = new HashSet();
            if (this.mAbi != null && !this.mSkipAbiFiltering) {
                String currentArch = AbiUtils.getArchForAbi((String)this.mAbi.getName());
                filter.addAll(AbiUtils.getArchSupported());
                filter.remove(currentArch);
            }
            if (!device.pushDir(src, remotePath, filter)) {
                this.fail(String.format("Failed to push local '%s' to remote '%s'", localPath, remotePath), device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.FAIL_PUSH_FILE);
                return;
            }
            if (deleteContentOnly) {
                remotePath = remotePath + "/*";
            }
            this.mFilesPushed.add(remotePath);
        } else {
            if (!device.pushFile(src, remotePath)) {
                this.fail(String.format("Failed to push local '%s' to remote '%s'", localPath, remotePath), device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.FAIL_PUSH_FILE);
                return;
            }
            this.mFilesPushed.add(remotePath);
        }
    }

    public Set<String> reportDependencies() {
        HashSet<String> deps = new HashSet<String>();
        try {
            for (File f : this.getPushSpecs(null).values()) {
                if (!f.isAbsolute()) {
                    deps.add(f.getName());
                    continue;
                }
                LogUtil.CLog.d((String)"%s detected as existing. Not reported as dependency.", (Object[])new Object[]{f.getAbsolutePath()});
            }
        }
        catch (TargetSetupError e) {
            LogUtil.CLog.e((Throwable)e);
        }
        return deps;
    }

    public boolean shouldRemountSystem() {
        return this.mRemountSystem;
    }

    public boolean shouldRemountVendor() {
        return this.mRemountVendor;
    }

    public boolean isCleanUpEnabled() {
        return this.mCleanup;
    }
}

