/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.error.IHarnessException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import java.util.HashSet;
import java.util.Set;

@OptionClass(alias="known-failure-preparer")
public class KnownFailurePreparer
extends BaseTargetPreparer
implements IConfigurationReceiver {
    @Option(name="known-failure-list", description="A collection of known failing tests to skip retrying.")
    private Set<String> mKnownFailureList = new HashSet<String>();
    private IConfiguration mConfig;
    private static final String SKIP_RETRYING_LIST = "skip-retrying-list";

    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        if (!this.mKnownFailureList.isEmpty()) {
            try {
                for (String knownFailureModule : this.mKnownFailureList) {
                    this.mConfig.injectOptionValue(SKIP_RETRYING_LIST, knownFailureModule);
                }
            }
            catch (ConfigurationException e) {
                throw new HarnessRuntimeException(e.getMessage(), (IHarnessException)e);
            }
        }
    }

    public void setConfiguration(IConfiguration configuration) {
        this.mConfig = configuration;
    }
}

