/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.DefaultTestsZipInstaller;
import com.android.tradefed.targetprep.ITestsZipInstaller;
import com.android.tradefed.targetprep.TargetSetupError;
import java.util.ArrayList;
import java.util.Collection;

@OptionClass(alias="erase-user-data")
public class EraseUserDataPreparer
extends BaseTargetPreparer {
    @Option(name="wipe-skip-list", description="list of /data subdirectories to NOT wipe when doing UserDataFlashOption.TESTS_ZIP")
    private Collection<String> mDataWipeSkipList = new ArrayList<String>();
    @Option(name="wait-for-available", description="Wait until device is available for testing before performing erase")
    private boolean mWaitForAvailable = false;
    private ITestsZipInstaller mTestsZipInstaller = null;

    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        if (this.isDisabled()) {
            return;
        }
        ITestDevice device = testInfo.getDevice();
        if (this.mWaitForAvailable) {
            device.waitForDeviceAvailable();
        }
        device.enableAdbRoot();
        if (this.mTestsZipInstaller == null) {
            if (this.mDataWipeSkipList.isEmpty()) {
                this.mDataWipeSkipList.add("media");
            }
            this.mTestsZipInstaller = new DefaultTestsZipInstaller(this.mDataWipeSkipList);
        }
        this.mTestsZipInstaller.deleteData(device);
        device.reboot();
    }
}

