/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;

@OptionClass(alias="device-wiper")
public class DeviceWiper
extends BaseTargetPreparer {
    @Deprecated
    @Option(name="use-erase", description="Deprecated. Please use mode instead. Instruct wiper to use fastboot erase instead of format.")
    protected boolean mUseErase = false;
    @Option(name="mode", description="Determines how to wipes userdata. Default: FORMAT")
    private Mode mMode = Mode.FORMAT;

    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        LogUtil.CLog.i((String)"Wiping device");
        if (this.mMode.equals((Object)Mode.FORMAT) && this.mUseErase) {
            this.mMode = Mode.ERASE;
        }
        switch (this.mMode) {
            case FORMAT: {
                this.doFormat(device);
                break;
            }
            case ERASE: {
                this.doErase(device);
                break;
            }
            case FACTORY_RESET: {
                this.doFactoryReset(device);
            }
        }
        device.waitForDeviceAvailable();
    }

    private void doFormat(ITestDevice device) throws DeviceNotAvailableException, TargetSetupError {
        try {
            device.rebootIntoBootloader();
            LogUtil.CLog.d((String)"Attempting fastboot wiping");
            CommandResult r = device.executeLongFastbootCommand(new String[]{"-w"});
            if (r.getStatus() != CommandStatus.SUCCESS) {
                throw new TargetSetupError(String.format("fastboot wiping failed: %s", r.getStderr()), device.getDeviceDescriptor());
            }
        }
        catch (Throwable throwable) {
            device.executeFastbootCommand(new String[]{"reboot"});
            throw throwable;
        }
        device.executeFastbootCommand(new String[]{"reboot"});
    }

    private void doErase(ITestDevice device) throws DeviceNotAvailableException, TargetSetupError {
        try {
            device.rebootIntoBootloader();
            this.performFastbootOp(device, "erase", "cache");
            this.performFastbootOp(device, "erase", "userdata");
        }
        catch (Throwable throwable) {
            device.executeFastbootCommand(new String[]{"reboot"});
            throw throwable;
        }
        device.executeFastbootCommand(new String[]{"reboot"});
    }

    private void performFastbootOp(ITestDevice device, String op, String partition) throws DeviceNotAvailableException, TargetSetupError {
        LogUtil.CLog.d((String)"Attempting fastboot %s %s", (Object[])new Object[]{op, partition});
        CommandResult r = device.executeLongFastbootCommand(new String[]{op, partition});
        if (r.getStatus() != CommandStatus.SUCCESS) {
            throw new TargetSetupError(String.format("%s %s failed: %s", op, partition, r.getStderr()), device.getDeviceDescriptor());
        }
    }

    private void doFactoryReset(ITestDevice device) throws DeviceNotAvailableException, TargetSetupError {
        if (!device.enableAdbRoot()) {
            throw new TargetSetupError("Unable to do factory reset because adb root failed", device.getDeviceDescriptor());
        }
        CommandResult r = device.executeShellV2Command("am broadcast -p android --receiver-foreground -a android.intent.action.FACTORY_RESET");
        if (r.getStatus() != CommandStatus.SUCCESS) {
            throw new TargetSetupError(String.format("factory reset failed: %s", r.getStderr()), device.getDeviceDescriptor());
        }
        device.waitForDeviceNotAvailable(30000L);
    }

    private static enum Mode {
        FORMAT,
        ERASE,
        FACTORY_RESET;

    }
}

