/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.RunUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@OptionClass(alias="cpu-throttle-waiter")
public class CpuThrottlingWaiter
extends BaseTargetPreparer {
    @Option(name="poll-interval", description="Interval in seconds, to poll for core frequencies; defaults to 5s")
    private long mPollIntervalSecs = 5L;
    @Option(name="max-wait", description="Max wait time in seconds, for all cores to be free of throttling; defaults to 240s")
    private long mMaxWaitSecs = 240L;
    @Option(name="post-idle-wait", description="Additional time to wait in seconds, after cores are no longer subject to throttling; defaults to 120s")
    private long mPostIdleWaitSecs = 120L;
    @Option(name="abort-on-timeout", description="If test should be aborted if cores are still subject to throttling after timeout has reached; defaults to false")
    private boolean mAbortOnTimeout = false;

    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        Map<String, String> cpuMaxFreqs = this.getCpuMaxFreqs(device);
        if (cpuMaxFreqs.isEmpty()) {
            LogUtil.CLog.i((String)"Unable to determine cores available, falling back to max wait time");
            RunUtil.getDefault().sleep(this.mMaxWaitSecs * 1000L);
            return;
        }
        long start = System.currentTimeMillis();
        long maxWaitMs = this.mMaxWaitSecs * 1000L;
        long intervalMs = this.mPollIntervalSecs * 1000L;
        while (true) {
            boolean ready = true;
            for (Map.Entry<String, String> e : cpuMaxFreqs.entrySet()) {
                String freq = device.executeShellCommand(String.format("cat %s/cpuinfo_max_freq", e.getKey())).trim();
                if (e.getValue().equals(freq)) continue;
                LogUtil.CLog.d((String)"CPU %s not ready: %s/%s", (Object[])new Object[]{e.getKey(), freq, e.getValue()});
                ready = false;
                break;
            }
            if (ready) break;
            if (System.currentTimeMillis() - start > maxWaitMs) {
                LogUtil.CLog.w((String)"cores still throttled after %ds", (Object[])new Object[]{maxWaitMs});
                String result = device.executeShellCommand("cat /sys/devices/system/cpu/*/cpufreq/cpuinfo_max_freq");
                LogUtil.CLog.w((String)"Current CPU frequencies:\n%s", (Object[])new Object[]{result});
                if (!this.mAbortOnTimeout) break;
                throw new TargetSetupError("cores are still throttled after wait timeout", device.getDeviceDescriptor());
            }
            RunUtil.getDefault().sleep(intervalMs);
        }
        RunUtil.getDefault().sleep(this.mPostIdleWaitSecs * 1000L);
        LogUtil.CLog.i((String)"Done waiting, total time elapsed: %ds", (Object[])new Object[]{(System.currentTimeMillis() - start) / 1000L});
    }

    protected Map<String, String> getCpuMaxFreqs(ITestDevice device) throws DeviceNotAvailableException {
        HashMap<String, String> ret = new HashMap<String, String>();
        String result = device.executeShellCommand("ls -1 -d /sys/devices/system/cpu/cpu*/cpufreq");
        String[] lines = result.split("\r?\n");
        ArrayList<String> cpuPaths = new ArrayList<String>();
        for (String line : lines) {
            cpuPaths.add(line.trim());
        }
        for (String cpu : cpuPaths) {
            result = device.executeShellCommand(String.format("cat %s/scaling_available_frequencies", cpu)).trim();
            String[] freqs = result.split("\\s+");
            String maxFreq = freqs[freqs.length - 1];
            if (!maxFreq.matches("^\\d+$")) {
                LogUtil.CLog.w((String)"Unable to determine max frequency available for CPU: %s", (Object[])new Object[]{cpu});
                continue;
            }
            LogUtil.CLog.d((String)"CPU: %s  MaxFreq: %s", (Object[])new Object[]{cpu, maxFreq});
            ret.put(cpu, maxFreq);
        }
        return ret;
    }
}

