/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.VersionedFile;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.CollectingOutputReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.AaptParser;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@OptionClass(alias="app-setup")
public class AppSetup
extends BaseTargetPreparer {
    @Option(name="reboot", description="reboot device after running tests.")
    private boolean mReboot = true;
    @Option(name="install", description="install all apks in build.")
    private boolean mInstall = true;
    @Option(name="uninstall", description="uninstall only apks in build after test completes.")
    private boolean mUninstall = true;
    @Option(name="uninstall-all", description="uninstall all unnstallable apks found on device after test completes.")
    private boolean mUninstallAll = false;
    @Option(name="skip-uninstall-pkg", description="force retention of this package when --uninstall-all is set.")
    private Set<String> mSkipUninstallPkgs = new HashSet<String>();
    @Option(name="install-arg", description="optional flag(s) to provide when installing apks.")
    private ArrayList<String> mInstallArgs = new ArrayList();
    @Option(name="force-queryable", description="Whether apks should be installed as force queryable.")
    private Boolean mForceQueryable = null;
    @Option(name="post-install-cmd", description="optional post-install adb shell commands; can be repeated.")
    private List<String> mPostInstallCmds = new ArrayList<String>();
    @Option(name="post-install-cmd-timeout", description="max time allowed in ms for a post-install adb shell command.DeviceUnresponsiveException will be thrown if it is timed out.")
    private long mPostInstallCmdTimeout = 120000L;
    @Option(name="check-min-sdk", description="check app's min sdk prior to install and skip if device api level is too low.")
    private boolean mCheckMinSdk = false;
    private Set<String> mInstalledPkgs = new HashSet<String>();

    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, DeviceNotAvailableException, BuildError {
        List apps = buildInfo.getAppPackageFiles();
        if (apps.isEmpty()) {
            return;
        }
        LogUtil.CLog.i((String)"Performing setup on %s", (Object[])new Object[]{device.getSerialNumber()});
        if (this.mUninstallAll && !this.uninstallAllApps(device)) {
            throw new DeviceNotAvailableException(String.format("Failed to uninstall apps on %s", device.getSerialNumber()), device.getSerialNumber());
        }
        if (this.mInstall) {
            if (this.mForceQueryable == null) {
                this.mForceQueryable = !device.checkApiLevelAgainstNextRelease(34) || "TM".equals(device.getBuildAlias());
            }
            if (this.mForceQueryable.booleanValue() && device.isAppEnumerationSupported()) {
                this.mInstallArgs.add("--force-queryable");
            }
            for (VersionedFile apkFile : apps) {
                if (this.mCheckMinSdk) {
                    AaptParser aaptParser = this.doAaptParse(apkFile.getFile());
                    if (aaptParser == null) {
                        throw new TargetSetupError(String.format("Failed to extract info from '%s' using aapt", apkFile.getFile().getName()), device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.AAPT_PARSER_FAILED);
                    }
                    if (device.getApiLevel() < aaptParser.getSdkVersion()) {
                        LogUtil.CLog.w((String)"Skipping installing apk %s on device %s because SDK level require is %d, but device SDK level is %d", (Object[])new Object[]{apkFile.toString(), device.getSerialNumber(), aaptParser.getSdkVersion(), device.getApiLevel()});
                        continue;
                    }
                }
                ArrayList<String> args = new ArrayList<String>(this.mInstallArgs);
                String result = device.installPackage(apkFile.getFile(), true, args.toArray(new String[args.size()]));
                if (result != null) {
                    throw new BuildError(String.format("Failed to install %s on %s. Reason: %s", apkFile.getFile().getName(), device.getSerialNumber(), result), device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.APK_INSTALLATION_FAILED);
                }
                if (!this.mUninstall || this.mUninstallAll) continue;
                this.addPackageNameToUninstall(apkFile.getFile(), device);
            }
        }
        if (!this.mPostInstallCmds.isEmpty()) {
            for (String cmd : this.mPostInstallCmds) {
                LogUtil.CLog.d((String)"About to run setup command on device %s: %s", (Object[])new Object[]{device.getSerialNumber(), cmd});
                device.executeShellCommand(cmd, (IShellOutputReceiver)new CollectingOutputReceiver(), this.mPostInstallCmdTimeout, TimeUnit.MILLISECONDS, 1);
            }
        }
    }

    @VisibleForTesting
    AaptParser doAaptParse(File apkFile) {
        return AaptParser.parse((File)apkFile);
    }

    private void addPackageNameToUninstall(File apkFile, ITestDevice device) throws TargetSetupError {
        AaptParser aaptParser = this.doAaptParse(apkFile);
        if (aaptParser == null) {
            throw new TargetSetupError(String.format("Failed to extract info from '%s' using aapt", apkFile.getAbsolutePath()), device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.AAPT_PARSER_FAILED);
        }
        if (aaptParser.getPackageName() == null) {
            throw new TargetSetupError(String.format("Failed to find package name for '%s' using aapt", apkFile.getAbsolutePath()), device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.AAPT_PARSER_FAILED);
        }
        this.mInstalledPkgs.add(aaptParser.getPackageName());
    }

    public void tearDown(ITestDevice device, IBuildInfo buildInfo, Throwable e) throws DeviceNotAvailableException {
        if (e instanceof DeviceNotAvailableException) {
            return;
        }
        if (this.mReboot) {
            device.reboot();
        }
        if (this.mUninstall && !this.mUninstallAll) {
            for (String pkgName : this.mInstalledPkgs) {
                String result = device.uninstallPackage(pkgName);
                if (result == null) continue;
                LogUtil.CLog.e((String)"Failed to uninstall %s: %s", (Object[])new Object[]{pkgName, result});
            }
        }
        if (this.mUninstallAll && !this.uninstallAllApps(device)) {
            throw new DeviceNotAvailableException(String.format("Failed to uninstall apps on %s", device.getSerialNumber()), device.getSerialNumber());
        }
    }

    private boolean uninstallAllApps(ITestDevice device) throws DeviceNotAvailableException {
        for (int i = 0; i < 3; ++i) {
            Set<String> pkgs = this.getAllAppsToUninstall(device);
            if (pkgs.isEmpty()) {
                return true;
            }
            for (String pkg : pkgs) {
                String result = device.uninstallPackage(pkg);
                if (result == null) continue;
                LogUtil.CLog.w((String)"Uninstall of %s on %s failed: %s", (Object[])new Object[]{pkg, device.getSerialNumber(), result});
            }
        }
        return this.getAllAppsToUninstall(device).isEmpty();
    }

    private Set<String> getAllAppsToUninstall(ITestDevice device) throws DeviceNotAvailableException {
        Set pkgs = device.getUninstallablePackageNames();
        pkgs.removeAll(this.mSkipUninstallPkgs);
        return pkgs;
    }
}

