/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.postprocessor;

import com.android.os.StatsLog;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.internal.protobuf.Descriptors;
import com.android.tradefed.internal.protobuf.ExtensionRegistryLite;
import com.android.tradefed.internal.protobuf.Message;
import com.android.tradefed.internal.protobuf.MessageOrBuilder;
import com.android.tradefed.internal.protobuf.TextFormat;
import com.android.tradefed.internal.protobuf.util.JsonFormat;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.postprocessor.BasePostProcessor;
import com.android.tradefed.result.ByteArrayInputStreamSource;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.util.ExtensionAtomsRegistry;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@OptionClass(alias="statsd-generic-processor")
public class StatsdGenericPostProcessor
extends BasePostProcessor {
    @Option(name="statsd-report-data-prefix", description="Prefix for identifying a data name that points to a statsd report. Can be repeated. Will also be prepended to the outcoming metric to \"namespace\" them.")
    private Set<String> mReportPrefixes = new HashSet<String>();
    @Option(name="output-statsd-report-proto", description="Output the human-readable proto of the statsd metric reports in the specified format. Can be repeated. Empty (off) by default.Only TEXTPB and JSON are supported at the moment.")
    private Set<LogDataType> mOutputStatsdReportProtoFormats = new HashSet<LogDataType>();
    @VisibleForTesting
    static final String METRIC_SEP = "-";
    @VisibleForTesting
    static final String INDEX_SEP = "#";
    private static final String UID_MAP_FIELD_NAME = "uid_map";
    private static final String STRINGS_FIELD_NAME = "strings";
    private static final ImmutableList<String> FIELDS_TO_SKIP = ImmutableList.of("uid_map", "strings");
    private static final JsonFormat.Printer JSON_PRINTER = JsonFormat.printer();

    public Map<String, MetricMeasurement.Metric.Builder> processTestMetricsAndLogs(TestDescription testDescription, HashMap<String, MetricMeasurement.Metric> testMetrics, Map<String, LogFile> testLogs) {
        return this.processStatsdReportsFromLogs(testLogs, testDescription.toString());
    }

    public Map<String, MetricMeasurement.Metric.Builder> processRunMetricsAndLogs(HashMap<String, MetricMeasurement.Metric> rawMetrics, Map<String, LogFile> runLogs) {
        return this.processStatsdReportsFromLogs(runLogs, "TestRun");
    }

    protected Map<String, MetricMeasurement.Metric.Builder> parseMetricsFromReportList(StatsLog.ConfigMetricsReportList reportList) {
        return this.convertProtoMessage((Message)((Object)reportList));
    }

    private Map<String, MetricMeasurement.Metric.Builder> processStatsdReportsFromLogs(Map<String, LogFile> logs, String testOrRunName) {
        HashMap<String, MetricMeasurement.Metric.Builder> parsedMetrics = new HashMap<String, MetricMeasurement.Metric.Builder>();
        for (String key : logs.keySet()) {
            Optional<String> reportPrefix = this.mReportPrefixes.stream().filter(prefix -> key.startsWith((String)prefix)).findAny();
            if (!reportPrefix.isPresent()) continue;
            File reportFile = new File(logs.get(key).getPath());
            try (FileInputStream reportStream = new FileInputStream(reportFile);){
                StatsLog.ConfigMetricsReportList reportList = StatsLog.ConfigMetricsReportList.parseFrom((InputStream)reportStream, (ExtensionRegistryLite)ExtensionAtomsRegistry.registry);
                if (reportList.getReportsList().isEmpty()) {
                    LogUtil.CLog.i((String)"No reports collected for %s.", (Object[])new Object[]{key});
                    continue;
                }
                block14: for (LogDataType format : this.mOutputStatsdReportProtoFormats) {
                    String dataName = String.format("%s_%s_report", reportPrefix.get(), testOrRunName);
                    switch (format) {
                        case TEXTPB: {
                            this.testLog(dataName, format, (InputStreamSource)new ByteArrayInputStreamSource(TextFormat.printToString((MessageOrBuilder)((Object)reportList)).getBytes()));
                            continue block14;
                        }
                        case JSON: {
                            this.testLog(dataName, format, (InputStreamSource)new ByteArrayInputStreamSource(JSON_PRINTER.print((MessageOrBuilder)((Object)reportList)).getBytes()));
                            continue block14;
                        }
                    }
                    LogUtil.CLog.e((String)"Cannot output statsd report proto with unsupported format %s.", (Object[])new Object[]{format});
                }
                Map<String, MetricMeasurement.Metric.Builder> metricsForReport = this.parseMetricsFromReportList(reportList);
                parsedMetrics.putAll(this.addPrefixToMetrics(metricsForReport, reportPrefix.get()));
            }
            catch (FileNotFoundException e) {
                LogUtil.CLog.e((String)"Report file does not exist at supposed path %s.", (Object[])new Object[]{logs.get(key).getPath()});
            }
            catch (IOException e) {
                LogUtil.CLog.i((String)"Failed to read report file due to error %s.", (Object[])new Object[]{e.toString()});
            }
        }
        return parsedMetrics;
    }

    private Map<String, MetricMeasurement.Metric.Builder> addPrefixToMetrics(Map<String, MetricMeasurement.Metric.Builder> metrics, String prefix) {
        return metrics.entrySet().stream().collect(Collectors.toMap(e -> String.join((CharSequence)METRIC_SEP, prefix, (CharSequence)e.getKey()), e -> (MetricMeasurement.Metric.Builder)e.getValue()));
    }

    protected Map<String, MetricMeasurement.Metric.Builder> convertProtoMessage(Message reportMessage) {
        Map<Descriptors.FieldDescriptor, Object> fields = reportMessage.getAllFields();
        HashMap<String, MetricMeasurement.Metric.Builder> convertedMetrics = new HashMap<String, MetricMeasurement.Metric.Builder>();
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : fields.entrySet()) {
            if (FIELDS_TO_SKIP.contains(entry.getKey().getName())) continue;
            if (entry.getValue() instanceof Message) {
                Map<String, MetricMeasurement.Metric.Builder> messageMetrics = this.convertProtoMessage((Message)entry.getValue());
                for (Map.Entry<String, MetricMeasurement.Metric.Builder> metricEntry : messageMetrics.entrySet()) {
                    convertedMetrics.put(String.join((CharSequence)METRIC_SEP, entry.getKey().getName(), metricEntry.getKey()), metricEntry.getValue());
                }
                continue;
            }
            if (entry.getValue() instanceof List) {
                List listMetrics = (List)entry.getValue();
                for (int i = 0; i < listMetrics.size(); ++i) {
                    String metricKeyRoot;
                    String string = metricKeyRoot = i == 0 ? entry.getKey().getName() : String.join((CharSequence)INDEX_SEP, entry.getKey().getName(), String.valueOf(i + 1));
                    if (listMetrics.get(i) instanceof Message) {
                        Map<String, MetricMeasurement.Metric.Builder> messageMetrics = this.convertProtoMessage((Message)listMetrics.get(i));
                        for (Map.Entry<String, MetricMeasurement.Metric.Builder> metricEntry : messageMetrics.entrySet()) {
                            convertedMetrics.put(String.join((CharSequence)METRIC_SEP, metricKeyRoot, metricEntry.getKey()), metricEntry.getValue());
                        }
                        continue;
                    }
                    convertedMetrics.put(metricKeyRoot, TfMetricProtoUtil.stringToMetric((String)listMetrics.get(i).toString()).toBuilder());
                }
                continue;
            }
            convertedMetrics.put(entry.getKey().getName(), TfMetricProtoUtil.stringToMetric((String)entry.getValue().toString()).toBuilder());
        }
        return convertedMetrics;
    }

    protected MetricMeasurement.DataType getMetricType() {
        return MetricMeasurement.DataType.RAW;
    }
}

