/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.postprocessor;

import com.android.tradefed.config.Option;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.postprocessor.BasePostProcessor;
import com.android.tradefed.result.LogFile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BluetoothConnectionSuccessRatePostProcessor
extends BasePostProcessor {
    private static final int CONNECTION_STATE_CONNECTED = 2;
    private static final int CONNECTION_STATE_CONNECTING = 1;
    private static final String SUCCESS_RATE_KEY_TAG = "-success-rate";
    @Option(name="metric-key-match", description="Key match for a bluetooth connection change metric")
    private String mMetricKeyMatch = "connection_state_changed";

    public Map<String, MetricMeasurement.Metric.Builder> processRunMetricsAndLogs(HashMap<String, MetricMeasurement.Metric> runMetrics, Map<String, LogFile> testLogs) {
        HashMap<String, MetricMeasurement.Metric.Builder> successRateMetrics = new HashMap<String, MetricMeasurement.Metric.Builder>();
        for (String key : runMetrics.keySet()) {
            if (!key.contains(this.mMetricKeyMatch)) continue;
            MetricMeasurement.Metric metric = runMetrics.get(key);
            List connectionStates = metric.getMeasurements().getNumericValues().getNumericValueList();
            Long connectionStateConnectingCount = connectionStates.stream().filter(state -> state == 1L).count();
            Long connectionStateConnectedCount = connectionStates.stream().filter(state -> state == 2L).count();
            if (connectionStateConnectingCount == 0L) {
                LogUtil.CLog.d((String)"Metric %s does not have connecting state reported. Skipping calculating success rate", (Object[])new Object[]{key});
                continue;
            }
            Double successRate = connectionStateConnectedCount.doubleValue() / connectionStateConnectingCount.doubleValue();
            successRateMetrics.put(key + SUCCESS_RATE_KEY_TAG, MetricMeasurement.Metric.newBuilder().setMeasurements(MetricMeasurement.Measurements.newBuilder().setSingleDouble(successRate.doubleValue()).build()));
        }
        return successRateMetrics;
    }
}

